/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.EntryEditorTabList;
import net.sf.jabref.Globals;
import net.sf.jabref.ImportSettingsTab;
import net.sf.jabref.JabRef;
import net.sf.jabref.KeyBinds;
import net.sf.jabref.export.CustomExportList;
import net.sf.jabref.export.ExportComparator;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.gui.CleanUpAction;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.labelPattern.LabelPattern;
import net.sf.jabref.specialfields.SpecialFieldsUtils;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JabRefPreferences {
    private static final Log LOGGER = LogFactory.getLog(JabRefPreferences.class);
    public final HashMap<String, Object> defaults = new HashMap();
    public static final String EMACS_PATH = "emacsPath";
    public static final String EMACS_ADDITIONAL_PARAMETERS = "emacsParameters";
    public static final String EMACS_23 = "emacsUseV23InsertString";
    public static final String FONT_FAMILY = "fontFamily";
    public static final String WIN_LOOK_AND_FEEL = "lookAndFeel";
    public static final String LATEX_EDITOR_PATH = "latexEditorPath";
    public static final String WIN_EDT_PATH = "winEdtPath";
    public static final String SHOW_SHORT = "showShort";
    public static final String LANGUAGE = "language";
    public static final String NAMES_LAST_ONLY = "namesLastOnly";
    public static final String ABBR_AUTHOR_NAMES = "abbrAuthorNames";
    public static final String NAMES_NATBIB = "namesNatbib";
    public static final String NAMES_LAST_FIRST = "namesLf";
    public static final String NAMES_FIRST_LAST = "namesFf";
    public static final String NAMES_AS_IS = "namesAsIs";
    public static final String TABLE_COLOR_CODES_ON = "tableColorCodesOn";
    public static final String ENTRY_EDITOR_HEIGHT = "entryEditorHeight";
    public static final String PREVIEW_PANEL_HEIGHT = "previewPanelHeight";
    public static final String AUTO_RESIZE_MODE = "autoResizeMode";
    public static final String WINDOW_MAXIMISED = "windowMaximised";
    public static final String SIZE_Y = "sizeY";
    public static final String SIZE_X = "sizeX";
    public static final String POS_Y = "posY";
    public static final String POS_X = "posX";
    public static final String VIM_SERVER = "vimServer";
    public static final String VIM = "vim";
    public static final String LYXPIPE = "lyxpipe";
    public static final String USE_DEFAULT_LOOK_AND_FEEL = "useDefaultLookAndFeel";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_HOSTNAME = "proxyHostname";
    public static final String USE_PROXY = "useProxy";
    public static final String PRIMARY_SORT_FIELD = "priSort";
    public static final String PRIMARY_SORT_DESCENDING = "priDescending";
    public static final String SECONDARY_SORT_FIELD = "secSort";
    public static final String SECONDARY_SORT_DESCENDING = "secDescending";
    public static final String TERTIARY_SORT_FIELD = "terSort";
    public static final String TERTIARY_SORT_DESCENDING = "terDescending";
    public static final String SAVE_IN_ORIGINAL_ORDER = "saveInOriginalOrder";
    public static final String SAVE_IN_SPECIFIED_ORDER = "saveInSpecifiedOrder";
    public static final String SAVE_PRIMARY_SORT_FIELD = "savePriSort";
    public static final String SAVE_PRIMARY_SORT_DESCENDING = "savePriDescending";
    public static final String SAVE_SECONDARY_SORT_FIELD = "saveSecSort";
    public static final String SAVE_SECONDARY_SORT_DESCENDING = "saveSecDescending";
    public static final String SAVE_TERTIARY_SORT_FIELD = "saveTerSort";
    public static final String SAVE_TERTIARY_SORT_DESCENDING = "saveTerDescending";
    public static final String EXPORT_IN_ORIGINAL_ORDER = "exportInOriginalOrder";
    public static final String EXPORT_IN_SPECIFIED_ORDER = "exportInSpecifiedOrder";
    public static final String EXPORT_PRIMARY_SORT_FIELD = "exportPriSort";
    public static final String EXPORT_PRIMARY_SORT_DESCENDING = "exportPriDescending";
    public static final String EXPORT_SECONDARY_SORT_FIELD = "exportSecSort";
    public static final String EXPORT_SECONDARY_SORT_DESCENDING = "exportSecDescending";
    public static final String EXPORT_TERTIARY_SORT_FIELD = "exportTerSort";
    public static final String EXPORT_TERTIARY_SORT_DESCENDING = "exportTerDescending";
    public static final String NEWLINE = "newline";
    public static final String COLUMN_WIDTHS = "columnWidths";
    public static final String COLUMN_NAMES = "columnNames";
    public static final String SIDE_PANE_COMPONENT_PREFERRED_POSITIONS = "sidePaneComponentPreferredPositions";
    public static final String SIDE_PANE_COMPONENT_NAMES = "sidePaneComponentNames";
    public static final String XMP_PRIVACY_FILTERS = "xmpPrivacyFilters";
    public static final String USE_XMP_PRIVACY_FILTER = "useXmpPrivacyFilter";
    public static final String SEARCH_AUTO_COMPLETE = "searchAutoComplete";
    public static final String INCREMENT_S = "incrementS";
    public static final String SEARCH_ALL = "searchAll";
    public static final String SEARCH_GEN = "searchGen";
    public static final String SEARCH_OPT = "searchOpt";
    public static final String SEARCH_REQ = "searchReq";
    public static final String CASE_SENSITIVE_SEARCH = "caseSensitiveSearch";
    public static final String DEFAULT_AUTO_SORT = "defaultAutoSort";
    public static final String SHOW_SOURCE = "showSource";
    public static final String DEFAULT_SHOW_SOURCE = "defaultShowSource";
    public static final String STRINGS_SIZE_Y = "stringsSizeY";
    public static final String STRINGS_SIZE_X = "stringsSizeX";
    public static final String STRINGS_POS_Y = "stringsPosY";
    public static final String STRINGS_POS_X = "stringsPosX";
    public static final String LAST_EDITED = "lastEdited";
    public static final String OPEN_LAST_EDITED = "openLastEdited";
    public static final String BACKUP = "backup";
    public static final String ENTRY_TYPE_FORM_WIDTH = "entryTypeFormWidth";
    public static final String ENTRY_TYPE_FORM_HEIGHT_FACTOR = "entryTypeFormHeightFactor";
    public static final String AUTO_OPEN_FORM = "autoOpenForm";
    public static final String FILE_WORKING_DIRECTORY = "fileWorkingDirectory";
    public static final String IMPORT_WORKING_DIRECTORY = "importWorkingDirectory";
    public static final String EXPORT_WORKING_DIRECTORY = "exportWorkingDirectory";
    public static final String WORKING_DIRECTORY = "workingDirectory";
    public static final String NUMBER_COL_WIDTH = "numberColWidth";
    public static final String SHORTEST_TO_COMPLETE = "shortestToComplete";
    public static final String AUTOCOMPLETE_FIRSTNAME_MODE = "autoCompFirstNameMode";
    public static final String AUTOCOMPLETE_FIRSTNAME_MODE_BOTH = "both";
    public static final String AUTO_COMP_LAST_FIRST = "autoCompLF";
    public static final String AUTO_COMP_FIRST_LAST = "autoCompFF";
    public static final String AUTO_COMPLETE_FIELDS = "autoCompleteFields";
    public static final String AUTO_COMPLETE = "autoComplete";
    public static final String SEARCH_PANE_POS_Y = "searchPanePosY";
    public static final String SEARCH_PANE_POS_X = "searchPanePosX";
    public static final String HIGH_LIGHT_WORDS = "highLightWords";
    public static final String REG_EXP_SEARCH = "regExpSearch";
    public static final String SELECT_S = "selectS";
    public static final String EDITOR_EMACS_KEYBINDINGS = "editorEMACSkeyBindings";
    public static final String EDITOR_EMACS_KEYBINDINGS_REBIND_CA = "editorEMACSkeyBindingsRebindCA";
    public static final String EDITOR_EMACS_KEYBINDINGS_REBIND_CF = "editorEMACSkeyBindingsRebindCF";
    public static final String GROUP_SHOW_NUMBER_OF_ELEMENTS = "groupShowNumberOfElements";
    public static final String GROUP_AUTO_HIDE = "groupAutoHide";
    public static final String GROUP_AUTO_SHOW = "groupAutoShow";
    public static final String GROUP_EXPAND_TREE = "groupExpandTree";
    public static final String GROUP_SHOW_DYNAMIC = "groupShowDynamic";
    public static final String GROUP_SHOW_ICONS = "groupShowIcons";
    public static final String GROUPS_DEFAULT_FIELD = "groupsDefaultField";
    public static final String GROUP_SELECT_MATCHES = "groupSelectMatches";
    public static final String GROUP_SHOW_OVERLAPPING = "groupShowOverlapping";
    public static final String GROUP_INVERT_SELECTIONS = "groupInvertSelections";
    public static final String GROUP_INTERSECT_SELECTIONS = "groupIntersectSelections";
    public static final String GROUP_FLOAT_SELECTIONS = "groupFloatSelections";
    public static final String GROUP_SELECTOR_VISIBLE = "groupSelectorVisible";
    public static final String EDIT_GROUP_MEMBERSHIP_MODE = "groupEditGroupMembershipMode";
    public static final String GROUP_KEYWORD_SEPARATOR = "groupKeywordSeparator";
    public static final String AUTO_ASSIGN_GROUP = "autoAssignGroup";
    public static final String LIST_OF_FILE_COLUMNS = "listOfFileColumns";
    public static final String EXTRA_FILE_COLUMNS = "extraFileColumns";
    public static final String ARXIV_COLUMN = "arxivColumn";
    public static final String FILE_COLUMN = "fileColumn";
    public static final String PREFER_URL_DOI = "preferUrlDoi";
    public static final String URL_COLUMN = "urlColumn";
    public static final String PDF_COLUMN = "pdfColumn";
    public static final String DISABLE_ON_MULTIPLE_SELECTION = "disableOnMultipleSelection";
    public static final String CTRL_CLICK = "ctrlClick";
    public static final String ANTIALIAS = "antialias";
    public static final String INCOMPLETE_ENTRY_BACKGROUND = "incompleteEntryBackground";
    public static final String FIELD_EDITOR_TEXT_COLOR = "fieldEditorTextColor";
    public static final String ACTIVE_FIELD_EDITOR_BACKGROUND_COLOR = "activeFieldEditorBackgroundColor";
    public static final String INVALID_FIELD_BACKGROUND_COLOR = "invalidFieldBackgroundColor";
    public static final String VALID_FIELD_BACKGROUND_COLOR = "validFieldBackgroundColor";
    public static final String MARKED_ENTRY_BACKGROUND5 = "markedEntryBackground5";
    public static final String MARKED_ENTRY_BACKGROUND4 = "markedEntryBackground4";
    public static final String MARKED_ENTRY_BACKGROUND3 = "markedEntryBackground3";
    public static final String MARKED_ENTRY_BACKGROUND2 = "markedEntryBackground2";
    public static final String MARKED_ENTRY_BACKGROUND1 = "markedEntryBackground1";
    public static final String MARKED_ENTRY_BACKGROUND0 = "markedEntryBackground0";
    public static final String VERY_GRAYED_OUT_TEXT = "veryGrayedOutText";
    public static final String VERY_GRAYED_OUT_BACKGROUND = "veryGrayedOutBackground";
    public static final String GRAYED_OUT_TEXT = "grayedOutText";
    public static final String GRAYED_OUT_BACKGROUND = "grayedOutBackground";
    public static final String GRID_COLOR = "gridColor";
    public static final String TABLE_TEXT = "tableText";
    public static final String TABLE_OPT_FIELD_BACKGROUND = "tableOptFieldBackground";
    public static final String TABLE_REQ_FIELD_BACKGROUND = "tableReqFieldBackground";
    public static final String TABLE_BACKGROUND = "tableBackground";
    public static final String TABLE_SHOW_GRID = "tableShowGrid";
    public static final String TABLE_ROW_PADDING = "tableRowPadding";
    public static final String MENU_FONT_SIZE = "menuFontSize";
    public static final String MENU_FONT_STYLE = "menuFontStyle";
    public static final String MENU_FONT_FAMILY = "menuFontFamily";
    public static final String OVERRIDE_DEFAULT_FONTS = "overrideDefaultFonts";
    public static final String FONT_SIZE = "fontSize";
    public static final String FONT_STYLE = "fontStyle";
    public static final String HISTORY_SIZE = "historySize";
    public static final String CUSTOM_ICON_THEME_FILE = "customIconThemeFile";
    public static final String USE_CUSTOM_ICON_THEME = "useCustomIconTheme";
    public static final String GENERAL_FIELDS = "generalFields";
    public static final String RENAME_ON_MOVE_FILE_TO_FILE_DIR = "renameOnMoveFileToFileDir";
    public static final String MEMORY_STICK_MODE = "memoryStickMode";
    public static final String PRESERVE_FIELD_FORMATTING = "preserveFieldFormatting";
    public static final String DEFAULT_OWNER = "defaultOwner";
    public static final String GROUPS_VISIBLE_ROWS = "groupsVisibleRows";
    public static final String DEFAULT_ENCODING = "defaultEncoding";
    public static final String SEARCH_PANEL_VISIBLE = "searchPanelVisible";
    public static final String TOOLBAR_VISIBLE = "toolbarVisible";
    public static final String HIGHLIGHT_GROUPS_MATCHING_ALL = "highlightGroupsMatchingAll";
    public static final String HIGHLIGHT_GROUPS_MATCHING_ANY = "highlightGroupsMatchingAny";
    public static final String SHOW_ONE_LETTER_HEADING_FOR_ICON_COLUMNS = "showOneLetterHeadingForIconColumns";
    public static final String UPDATE_TIMESTAMP = "updateTimestamp";
    public static final String TIME_STAMP_FIELD = "timeStampField";
    public static final String TIME_STAMP_FORMAT = "timeStampFormat";
    public static final String OVERWRITE_TIME_STAMP = "overwriteTimeStamp";
    public static final String USE_TIME_STAMP = "useTimeStamp";
    public static final String WARN_ABOUT_DUPLICATES_IN_INSPECTION = "warnAboutDuplicatesInInspection";
    public static final String UNMARK_ALL_ENTRIES_BEFORE_IMPORTING = "unmarkAllEntriesBeforeImporting";
    public static final String MARK_IMPORTED_ENTRIES = "markImportedEntries";
    public static final String GENERATE_KEYS_AFTER_INSPECTION = "generateKeysAfterInspection";
    public static final String USE_IMPORT_INSPECTION_DIALOG_FOR_SINGLE = "useImportInspectionDialogForSingle";
    public static final String USE_IMPORT_INSPECTION_DIALOG = "useImportInspectionDialog";
    public static final String NON_WRAPPABLE_FIELDS = "nonWrappableFields";
    public static final String PUT_BRACES_AROUND_CAPITALS = "putBracesAroundCapitals";
    public static final String RESOLVE_STRINGS_ALL_FIELDS = "resolveStringsAllFields";
    public static final String DO_NOT_RESOLVE_STRINGS_FOR = "doNotResolveStringsFor";
    public static final String AUTO_DOUBLE_BRACES = "autoDoubleBraces";
    public static final String PREVIEW_PRINT_BUTTON = "previewPrintButton";
    public static final String PREVIEW_1 = "preview1";
    public static final String PREVIEW_0 = "preview0";
    public static final String ACTIVE_PREVIEW = "activePreview";
    public static final String PREVIEW_ENABLED = "previewEnabled";
    public static final String DEFAULT_LABEL_PATTERN = "defaultLabelPattern";
    public static final String SEARCH_ALL_BASES = "searchAllBases";
    public static final String SHOW_SEARCH_IN_DIALOG = "showSearchInDialog";
    public static final String FLOAT_SEARCH = "floatSearch";
    public static final String GRAY_OUT_NON_HITS = "grayOutNonHits";
    public static final String CONFIRM_DELETE = "confirmDelete";
    public static final String WARN_BEFORE_OVERWRITING_KEY = "warnBeforeOverwritingKey";
    public static final String AVOID_OVERWRITING_KEY = "avoidOverwritingKey";
    public static final String DISPLAY_KEY_WARNING_DIALOG_AT_STARTUP = "displayKeyWarningDialogAtStartup";
    public static final String DIALOG_WARNING_FOR_EMPTY_KEY = "dialogWarningForEmptyKey";
    public static final String DIALOG_WARNING_FOR_DUPLICATE_KEY = "dialogWarningForDuplicateKey";
    public static final String ALLOW_TABLE_EDITING = "allowTableEditing";
    public static final String OVERWRITE_OWNER = "overwriteOwner";
    public static final String USE_OWNER = "useOwner";
    public static final String WRITEFIELD_ADDSPACES = "writeFieldAddSpaces";
    public static final String WRITEFIELD_CAMELCASENAME = "writeFieldCamelCase";
    public static final String WRITEFIELD_SORTSTYLE = "writefieldSortStyle";
    public static final String WRITEFIELD_USERDEFINEDORDER = "writefieldUserdefinedOrder";
    public static final String WRITEFIELD_WRAPFIELD = "wrapFieldLine";
    public static final String AUTOLINK_EXACT_KEY_ONLY = "autolinkExactKeyOnly";
    public static final String SHOW_FILE_LINKS_UPGRADE_WARNING = "showFileLinksUpgradeWarning";
    public static final String SEARCH_DIALOG_HEIGHT = "searchDialogHeight";
    public static final String SEARCH_DIALOG_WIDTH = "searchDialogWidth";
    public static final String IMPORT_INSPECTION_DIALOG_HEIGHT = "importInspectionDialogHeight";
    public static final String IMPORT_INSPECTION_DIALOG_WIDTH = "importInspectionDialogWidth";
    public static final String SIDE_PANE_WIDTH = "sidePaneWidth";
    public static final String LAST_USED_EXPORT = "lastUsedExport";
    public static final String FILECHOOSER_DISABLE_RENAME = "filechooserDisableRename";
    public static final String USE_NATIVE_FILE_DIALOG_ON_MAC = "useNativeFileDialogOnMac";
    public static final String FLOAT_MARKED_ENTRIES = "floatMarkedEntries";
    public static final String CITE_COMMAND_LED = "citeCommandLed";
    public static final String CITE_COMMAND_WIN_EDT = "citeCommandWinEdt";
    public static final String CITE_COMMAND_EMACS = "citeCommandEmacs";
    public static final String CITE_COMMAND_VIM = "citeCommandVim";
    public static final String CITE_COMMAND = "citeCommand";
    public static final String EXTERNAL_JOURNAL_LISTS = "externalJournalLists";
    public static final String PERSONAL_JOURNAL_LIST = "personalJournalList";
    public static final String GENERATE_KEYS_BEFORE_SAVING = "generateKeysBeforeSaving";
    public static final String EMAIL_SUBJECT = "emailSubject";
    public static final String OPEN_FOLDERS_OF_ATTACHED_FILES = "openFoldersOfAttachedFiles";
    public static final String KEY_GEN_ALWAYS_ADD_LETTER = "keyGenAlwaysAddLetter";
    public static final String KEY_GEN_FIRST_LETTER_A = "keyGenFirstLetterA";
    public static final String INCLUDE_EMPTY_FIELDS = "includeEmptyFields";
    public static final String VALUE_DELIMITERS2 = "valueDelimiters";
    public static final String BIBLATEX_MODE = "biblatexMode";
    public static final String ENFORCE_LEGAL_BIBTEX_KEY = "enforceLegalBibtexKey";
    public static final String DELETE_PLUGINS = "deletePlugins";
    public static final String PROMPT_BEFORE_USING_AUTOSAVE = "promptBeforeUsingAutosave";
    public static final String AUTO_SAVE_INTERVAL = "autoSaveInterval";
    public static final String AUTO_SAVE = "autoSave";
    public static final String USE_LOCK_FILES = "useLockFiles";
    public static final String RUN_AUTOMATIC_FILE_SEARCH = "runAutomaticFileSearch";
    public static final String NUMERIC_FIELDS = "numericFields";
    public static final String DEFAULT_REG_EXP_SEARCH_EXPRESSION_KEY = "defaultRegExpSearchExpression";
    public static final String REG_EXP_SEARCH_EXPRESSION_KEY = "regExpSearchExpression";
    public static final String USE_REG_EXP_SEARCH_KEY = "useRegExpSearch";
    public static final String DB_CONNECT_USERNAME = "dbConnectUsername";
    public static final String DB_CONNECT_DATABASE = "dbConnectDatabase";
    public static final String DB_CONNECT_HOSTNAME = "dbConnectHostname";
    public static final String DB_CONNECT_SERVER_TYPE = "dbConnectServerType";
    public static final String BIB_LOC_AS_PRIMARY_DIR = "bibLocAsPrimaryDir";
    public static final String BIB_LOCATION_AS_FILE_DIR = "bibLocationAsFileDir";
    public static final String SELECTED_FETCHER_INDEX = "selectedFetcherIndex";
    public static final String WEB_SEARCH_VISIBLE = "webSearchVisible";
    public static final String ALLOW_FILE_AUTO_OPEN_BROWSE = "allowFileAutoOpenBrowse";
    public static final String CUSTOM_TAB_NAME = "customTabName_";
    public static final String CUSTOM_TAB_FIELDS = "customTabFields_";
    public static final String USER_FILE_DIR_INDIVIDUAL = "userFileDirIndividual";
    public static final String USER_FILE_DIR_IND_LEGACY = "userFileDirInd_Legacy";
    public static final String USER_FILE_DIR = "userFileDir";
    public static final String USE_UNIT_FORMATTER_ON_SEARCH = "useUnitFormatterOnSearch";
    public static final String USE_CASE_KEEPER_ON_SEARCH = "useCaseKeeperOnSearch";
    public static final String USE_CONVERT_TO_EQUATION = "useConvertToEquation";
    public static final String USE_IEEE_ABRV = "useIEEEAbrv";
    private static final String CUSTOM_TYPE_NAME = "customTypeName_";
    private static final String CUSTOM_TYPE_REQ = "customTypeReq_";
    private static final String CUSTOM_TYPE_OPT = "customTypeOpt_";
    private static final String CUSTOM_TYPE_PRIOPT = "customTypePriOpt_";
    public static final String PDF_PREVIEW = "pdfPreview";
    public static final String AUTOCOMPLETE_FIRSTNAME_MODE_ONLY_FULL = "fullOnly";
    public static final String AUTOCOMPLETE_FIRSTNAME_MODE_ONLY_ABBR = "abbrOnly";
    private static final String FILE_TYPE_REMOVED_FLAG = "REMOVED";
    private static final char[][] VALUE_DELIMITERS = new char[][]{{'\"', '\"'}, {'{', '}'}};
    public String WRAPPED_USERNAME;
    public final String MARKING_WITH_NUMBER_PATTERN;
    private final Preferences prefs;
    private KeyBinds keyBinds = new KeyBinds();
    private KeyBinds defaultKeyBinds = new KeyBinds();
    private final HashSet<String> putBracesAroundCapitalsFields = new HashSet(4);
    private final HashSet<String> nonWrappableFields = new HashSet(5);
    private static LabelPattern keyPattern;
    public final CustomExportList customExports;
    public final CustomImportList customImports;
    private EntryEditorTabList tabList = null;
    private final TreeSet<ExternalFileType> externalFileTypes = new TreeSet();
    private final ExternalFileType HTML_FALLBACK_TYPE = new ExternalFileType("URL", "html", "text/html", "", "www");
    public String[] fileDirForDatabase = null;
    public File databaseFile = null;
    public HashMap<String, String> customExportNameFormatters = null;
    private static JabRefPreferences singleton;

    public static JabRefPreferences getInstance() {
        if (singleton == null) {
            singleton = new JabRefPreferences();
        }
        return singleton;
    }

    private void upgradeOldPreferences() {
        if (this.prefs.get(SAVE_IN_SPECIFIED_ORDER, null) == null) {
            if (this.prefs.getBoolean("saveInStandardOrder", false)) {
                this.putBoolean(SAVE_IN_SPECIFIED_ORDER, true);
                this.put(SAVE_PRIMARY_SORT_FIELD, "author");
                this.put(SAVE_SECONDARY_SORT_FIELD, "editor");
                this.put(SAVE_TERTIARY_SORT_FIELD, "year");
                this.putBoolean(SAVE_PRIMARY_SORT_DESCENDING, false);
                this.putBoolean(SAVE_SECONDARY_SORT_DESCENDING, false);
                this.putBoolean(SAVE_TERTIARY_SORT_DESCENDING, false);
            } else if (this.prefs.getBoolean("saveInTitleOrder", false)) {
                this.putBoolean(SAVE_IN_SPECIFIED_ORDER, true);
                this.put(SAVE_PRIMARY_SORT_FIELD, "title");
                this.put(SAVE_SECONDARY_SORT_FIELD, "author");
                this.put(SAVE_TERTIARY_SORT_FIELD, "editor");
                this.putBoolean(SAVE_PRIMARY_SORT_DESCENDING, false);
                this.putBoolean(SAVE_SECONDARY_SORT_DESCENDING, false);
                this.putBoolean(SAVE_TERTIARY_SORT_DESCENDING, false);
            }
        }
        if (this.prefs.get(EXPORT_IN_SPECIFIED_ORDER, null) == null) {
            if (this.prefs.getBoolean("exportInStandardOrder", false)) {
                this.putBoolean(EXPORT_IN_SPECIFIED_ORDER, true);
                this.put(EXPORT_PRIMARY_SORT_FIELD, "author");
                this.put(EXPORT_SECONDARY_SORT_FIELD, "editor");
                this.put(EXPORT_TERTIARY_SORT_FIELD, "year");
                this.putBoolean(EXPORT_PRIMARY_SORT_DESCENDING, false);
                this.putBoolean(EXPORT_SECONDARY_SORT_DESCENDING, false);
                this.putBoolean(EXPORT_TERTIARY_SORT_DESCENDING, false);
            } else if (this.prefs.getBoolean("exportInTitleOrder", false)) {
                this.putBoolean(EXPORT_IN_SPECIFIED_ORDER, true);
                this.put(EXPORT_PRIMARY_SORT_FIELD, "title");
                this.put(EXPORT_SECONDARY_SORT_FIELD, "author");
                this.put(EXPORT_TERTIARY_SORT_FIELD, "editor");
                this.putBoolean(EXPORT_PRIMARY_SORT_DESCENDING, false);
                this.putBoolean(EXPORT_SECONDARY_SORT_DESCENDING, false);
                this.putBoolean(EXPORT_TERTIARY_SORT_DESCENDING, false);
            }
        }
    }

    private JabRefPreferences() {
        try {
            if (new File("jabref.xml").exists()) {
                this.importPreferences("jabref.xml");
            }
        }
        catch (IOException iOException) {
            LOGGER.info("Could not import preferences from jabref.xml:" + iOException.getLocalizedMessage(), iOException);
        }
        this.prefs = Preferences.userNodeForPackage(JabRef.class);
        this.upgradeOldPreferences();
        if (Globals.osName.equals("Mac OS X")) {
            this.defaults.put(EMACS_PATH, "emacsclient");
            this.defaults.put(EMACS_23, true);
            this.defaults.put(EMACS_ADDITIONAL_PARAMETERS, "-n -e");
            this.defaults.put(FONT_FAMILY, "SansSerif");
            this.defaults.put(WIN_LOOK_AND_FEEL, UIManager.getSystemLookAndFeelClassName());
        } else if (Globals.osName.toLowerCase().startsWith("windows")) {
            this.defaults.put(WIN_LOOK_AND_FEEL, "com.jgoodies.looks.windows.WindowsLookAndFeel");
            this.defaults.put(WIN_EDT_PATH, "C:\\Program Files\\WinEdt Team\\WinEdt\\WinEdt.exe");
            this.defaults.put(LATEX_EDITOR_PATH, "C:\\Program Files\\LEd\\LEd.exe");
            this.defaults.put(EMACS_PATH, "emacsclient.exe");
            this.defaults.put(EMACS_23, true);
            this.defaults.put(EMACS_ADDITIONAL_PARAMETERS, "-n -e");
            this.defaults.put(FONT_FAMILY, "Arial");
        } else {
            this.defaults.put(WIN_LOOK_AND_FEEL, "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
            this.defaults.put(FONT_FAMILY, "SansSerif");
            this.defaults.put(EMACS_PATH, "gnuclient");
            this.defaults.put(EMACS_23, false);
            this.defaults.put(EMACS_ADDITIONAL_PARAMETERS, "-batch -eval");
        }
        this.defaults.put(USE_PROXY, Boolean.FALSE);
        this.defaults.put(PROXY_HOSTNAME, "my proxy host");
        this.defaults.put(PROXY_PORT, "my proxy port");
        this.defaults.put(PDF_PREVIEW, Boolean.FALSE);
        this.defaults.put(USE_DEFAULT_LOOK_AND_FEEL, Boolean.TRUE);
        this.defaults.put(LYXPIPE, System.getProperty("user.home") + File.separator + ".lyx/lyxpipe");
        this.defaults.put(VIM, VIM);
        this.defaults.put(VIM_SERVER, VIM);
        this.defaults.put(POS_X, 0);
        this.defaults.put(POS_Y, 0);
        this.defaults.put(SIZE_X, 840);
        this.defaults.put(SIZE_Y, 680);
        this.defaults.put(WINDOW_MAXIMISED, Boolean.FALSE);
        this.defaults.put(AUTO_RESIZE_MODE, 4);
        this.defaults.put(PREVIEW_PANEL_HEIGHT, 200);
        this.defaults.put(ENTRY_EDITOR_HEIGHT, 400);
        this.defaults.put(TABLE_COLOR_CODES_ON, Boolean.TRUE);
        this.defaults.put(NAMES_AS_IS, Boolean.FALSE);
        this.defaults.put(NAMES_FIRST_LAST, Boolean.FALSE);
        this.defaults.put(NAMES_LAST_FIRST, Boolean.FALSE);
        this.defaults.put(NAMES_NATBIB, Boolean.TRUE);
        this.defaults.put(ABBR_AUTHOR_NAMES, Boolean.TRUE);
        this.defaults.put(NAMES_LAST_ONLY, Boolean.TRUE);
        this.defaults.put(LANGUAGE, "en");
        this.defaults.put(SHOW_SHORT, Boolean.TRUE);
        this.defaults.put(PRIMARY_SORT_FIELD, "author");
        this.defaults.put(PRIMARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(SECONDARY_SORT_FIELD, "year");
        this.defaults.put(SECONDARY_SORT_DESCENDING, Boolean.TRUE);
        this.defaults.put(TERTIARY_SORT_FIELD, "author");
        this.defaults.put(TERTIARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(SAVE_IN_ORIGINAL_ORDER, Boolean.FALSE);
        this.defaults.put(SAVE_IN_SPECIFIED_ORDER, Boolean.FALSE);
        this.defaults.put(SAVE_PRIMARY_SORT_FIELD, "bibtexkey");
        this.defaults.put(SAVE_PRIMARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(SAVE_SECONDARY_SORT_FIELD, "author");
        this.defaults.put(SAVE_SECONDARY_SORT_DESCENDING, Boolean.TRUE);
        this.defaults.put(SAVE_TERTIARY_SORT_FIELD, "");
        this.defaults.put(SAVE_TERTIARY_SORT_DESCENDING, Boolean.TRUE);
        this.defaults.put(EXPORT_IN_ORIGINAL_ORDER, Boolean.FALSE);
        this.defaults.put(EXPORT_IN_SPECIFIED_ORDER, Boolean.FALSE);
        this.defaults.put(EXPORT_PRIMARY_SORT_FIELD, "bibtexkey");
        this.defaults.put(EXPORT_PRIMARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(EXPORT_SECONDARY_SORT_FIELD, "author");
        this.defaults.put(EXPORT_SECONDARY_SORT_DESCENDING, Boolean.TRUE);
        this.defaults.put(EXPORT_TERTIARY_SORT_FIELD, "");
        this.defaults.put(EXPORT_TERTIARY_SORT_DESCENDING, Boolean.TRUE);
        this.defaults.put(NEWLINE, System.getProperty("line.separator"));
        this.defaults.put(SIDE_PANE_COMPONENT_NAMES, "");
        this.defaults.put(SIDE_PANE_COMPONENT_PREFERRED_POSITIONS, "");
        this.defaults.put(COLUMN_NAMES, "entrytype;author;title;year;journal;owner;timestamp;bibtexkey");
        this.defaults.put(COLUMN_WIDTHS, "75;280;400;60;100;100;100;100");
        this.defaults.put("ActivatePersistenceTableColumnListener", true);
        this.defaults.put(XMP_PRIVACY_FILTERS, "pdf;timestamp;keywords;owner;note;review");
        this.defaults.put(USE_XMP_PRIVACY_FILTER, Boolean.FALSE);
        this.defaults.put(NUMBER_COL_WIDTH, 32);
        this.defaults.put(WORKING_DIRECTORY, System.getProperty("user.home"));
        this.defaults.put(EXPORT_WORKING_DIRECTORY, System.getProperty("user.home"));
        this.defaults.put(IMPORT_WORKING_DIRECTORY, System.getProperty("user.home"));
        this.defaults.put(FILE_WORKING_DIRECTORY, System.getProperty("user.home"));
        this.defaults.put(AUTO_OPEN_FORM, Boolean.TRUE);
        this.defaults.put(ENTRY_TYPE_FORM_HEIGHT_FACTOR, 1);
        this.defaults.put(ENTRY_TYPE_FORM_WIDTH, 1);
        this.defaults.put(BACKUP, Boolean.TRUE);
        this.defaults.put(OPEN_LAST_EDITED, Boolean.TRUE);
        this.defaults.put(LAST_EDITED, null);
        this.defaults.put(STRINGS_POS_X, 0);
        this.defaults.put(STRINGS_POS_Y, 0);
        this.defaults.put(STRINGS_SIZE_X, 600);
        this.defaults.put(STRINGS_SIZE_Y, 400);
        this.defaults.put(DEFAULT_SHOW_SOURCE, Boolean.FALSE);
        this.defaults.put(SHOW_SOURCE, Boolean.TRUE);
        this.defaults.put(DEFAULT_AUTO_SORT, Boolean.FALSE);
        this.defaults.put(CASE_SENSITIVE_SEARCH, Boolean.FALSE);
        this.defaults.put(SEARCH_REQ, Boolean.TRUE);
        this.defaults.put(SEARCH_OPT, Boolean.TRUE);
        this.defaults.put(SEARCH_GEN, Boolean.TRUE);
        this.defaults.put(SEARCH_ALL, Boolean.FALSE);
        this.defaults.put(INCREMENT_S, Boolean.FALSE);
        this.defaults.put(SEARCH_AUTO_COMPLETE, Boolean.TRUE);
        this.defaults.put(SELECT_S, Boolean.FALSE);
        this.defaults.put(REG_EXP_SEARCH, Boolean.TRUE);
        this.defaults.put(HIGH_LIGHT_WORDS, Boolean.TRUE);
        this.defaults.put(SEARCH_PANE_POS_X, 0);
        this.defaults.put(SEARCH_PANE_POS_Y, 0);
        this.defaults.put(EDITOR_EMACS_KEYBINDINGS, Boolean.FALSE);
        this.defaults.put(EDITOR_EMACS_KEYBINDINGS_REBIND_CA, Boolean.TRUE);
        this.defaults.put(EDITOR_EMACS_KEYBINDINGS_REBIND_CF, Boolean.TRUE);
        this.defaults.put(AUTO_COMPLETE, Boolean.TRUE);
        this.defaults.put(AUTO_COMPLETE_FIELDS, "author;editor;title;journal;publisher;keywords;crossref");
        this.defaults.put(AUTO_COMP_FIRST_LAST, Boolean.FALSE);
        this.defaults.put(AUTO_COMP_LAST_FIRST, Boolean.FALSE);
        this.defaults.put(SHORTEST_TO_COMPLETE, 2);
        this.defaults.put(AUTOCOMPLETE_FIRSTNAME_MODE, AUTOCOMPLETE_FIRSTNAME_MODE_BOTH);
        this.defaults.put(GROUP_SELECTOR_VISIBLE, Boolean.TRUE);
        this.defaults.put(GROUP_FLOAT_SELECTIONS, Boolean.TRUE);
        this.defaults.put(GROUP_INTERSECT_SELECTIONS, Boolean.TRUE);
        this.defaults.put(GROUP_INVERT_SELECTIONS, Boolean.FALSE);
        this.defaults.put(GROUP_SHOW_OVERLAPPING, Boolean.FALSE);
        this.defaults.put(GROUP_SELECT_MATCHES, Boolean.FALSE);
        this.defaults.put(GROUPS_DEFAULT_FIELD, "keywords");
        this.defaults.put(GROUP_SHOW_ICONS, Boolean.TRUE);
        this.defaults.put(GROUP_SHOW_DYNAMIC, Boolean.TRUE);
        this.defaults.put(GROUP_EXPAND_TREE, Boolean.TRUE);
        this.defaults.put(GROUP_AUTO_SHOW, Boolean.TRUE);
        this.defaults.put(GROUP_AUTO_HIDE, Boolean.TRUE);
        this.defaults.put(GROUP_SHOW_NUMBER_OF_ELEMENTS, Boolean.FALSE);
        this.defaults.put(AUTO_ASSIGN_GROUP, Boolean.TRUE);
        this.defaults.put(GROUP_KEYWORD_SEPARATOR, ", ");
        this.defaults.put(EDIT_GROUP_MEMBERSHIP_MODE, Boolean.FALSE);
        this.defaults.put(HIGHLIGHT_GROUPS_MATCHING_ANY, Boolean.FALSE);
        this.defaults.put(HIGHLIGHT_GROUPS_MATCHING_ALL, Boolean.FALSE);
        this.defaults.put(TOOLBAR_VISIBLE, Boolean.TRUE);
        this.defaults.put(SEARCH_PANEL_VISIBLE, Boolean.FALSE);
        this.defaults.put(DEFAULT_ENCODING, System.getProperty("file.encoding"));
        this.defaults.put(GROUPS_VISIBLE_ROWS, 8);
        this.defaults.put(DEFAULT_OWNER, System.getProperty("user.name"));
        this.defaults.put(PRESERVE_FIELD_FORMATTING, Boolean.FALSE);
        this.defaults.put(MEMORY_STICK_MODE, Boolean.FALSE);
        this.defaults.put(RENAME_ON_MOVE_FILE_TO_FILE_DIR, Boolean.TRUE);
        this.defaults.put(GENERAL_FIELDS, "crossref;keywords;file;doi;url;urldate;pdf;comment;owner");
        this.defaults.put(USE_CUSTOM_ICON_THEME, Boolean.FALSE);
        this.defaults.put(CUSTOM_ICON_THEME_FILE, "/home/alver/div/crystaltheme_16/Icons.properties");
        this.defaults.put(HISTORY_SIZE, 8);
        this.defaults.put(FONT_STYLE, 0);
        this.defaults.put(FONT_SIZE, 12);
        this.defaults.put(OVERRIDE_DEFAULT_FONTS, Boolean.FALSE);
        this.defaults.put(MENU_FONT_FAMILY, "Times");
        this.defaults.put(MENU_FONT_STYLE, 0);
        this.defaults.put(MENU_FONT_SIZE, 11);
        this.defaults.put(TABLE_ROW_PADDING, 8);
        this.defaults.put(TABLE_SHOW_GRID, Boolean.FALSE);
        this.defaults.put(TABLE_BACKGROUND, "255:255:255");
        this.defaults.put(TABLE_REQ_FIELD_BACKGROUND, "230:235:255");
        this.defaults.put(TABLE_OPT_FIELD_BACKGROUND, "230:255:230");
        this.defaults.put(TABLE_TEXT, "0:0:0");
        this.defaults.put(GRID_COLOR, "210:210:210");
        this.defaults.put(GRAYED_OUT_BACKGROUND, "210:210:210");
        this.defaults.put(GRAYED_OUT_TEXT, "40:40:40");
        this.defaults.put(VERY_GRAYED_OUT_BACKGROUND, "180:180:180");
        this.defaults.put(VERY_GRAYED_OUT_TEXT, "40:40:40");
        this.defaults.put(MARKED_ENTRY_BACKGROUND0, "255:255:180");
        this.defaults.put(MARKED_ENTRY_BACKGROUND1, "255:220:180");
        this.defaults.put(MARKED_ENTRY_BACKGROUND2, "255:180:160");
        this.defaults.put(MARKED_ENTRY_BACKGROUND3, "255:120:120");
        this.defaults.put(MARKED_ENTRY_BACKGROUND4, "255:75:75");
        this.defaults.put(MARKED_ENTRY_BACKGROUND5, "220:255:220");
        this.defaults.put(VALID_FIELD_BACKGROUND_COLOR, "255:255:255");
        this.defaults.put(INVALID_FIELD_BACKGROUND_COLOR, "255:0:0");
        this.defaults.put(ACTIVE_FIELD_EDITOR_BACKGROUND_COLOR, "220:220:255");
        this.defaults.put(FIELD_EDITOR_TEXT_COLOR, "0:0:0");
        this.defaults.put(INCOMPLETE_ENTRY_BACKGROUND, "250:175:175");
        this.defaults.put(ANTIALIAS, Boolean.FALSE);
        this.defaults.put(CTRL_CLICK, Boolean.FALSE);
        this.defaults.put(DISABLE_ON_MULTIPLE_SELECTION, Boolean.FALSE);
        this.defaults.put(PDF_COLUMN, Boolean.FALSE);
        this.defaults.put(URL_COLUMN, Boolean.TRUE);
        this.defaults.put(PREFER_URL_DOI, Boolean.FALSE);
        this.defaults.put(FILE_COLUMN, Boolean.TRUE);
        this.defaults.put(ARXIV_COLUMN, Boolean.FALSE);
        this.defaults.put(EXTRA_FILE_COLUMNS, Boolean.FALSE);
        this.defaults.put(LIST_OF_FILE_COLUMNS, "");
        this.defaults.put("specialFieldsEnabled", SpecialFieldsUtils.PREF_SPECIALFIELDSENABLED_DEFAULT);
        this.defaults.put("showPriorityColumn", SpecialFieldsUtils.PREF_SHOWCOLUMN_PRIORITY_DEFAULT);
        this.defaults.put("showQualityColumn", SpecialFieldsUtils.PREF_SHOWCOLUMN_QUALITY_DEFAULT);
        this.defaults.put("showRankingColumn", SpecialFieldsUtils.PREF_SHOWCOLUMN_RANKING_DEFAULT);
        this.defaults.put("compactRankingColumn", SpecialFieldsUtils.PREF_RANKING_COMPACT_DEFAULT);
        this.defaults.put("showRelevanceColumn", SpecialFieldsUtils.PREF_SHOWCOLUMN_RELEVANCE_DEFAULT);
        this.defaults.put("showPrintedColumn", SpecialFieldsUtils.PREF_SHOWCOLUMN_PRINTED_DEFAULT);
        this.defaults.put("showReadColumn", SpecialFieldsUtils.PREF_SHOWCOLUMN_READ_DEFAULT);
        this.defaults.put("autoSyncSpecialFieldsToKeywords", SpecialFieldsUtils.PREF_AUTOSYNCSPECIALFIELDSTOKEYWORDS_DEFAULT);
        this.defaults.put("serializeSpecialFields", SpecialFieldsUtils.PREF_SERIALIZESPECIALFIELDS_DEFAULT);
        this.defaults.put(SHOW_ONE_LETTER_HEADING_FOR_ICON_COLUMNS, Boolean.FALSE);
        this.defaults.put(USE_OWNER, Boolean.FALSE);
        this.defaults.put(OVERWRITE_OWNER, Boolean.FALSE);
        this.defaults.put(ALLOW_TABLE_EDITING, Boolean.FALSE);
        this.defaults.put(DIALOG_WARNING_FOR_DUPLICATE_KEY, Boolean.TRUE);
        this.defaults.put(DIALOG_WARNING_FOR_EMPTY_KEY, Boolean.TRUE);
        this.defaults.put(DISPLAY_KEY_WARNING_DIALOG_AT_STARTUP, Boolean.TRUE);
        this.defaults.put(AVOID_OVERWRITING_KEY, Boolean.FALSE);
        this.defaults.put(WARN_BEFORE_OVERWRITING_KEY, Boolean.TRUE);
        this.defaults.put(CONFIRM_DELETE, Boolean.TRUE);
        this.defaults.put(GRAY_OUT_NON_HITS, Boolean.TRUE);
        this.defaults.put(FLOAT_SEARCH, Boolean.TRUE);
        this.defaults.put(SHOW_SEARCH_IN_DIALOG, Boolean.FALSE);
        this.defaults.put(SEARCH_ALL_BASES, Boolean.FALSE);
        this.defaults.put(DEFAULT_LABEL_PATTERN, "[auth][year]");
        this.defaults.put(PREVIEW_ENABLED, Boolean.TRUE);
        this.defaults.put(ACTIVE_PREVIEW, 0);
        this.defaults.put(PREVIEW_0, "<font face=\"arial\"><b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>\\end{bibtexkey}</b><br>__NEWLINE__\\begin{author} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\author}<BR>\\end{author}__NEWLINE__\\begin{editor} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\editor} <i>(\\format[IfPlural(Eds.,Ed.)]{\\editor})</i><BR>\\end{editor}__NEWLINE__\\begin{title} \\format[HTMLChars]{\\title} \\end{title}<BR>__NEWLINE__\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}__NEWLINE__\\begin{journal} <em>\\format[HTMLChars]{\\journal}, </em>\\end{journal}__NEWLINE__\\begin{booktitle} <em>\\format[HTMLChars]{\\booktitle}, </em>\\end{booktitle}__NEWLINE__\\begin{school} <em>\\format[HTMLChars]{\\school}, </em>\\end{school}__NEWLINE__\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}__NEWLINE__\\begin{publisher} <em>\\format[HTMLChars]{\\publisher}, </em>\\end{publisher}__NEWLINE__\\begin{year}<b>\\year</b>\\end{year}\\begin{volume}<i>, \\volume</i>\\end{volume}\\begin{pages}, \\format[FormatPagesForHTML]{\\pages} \\end{pages}__NEWLINE__\\begin{abstract}<BR><BR><b>Abstract: </b> \\format[HTMLChars]{\\abstract} \\end{abstract}__NEWLINE__\\begin{review}<BR><BR><b>Review: </b> \\format[HTMLChars]{\\review} \\end{review}</dd>__NEWLINE__<p></p></font>");
        this.defaults.put(PREVIEW_1, "<font face=\"arial\"><b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>\\end{bibtexkey}</b><br>__NEWLINE__\\begin{author} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\author}<BR>\\end{author}__NEWLINE__\\begin{editor} \\format[Authors(LastFirst,Initials,Semicolon,Amp),HTMLChars]{\\editor} <i>(\\format[IfPlural(Eds.,Ed.)]{\\editor})</i><BR>\\end{editor}__NEWLINE__\\begin{title} \\format[HTMLChars]{\\title} \\end{title}<BR>__NEWLINE__\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}__NEWLINE__\\begin{journal} <em>\\format[HTMLChars]{\\journal}, </em>\\end{journal}__NEWLINE__\\begin{booktitle} <em>\\format[HTMLChars]{\\booktitle}, </em>\\end{booktitle}__NEWLINE__\\begin{school} <em>\\format[HTMLChars]{\\school}, </em>\\end{school}__NEWLINE__\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}__NEWLINE__\\begin{publisher} <em>\\format[HTMLChars]{\\publisher}, </em>\\end{publisher}__NEWLINE__\\begin{year}<b>\\year</b>\\end{year}\\begin{volume}<i>, \\volume</i>\\end{volume}\\begin{pages}, \\format[FormatPagesForHTML]{\\pages} \\end{pages}</dd>__NEWLINE__<p></p></font>");
        this.defaults.put(PREVIEW_PRINT_BUTTON, Boolean.FALSE);
        this.defaults.put(AUTO_DOUBLE_BRACES, Boolean.FALSE);
        this.defaults.put(DO_NOT_RESOLVE_STRINGS_FOR, "url");
        this.defaults.put(RESOLVE_STRINGS_ALL_FIELDS, Boolean.FALSE);
        this.defaults.put(PUT_BRACES_AROUND_CAPITALS, "");
        this.defaults.put(NON_WRAPPABLE_FIELDS, "pdf;ps;url;doi;file");
        this.defaults.put(USE_IMPORT_INSPECTION_DIALOG, Boolean.TRUE);
        this.defaults.put(USE_IMPORT_INSPECTION_DIALOG_FOR_SINGLE, Boolean.TRUE);
        this.defaults.put(GENERATE_KEYS_AFTER_INSPECTION, Boolean.TRUE);
        this.defaults.put(MARK_IMPORTED_ENTRIES, Boolean.TRUE);
        this.defaults.put(UNMARK_ALL_ENTRIES_BEFORE_IMPORTING, Boolean.TRUE);
        this.defaults.put(WARN_ABOUT_DUPLICATES_IN_INSPECTION, Boolean.TRUE);
        this.defaults.put(USE_TIME_STAMP, Boolean.FALSE);
        this.defaults.put(OVERWRITE_TIME_STAMP, Boolean.FALSE);
        this.defaults.put(TIME_STAMP_FORMAT, "yyyy.MM.dd");
        this.defaults.put(TIME_STAMP_FIELD, "timestamp");
        this.defaults.put(UPDATE_TIMESTAMP, Boolean.FALSE);
        this.defaults.put(GENERATE_KEYS_BEFORE_SAVING, Boolean.FALSE);
        this.defaults.put(WRITEFIELD_ADDSPACES, Boolean.TRUE);
        this.defaults.put(WRITEFIELD_CAMELCASENAME, Boolean.TRUE);
        this.defaults.put(WRITEFIELD_SORTSTYLE, 0);
        this.defaults.put(WRITEFIELD_USERDEFINEDORDER, "author;title;journal;year;volume;number;pages;month;note;volume;pages;part;eid");
        this.defaults.put(WRITEFIELD_WRAPFIELD, Boolean.FALSE);
        this.defaults.put("useRemoteServer", Boolean.FALSE);
        this.defaults.put("remoteServerPort", 6050);
        this.defaults.put(PERSONAL_JOURNAL_LIST, null);
        this.defaults.put(EXTERNAL_JOURNAL_LISTS, null);
        this.defaults.put(CITE_COMMAND, "cite");
        this.defaults.put(CITE_COMMAND_VIM, "\\cite");
        this.defaults.put(CITE_COMMAND_EMACS, "\\cite");
        this.defaults.put(CITE_COMMAND_WIN_EDT, "\\cite");
        this.defaults.put(CITE_COMMAND_LED, "\\cite");
        this.defaults.put(FLOAT_MARKED_ENTRIES, Boolean.TRUE);
        this.defaults.put(USE_NATIVE_FILE_DIALOG_ON_MAC, Boolean.FALSE);
        this.defaults.put(FILECHOOSER_DISABLE_RENAME, Boolean.TRUE);
        this.defaults.put(LAST_USED_EXPORT, null);
        this.defaults.put(SIDE_PANE_WIDTH, -1);
        this.defaults.put(IMPORT_INSPECTION_DIALOG_WIDTH, 650);
        this.defaults.put(IMPORT_INSPECTION_DIALOG_HEIGHT, 650);
        this.defaults.put(SEARCH_DIALOG_WIDTH, 650);
        this.defaults.put(SEARCH_DIALOG_HEIGHT, 500);
        this.defaults.put(SHOW_FILE_LINKS_UPGRADE_WARNING, Boolean.TRUE);
        this.defaults.put(AUTOLINK_EXACT_KEY_ONLY, Boolean.TRUE);
        this.defaults.put(NUMERIC_FIELDS, "mittnum;author");
        this.defaults.put(RUN_AUTOMATIC_FILE_SEARCH, Boolean.FALSE);
        this.defaults.put(USE_LOCK_FILES, Boolean.TRUE);
        this.defaults.put(AUTO_SAVE, Boolean.TRUE);
        this.defaults.put(AUTO_SAVE_INTERVAL, 5);
        this.defaults.put(PROMPT_BEFORE_USING_AUTOSAVE, Boolean.TRUE);
        this.defaults.put(DELETE_PLUGINS, "");
        this.defaults.put(ENFORCE_LEGAL_BIBTEX_KEY, Boolean.TRUE);
        this.defaults.put(BIBLATEX_MODE, Boolean.FALSE);
        this.defaults.put(VALUE_DELIMITERS2, 1);
        this.defaults.put(INCLUDE_EMPTY_FIELDS, Boolean.FALSE);
        this.defaults.put(KEY_GEN_FIRST_LETTER_A, Boolean.TRUE);
        this.defaults.put(KEY_GEN_ALWAYS_ADD_LETTER, Boolean.FALSE);
        this.defaults.put(EMAIL_SUBJECT, Globals.lang("References"));
        this.defaults.put(OPEN_FOLDERS_OF_ATTACHED_FILES, Boolean.FALSE);
        this.defaults.put(ALLOW_FILE_AUTO_OPEN_BROWSE, Boolean.TRUE);
        this.defaults.put(WEB_SEARCH_VISIBLE, Boolean.FALSE);
        this.defaults.put(SELECTED_FETCHER_INDEX, 0);
        this.defaults.put(BIB_LOCATION_AS_FILE_DIR, Boolean.TRUE);
        this.defaults.put(BIB_LOC_AS_PRIMARY_DIR, Boolean.FALSE);
        this.defaults.put(DB_CONNECT_SERVER_TYPE, "MySQL");
        this.defaults.put(DB_CONNECT_HOSTNAME, "localhost");
        this.defaults.put(DB_CONNECT_DATABASE, "jabref");
        this.defaults.put(DB_CONNECT_USERNAME, "root");
        CleanUpAction.putDefaults(this.defaults);
        this.defaults.put("DroppedFileHandler_LeaveFileInDir", Boolean.FALSE);
        this.defaults.put("DroppedFileHandler_CopyFile", Boolean.TRUE);
        this.defaults.put("DroppedFileHandler_MoveFile", Boolean.FALSE);
        this.defaults.put("DroppedFileHandler_RenameFile", Boolean.FALSE);
        this.defaults.put("importAlwaysUsePDFImportStyle", Boolean.FALSE);
        this.defaults.put("importDefaultPDFimportStyle", 2);
        this.defaults.put("importFileNamePattern", ImportSettingsTab.DEFAULT_FILENAMEPATTERNS[0]);
        this.restoreKeyBindings();
        this.customExports = new CustomExportList(new ExportComparator());
        this.customImports = new CustomImportList(this);
        this.updateSpecialFieldHandling();
        this.WRAPPED_USERNAME = '[' + this.get(DEFAULT_OWNER) + ']';
        this.MARKING_WITH_NUMBER_PATTERN = "\\[" + this.get(DEFAULT_OWNER).replaceAll("\\\\", "\\\\\\\\") + ":(\\d+)\\]";
        String string = "**/.*[bibtexkey].*\\\\.[extension]";
        this.defaults.put(DEFAULT_REG_EXP_SEARCH_EXPRESSION_KEY, string);
        this.defaults.put(REG_EXP_SEARCH_EXPRESSION_KEY, string);
        this.defaults.put(USE_REG_EXP_SEARCH_KEY, Boolean.FALSE);
        this.defaults.put(USE_IEEE_ABRV, Boolean.FALSE);
        this.defaults.put(USE_CONVERT_TO_EQUATION, Boolean.FALSE);
        this.defaults.put(USE_CASE_KEEPER_ON_SEARCH, Boolean.TRUE);
        this.defaults.put(USE_UNIT_FORMATTER_ON_SEARCH, Boolean.TRUE);
        this.defaults.put(USER_FILE_DIR, "fileDirectory");
        try {
            this.defaults.put(USER_FILE_DIR_IND_LEGACY, "fileDirectory-" + this.get(DEFAULT_OWNER) + '@' + InetAddress.getLocalHost().getHostName());
            this.defaults.put(USER_FILE_DIR_INDIVIDUAL, "fileDirectory-" + this.get(DEFAULT_OWNER) + '-' + InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            LOGGER.info("Hostname not found.", unknownHostException);
            this.defaults.put(USER_FILE_DIR_IND_LEGACY, "fileDirectory-" + this.get(DEFAULT_OWNER));
            this.defaults.put(USER_FILE_DIR_INDIVIDUAL, "fileDirectory-" + this.get(DEFAULT_OWNER));
        }
    }

    public void setLanguageDependentDefaultValues() {
        this.defaults.put("customTabName__def0", Globals.lang("General"));
        this.defaults.put("customTabFields__def0", "crossref;keywords;file;doi;url;comment;owner;timestamp");
        this.defaults.put("customTabFields__def1", "abstract");
        this.defaults.put("customTabName__def1", Globals.lang("Abstract"));
        this.defaults.put("customTabFields__def2", "review");
        this.defaults.put("customTabName__def2", Globals.lang("Review"));
    }

    public boolean putBracesAroundCapitals(String string) {
        return this.putBracesAroundCapitalsFields.contains(string);
    }

    public void updateSpecialFieldHandling() {
        String[] stringArray;
        this.putBracesAroundCapitalsFields.clear();
        String string = this.get(PUT_BRACES_AROUND_CAPITALS);
        if (!string.isEmpty()) {
            for (String string2 : stringArray = string.split(";")) {
                this.putBracesAroundCapitalsFields.add(string2.trim());
            }
        }
        this.nonWrappableFields.clear();
        string = this.get(NON_WRAPPABLE_FIELDS);
        if (!string.isEmpty()) {
            for (String string2 : stringArray = string.split(";")) {
                this.nonWrappableFields.add(string2.trim());
            }
        }
    }

    public char getValueDelimiters(int n) {
        return this.getValueDelimiters()[n];
    }

    private char[] getValueDelimiters() {
        return VALUE_DELIMITERS[this.getInt(VALUE_DELIMITERS2)];
    }

    public boolean hasKey(String string) {
        return this.prefs.get(string, null) != null;
    }

    public String get(String string) {
        return this.prefs.get(string, (String)this.defaults.get(string));
    }

    public String get(String string, String string2) {
        return this.prefs.get(string, string2);
    }

    public boolean getBoolean(String string) {
        return this.prefs.getBoolean(string, this.getBooleanDefault(string));
    }

    private boolean getBooleanDefault(String string) {
        return (Boolean)this.defaults.get(string);
    }

    public double getDouble(String string) {
        return this.prefs.getDouble(string, this.getDoubleDefault(string));
    }

    private double getDoubleDefault(String string) {
        return (Double)this.defaults.get(string);
    }

    public int getInt(String string) {
        return this.prefs.getInt(string, this.getIntDefault(string));
    }

    public int getIntDefault(String string) {
        return (Integer)this.defaults.get(string);
    }

    public byte[] getByteArray(String string) {
        return this.prefs.getByteArray(string, this.getByteArrayDefault(string));
    }

    private byte[] getByteArrayDefault(String string) {
        return (byte[])this.defaults.get(string);
    }

    public void put(String string, String string2) {
        this.prefs.put(string, string2);
    }

    public void putBoolean(String string, boolean bl) {
        this.prefs.putBoolean(string, bl);
    }

    public void putDouble(String string, double d) {
        this.prefs.putDouble(string, d);
    }

    public void putInt(String string, int n) {
        this.prefs.putInt(string, n);
    }

    public void putByteArray(String string, byte[] byArray) {
        this.prefs.putByteArray(string, byArray);
    }

    public void remove(String string) {
        this.prefs.remove(string);
    }

    public void putStringArray(String string, String[] stringArray) {
        if (stringArray == null) {
            this.remove(string);
            return;
        }
        if (stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(this.makeEscape(stringArray[i]));
                stringBuilder.append(';');
            }
            stringBuilder.append(this.makeEscape(stringArray[stringArray.length - 1]));
            this.put(string, stringBuilder.toString());
        } else {
            this.put(string, "");
        }
    }

    public String[] getStringArray(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string2);
        Vector<String> vector = new Vector<String>();
        try {
            String string3;
            while ((string3 = this.getNextUnit(stringReader)) != null) {
                vector.add(string3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public Color getColor(String string) {
        String string2 = this.get(string);
        int[] nArray = this.getRgb(string2);
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public Color getDefaultColor(String string) {
        String string2 = (String)this.defaults.get(string);
        int[] nArray = this.getRgb(string2);
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public void putDefaultValue(String string, Object object) {
        this.defaults.put(string, object);
    }

    public void putColor(String string, Color color) {
        String string2 = String.valueOf(color.getRed()) + ':' + String.valueOf(color.getGreen()) + ':' + String.valueOf(color.getBlue());
        this.put(string, string2);
    }

    private int[] getRgb(String string) {
        String[] stringArray = string.split(":");
        int[] nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])};
        return nArray;
    }

    public KeyStroke getKey(String string) {
        String string2 = this.keyBinds.get(string);
        if (string2 == null) {
            string2 = this.defaultKeyBinds.get(string);
            if (string2 == null) {
                LOGGER.info("Could not get key binding for \"" + string + '\"');
                string2 = "Not associated";
            }
            this.keyBinds.put(string, string2);
        }
        if (Globals.ON_MAC) {
            return this.getKeyForMac(KeyStroke.getKeyStroke(string2));
        }
        return KeyStroke.getKeyStroke(string2);
    }

    private KeyStroke getKeyForMac(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return null;
        }
        int n = keyStroke.getKeyCode();
        if ((keyStroke.getModifiers() & 2) == 0) {
            return keyStroke;
        }
        int n2 = 0;
        if ((keyStroke.getModifiers() & 1) != 0) {
            n2 |= 1;
        }
        if ((keyStroke.getModifiers() & 8) != 0) {
            n2 |= 8;
        }
        return KeyStroke.getKeyStroke(n, Globals.getShortcutMask() + n2);
    }

    public HashMap<String, String> getKeyBindings() {
        return this.keyBinds.getKeyBindings();
    }

    public HashMap<String, String> getDefaultKeys() {
        return this.defaultKeyBinds.getKeyBindings();
    }

    public void clear() throws BackingStoreException {
        this.prefs.clear();
    }

    public void clear(String string) {
        this.prefs.remove(string);
    }

    public void flush() {
        if (this.getBoolean(MEMORY_STICK_MODE)) {
            try {
                this.exportPreferences("jabref.xml");
            }
            catch (IOException iOException) {
                LOGGER.info("Could not save preferences for memory stick mode: " + iOException.getLocalizedMessage(), iOException);
            }
        }
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public void setNewKeyBindings(HashMap<String, String> hashMap) {
        if (!hashMap.equals(this.keyBinds)) {
            String[] stringArray = new String[hashMap.size()];
            String[] stringArray2 = new String[hashMap.size()];
            int n = 0;
            for (String string : hashMap.keySet()) {
                String string2 = hashMap.get(string);
                stringArray[n] = string;
                stringArray2[n] = string2;
                ++n;
            }
            this.putStringArray("bindNames", stringArray);
            this.putStringArray("bindings", stringArray2);
            this.keyBinds.overwriteBindings(hashMap);
        }
    }

    public LabelPattern getKeyPattern() {
        keyPattern = new LabelPattern();
        Preferences preferences = Preferences.userNodeForPackage(LabelPattern.class);
        try {
            String[] stringArray = preferences.keys();
            if (stringArray.length > 0) {
                for (String string : stringArray) {
                    keyPattern.addLabelPattern(string, preferences.get(string, null));
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            LOGGER.info("BackingStoreException in JabRefPreferences.getKeyPattern", backingStoreException);
        }
        return keyPattern;
    }

    public void putKeyPattern(LabelPattern labelPattern) {
        keyPattern = labelPattern;
        Preferences preferences = Preferences.userNodeForPackage(LabelPattern.class);
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            LOGGER.info("BackingStoreException in JabRefPreferences.putKeyPattern", backingStoreException);
        }
        for (Map.Entry entry : labelPattern.entrySet()) {
            ArrayList arrayList = (ArrayList)entry.getValue();
            if (arrayList == null) continue;
            preferences.put((String)entry.getKey(), (String)arrayList.get(0));
        }
    }

    private void restoreKeyBindings() {
        this.defaultKeyBinds = new KeyBinds();
        String[] stringArray = this.getStringArray("bindNames");
        String[] stringArray2 = this.getStringArray("bindings");
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            this.keyBinds = new KeyBinds();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.keyBinds.put(stringArray[i], stringArray2[i]);
        }
    }

    private String getNextUnit(Reader reader) throws IOException {
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        while (!bl2 && (n = reader.read()) != -1) {
            if (n == 92) {
                if (!bl) {
                    bl = true;
                    continue;
                }
                bl = false;
                stringBuilder.append('\\');
                continue;
            }
            if (n == 59) {
                if (!bl) {
                    bl2 = true;
                } else {
                    stringBuilder.append(';');
                }
            } else {
                stringBuilder.append((char)n);
            }
            bl = false;
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        if (n == -1) {
            return null;
        }
        return "";
    }

    private String makeEscape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == ';') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public void storeCustomEntryType(CustomEntryType customEntryType, int n) {
        String string = "" + n;
        this.put(CUSTOM_TYPE_NAME + string, customEntryType.getName());
        this.put(CUSTOM_TYPE_REQ + string, customEntryType.getRequiredFieldsString());
        this.putStringArray(CUSTOM_TYPE_OPT + string, customEntryType.getOptionalFields());
        this.putStringArray(CUSTOM_TYPE_PRIOPT + string, customEntryType.getPrimaryOptionalFields());
    }

    public CustomEntryType getCustomEntryType(int n) {
        String string = "" + n;
        String string2 = this.get(CUSTOM_TYPE_NAME + string);
        String[] stringArray = this.getStringArray(CUSTOM_TYPE_REQ + string);
        String[] stringArray2 = this.getStringArray(CUSTOM_TYPE_OPT + string);
        String[] stringArray3 = this.getStringArray(CUSTOM_TYPE_PRIOPT + string);
        if (string2 == null) {
            return null;
        }
        if (stringArray3 == null) {
            return new CustomEntryType(StringUtil.nCase(string2), stringArray, stringArray2);
        }
        String[] stringArray4 = Util.getRemainder(stringArray2, stringArray3);
        return new CustomEntryType(StringUtil.nCase(string2), stringArray, stringArray3, stringArray4);
    }

    public List<ExternalFileType> getDefaultExternalFileTypes() {
        ArrayList<ExternalFileType> arrayList = new ArrayList<ExternalFileType>();
        arrayList.add(new ExternalFileType("PDF", "pdf", "application/pdf", "evince", "pdfSmall"));
        arrayList.add(new ExternalFileType("PostScript", "ps", "application/postscript", "evince", "psSmall"));
        arrayList.add(new ExternalFileType("Word", "doc", "application/msword", "oowriter", "openoffice"));
        arrayList.add(new ExternalFileType("Word 2007+", "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "oowriter", "openoffice"));
        arrayList.add(new ExternalFileType("OpenDocument text", "odt", "application/vnd.oasis.opendocument.text", "oowriter", "openoffice"));
        arrayList.add(new ExternalFileType("Excel", "xls", "application/excel", "oocalc", "openoffice"));
        arrayList.add(new ExternalFileType("Excel 2007+", "xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "oocalc", "openoffice"));
        arrayList.add(new ExternalFileType("OpenDocument spreadsheet", "ods", "application/vnd.oasis.opendocument.spreadsheet", "oocalc", "openoffice"));
        arrayList.add(new ExternalFileType("PowerPoint", "ppt", "application/vnd.ms-powerpoint", "ooimpress", "openoffice"));
        arrayList.add(new ExternalFileType("PowerPoint 2007+", "pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "ooimpress", "openoffice"));
        arrayList.add(new ExternalFileType("OpenDocument presentation", "odp", "application/vnd.oasis.opendocument.presentation", "ooimpress", "openoffice"));
        arrayList.add(new ExternalFileType("Rich Text Format", "rtf", "application/rtf", "oowriter", "openoffice"));
        arrayList.add(new ExternalFileType("PNG image", "png", "image/png", "gimp", "picture"));
        arrayList.add(new ExternalFileType("GIF image", "gif", "image/gif", "gimp", "picture"));
        arrayList.add(new ExternalFileType("JPG image", "jpg", "image/jpeg", "gimp", "picture"));
        arrayList.add(new ExternalFileType("Djvu", "djvu", "", "evince", "psSmall"));
        arrayList.add(new ExternalFileType("Text", "txt", "text/plain", "emacs", "emacs"));
        arrayList.add(new ExternalFileType("LaTeX", "tex", "application/x-latex", "emacs", "emacs"));
        arrayList.add(new ExternalFileType("CHM", "chm", "application/mshelp", "gnochm", "www"));
        arrayList.add(new ExternalFileType("TIFF image", "tiff", "image/tiff", "gimp", "picture"));
        arrayList.add(new ExternalFileType("URL", "html", "text/html", "firefox", "www"));
        arrayList.add(new ExternalFileType("MHT", "mht", "multipart/related", "firefox", "www"));
        arrayList.add(new ExternalFileType("ePUB", "epub", "application/epub+zip", "firefox", "www"));
        for (ExternalFileType externalFileType : arrayList) {
            externalFileType.setOpenWith("");
        }
        return arrayList;
    }

    public ExternalFileType[] getExternalFileTypeSelection() {
        return this.externalFileTypes.toArray(new ExternalFileType[this.externalFileTypes.size()]);
    }

    public ExternalFileType getExternalFileTypeByName(String string) {
        for (ExternalFileType externalFileType : this.externalFileTypes) {
            if (!externalFileType.getName().equals(string)) continue;
            return externalFileType;
        }
        return new UnknownExternalFileType(string);
    }

    public ExternalFileType getExternalFileTypeByExt(String string) {
        for (ExternalFileType externalFileType : this.externalFileTypes) {
            if (externalFileType.getExtension() == null || !externalFileType.getExtension().equalsIgnoreCase(string)) continue;
            return externalFileType;
        }
        return null;
    }

    public ExternalFileType getExternalFileTypeForName(String string) {
        int n = -1;
        ExternalFileType externalFileType = null;
        for (ExternalFileType externalFileType2 : this.externalFileTypes) {
            if (externalFileType2.getExtension() == null || !string.toLowerCase().endsWith(externalFileType2.getExtension().toLowerCase()) || externalFileType2.getExtension().length() <= n) continue;
            n = externalFileType2.getExtension().length();
            externalFileType = externalFileType2;
        }
        return externalFileType;
    }

    public ExternalFileType getExternalFileTypeByMimeType(String string) {
        for (ExternalFileType externalFileType : this.externalFileTypes) {
            if (externalFileType.getMimeType() == null || !externalFileType.getMimeType().equals(string)) continue;
            return externalFileType;
        }
        if (string.equals("text/html")) {
            return this.HTML_FALLBACK_TYPE;
        }
        return null;
    }

    public void setExternalFileTypes(List<ExternalFileType> list) {
        List<ExternalFileType> list2 = this.getDefaultExternalFileTypes();
        ArrayList<ExternalFileType> arrayList = new ArrayList<ExternalFileType>();
        this.externalFileTypes.clear();
        for (ExternalFileType externalFileType : list) {
            this.externalFileTypes.add(externalFileType);
            Object object = null;
            for (ExternalFileType externalFileType2 : list2) {
                if (!externalFileType2.getName().equals(externalFileType.getName())) continue;
                object = externalFileType2;
                break;
            }
            if (object == null) continue;
            if (((ExternalFileType)object).equals(externalFileType)) {
                arrayList.add(externalFileType);
                continue;
            }
            list2.remove(object);
        }
        for (ExternalFileType externalFileType : arrayList) {
            list2.remove(externalFileType);
            list.remove(externalFileType);
        }
        Iterator<ExternalFileType> iterator = new String[list.size() + list2.size()][];
        int n = 0;
        for (ExternalFileType externalFileType : list) {
            iterator[n] = externalFileType.getStringArrayRepresentation();
            ++n;
        }
        for (ExternalFileType externalFileType : list2) {
            iterator[n] = new String[]{externalFileType.getName(), FILE_TYPE_REMOVED_FLAG};
            ++n;
        }
        this.put("externalFileTypes", Util.encodeStringArray(iterator));
    }

    public void updateExternalFileTypes() {
        List<ExternalFileType> list = this.getDefaultExternalFileTypes();
        if (this.prefs.get("externalFileTypes", null) == null) {
            this.externalFileTypes.clear();
            this.externalFileTypes.addAll(list);
            return;
        }
        String[][] stringArray = Util.decodeStringDoubleArray(this.prefs.get("externalFileTypes", ""));
        for (String[] stringArray2 : stringArray) {
            ExternalFileType object2;
            if (stringArray2.length == 2 && stringArray2[1].equals(FILE_TYPE_REMOVED_FLAG)) {
                object2 = null;
                for (ExternalFileType externalFileType : list) {
                    if (!externalFileType.getName().equals(stringArray2[0])) continue;
                    object2 = externalFileType;
                    break;
                }
                if (object2 == null) continue;
                list.remove(object2);
                continue;
            }
            object2 = new ExternalFileType(stringArray2);
            Object object4 = null;
            for (ExternalFileType externalFileType : list) {
                if (!object2.getName().equals(externalFileType.getName())) continue;
                object4 = externalFileType;
                break;
            }
            if (object4 != null) {
                list.remove(object4);
            }
            list.add(object2);
        }
        for (ExternalFileType externalFileType : list) {
            this.externalFileTypes.add(externalFileType);
        }
    }

    public void purgeCustomEntryTypes(int n) {
        this.purgeSeries(CUSTOM_TYPE_NAME, n);
        this.purgeSeries(CUSTOM_TYPE_REQ, n);
        this.purgeSeries(CUSTOM_TYPE_OPT, n);
        this.purgeSeries(CUSTOM_TYPE_PRIOPT, n);
    }

    public void purgeSeries(String string, int n) {
        while (this.get(string + n) != null) {
            this.remove(string + n);
            ++n;
        }
    }

    public EntryEditorTabList getEntryEditorTabList() {
        if (this.tabList == null) {
            this.updateEntryEditorTabList();
        }
        return this.tabList;
    }

    public void updateEntryEditorTabList() {
        this.tabList = new EntryEditorTabList();
    }

    public void exportPreferences(String string) throws IOException {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.prefs.exportSubtree(fileOutputStream);
        }
        catch (BackingStoreException backingStoreException) {
            throw new IOException(backingStoreException);
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    public void importPreferences(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Preferences.importPreferences(fileInputStream);
        }
        catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
            throw new IOException(invalidPreferencesFormatException);
        }
    }

    public boolean isNonWrappableField(String string) {
        return this.nonWrappableFields.contains(string);
    }

    static {
        singleton = null;
    }
}

