/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefCLI;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.SearchManagerNoGUI;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.IExportFormat;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.gui.nativeext.PinToTaskbar;
import net.sf.jabref.imports.AutosaveStartupPrompter;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.imports.ImportInspectionCommandLine;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.PluginInstaller;
import net.sf.jabref.plugin.SidePanePlugin;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;
import net.sf.jabref.remote.JabRefMessageHandler;
import net.sf.jabref.remote.RemotePreferences;
import net.sf.jabref.remote.client.RemoteListenerClient;
import net.sf.jabref.util.FileBasedLock;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;
import net.sf.jabref.util.logging.CacheableHandler;
import net.sf.jabref.wizard.auximport.AuxCommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;

public class JabRef {
    public static JabRefFrame jrf;
    private static final int MAX_DIALOG_WARNINGS = 10;
    private static final Log LOGGER;
    private JabRefCLI cli;

    public void start(String[] stringArray) {
        Vector<ParserResult> vector;
        String string;
        Object object;
        JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        if (jabRefPreferences.hasKey("deletePlugins") && jabRefPreferences.get("deletePlugins").length() > 0) {
            object = jabRefPreferences.getStringArray("deletePlugins");
            PluginInstaller.deletePluginsOnStartup((String[])object);
            jabRefPreferences.put("deletePlugins", "");
        }
        if (jabRefPreferences.getBoolean("useProxy")) {
            System.setProperty("http.proxyHost", jabRefPreferences.get("proxyHostname"));
            System.setProperty("http.proxyPort", jabRefPreferences.get("proxyPort"));
            if (jabRefPreferences.get("proxyUsername") != null) {
                System.setProperty("http.proxyUser", jabRefPreferences.get("proxyUsername"));
                System.setProperty("http.proxyPassword", jabRefPreferences.get("proxyPassword"));
            }
        } else {
            System.setProperty("java.net.useSystemProxies", "true");
            System.setProperty("proxySet", "true");
        }
        Globals.startBackgroundTasks();
        this.setupLogHandlerForErrorConsole();
        Globals.prefs = jabRefPreferences;
        this.setLanguage(jabRefPreferences);
        Globals.prefs.setLanguageDependentDefaultValues();
        BibtexFields.setNumericFieldsFromPrefs();
        Globals.importFormatReader.resetImportFormats();
        BibtexEntryType.loadCustomEntryTypes(jabRefPreferences);
        ExportFormats.initAllExports();
        Globals.initializeJournalNames();
        object = new RemotePreferences(Globals.prefs);
        if (((RemotePreferences)object).useRemoteServer()) {
            Globals.remoteListener.open(new JabRefMessageHandler(this), ((RemotePreferences)object).getPort());
            if (Globals.remoteListener.isOpen()) {
                Globals.remoteListener.start();
            } else if (RemoteListenerClient.sendToActiveJabRefInstance(stringArray, ((RemotePreferences)object).getPort())) {
                System.out.println(Globals.lang("Arguments passed on to running JabRef instance. Shutting down."));
                JabRefExecutorService.INSTANCE.shutdownEverything();
                return;
            }
        }
        if ((string = jabRefPreferences.get("personalJournalList")) != null && !string.isEmpty()) {
            try {
                Globals.journalAbbrev.readJournalListFromFile(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(null, Globals.lang("Journal file not found") + ": " + fileNotFoundException.getMessage(), Globals.lang("Error opening file"), 0);
                Globals.prefs.put("personalJournalList", "");
            }
        }
        Globals.NEWLINE = Globals.prefs.get("newline");
        Globals.NEWLINE_LENGTH = Globals.NEWLINE.length();
        if (OS.isWindows7OrLater()) {
            PinToTaskbar.enablePinToTaskbar();
        }
        if ((vector = this.processArguments(stringArray, true)) == null || this.cli.isDisableGui() || this.cli.isShowVersion()) {
            JabRefExecutorService.INSTANCE.shutdownEverything();
            return;
        }
        this.openWindow(vector);
    }

    private void setupLogHandlerForErrorConsole() {
        Globals.handler = new CacheableHandler();
        ((Jdk14Logger)LOGGER).getLogger().addHandler(Globals.handler);
    }

    private void setLanguage(JabRefPreferences jabRefPreferences) {
        String string;
        String string2;
        String string3 = jabRefPreferences.get("language");
        String[] stringArray = string3.split("_");
        if (stringArray.length == 1) {
            string2 = string3;
            string = "";
        } else {
            string2 = stringArray[0];
            string = stringArray[1];
        }
        Globals.setLanguage(string2, string);
    }

    public Vector<ParserResult> processArguments(String[] stringArray, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object5;
        Object object6;
        boolean bl2;
        this.cli = new JabRefCLI(stringArray);
        if (bl && this.cli.isShowVersion()) {
            this.cli.displayVersion();
        }
        if (bl && this.cli.isHelp()) {
            this.cli.printUsage();
            return null;
        }
        boolean bl3 = bl2 = this.cli.isDisableGui() || this.cli.isFetcherEngine();
        if (this.cli.isPreferencesReset()) {
            object6 = this.cli.getPreferencesReset();
            if (((String)object6).trim().equals("all")) {
                try {
                    System.out.println(Globals.lang("Setting all preferences to default values."));
                    Globals.prefs.clear();
                }
                catch (BackingStoreException backingStoreException) {
                    System.err.println(Globals.lang("Unable to clear preferences."));
                    backingStoreException.printStackTrace();
                }
            } else {
                for (Object object42 : object5 = ((String)object6).split(",")) {
                    if (Globals.prefs.hasKey(((String)object42).trim())) {
                        System.out.println(Globals.lang("Resetting preference key '%0'", ((String)object42).trim()));
                        Globals.prefs.clear(((String)object42).trim());
                        continue;
                    }
                    System.out.println(Globals.lang("Unknown preference key '%0'", ((String)object42).trim()));
                }
            }
        }
        if (this.cli.isPreferencesImport()) {
            try {
                Globals.prefs.importPreferences(this.cli.getPreferencesImport());
                BibtexEntryType.loadCustomEntryTypes(Globals.prefs);
                ExportFormats.initAllExports();
            }
            catch (IOException iOException) {
                LOGGER.error("Cannot import preferences", iOException);
            }
        }
        GUIGlobals.setUpIconTheme();
        object6 = new Vector();
        object5 = new Vector();
        if (!this.cli.isBlank() && this.cli.getLeftOver().length > 0) {
            for (String string : this.cli.getLeftOver()) {
                boolean bl4 = string.toLowerCase().endsWith("bib");
                object3 = null;
                if (bl4) {
                    object3 = JabRef.openBibFile(string, false);
                }
                if (object3 == null || object3 == ParserResult.INVALID_FORMAT) {
                    if (bl) {
                        ((Vector)object5).add(string);
                        continue;
                    }
                    object2 = JabRef.importToOpenBase(string);
                    if (object2 != null) {
                        ((Vector)object6).add(object2);
                        continue;
                    }
                    ((Vector)object6).add(ParserResult.INVALID_FORMAT);
                    continue;
                }
                if (object3 == ParserResult.FILE_LOCKED) continue;
                ((Vector)object6).add(object3);
            }
        }
        if (!this.cli.isBlank() && this.cli.isFileImport()) {
            ((Vector)object5).add(this.cli.getFileImport());
        }
        Object object7 = ((Vector)object5).iterator();
        while (object7.hasNext()) {
            String string = (String)object7.next();
            ParserResult parserResult = JabRef.importFile(string);
            if (parserResult == null) continue;
            ((Vector)object6).add(parserResult);
        }
        if (!this.cli.isBlank() && this.cli.isImportToOpenBase() && (object7 = JabRef.importToOpenBase(this.cli.getImportToOpenBase())) != null) {
            ((Vector)object6).add(object7);
        }
        if (!this.cli.isBlank() && this.cli.isFetcherEngine() && (object7 = this.fetch(this.cli.getFetcherEngine())) != null) {
            ((Vector)object6).add(object7);
        }
        if (this.cli.isExportMatches()) {
            if (((Vector)object6).size() > 0) {
                ParserResult parserResult;
                BibtexDatabase bibtexDatabase;
                object7 = this.cli.getExportMatches().split(",");
                String string = ((String)object7[0]).replace("\\$", " ");
                SearchManagerNoGUI searchManagerNoGUI = new SearchManagerNoGUI(string, bibtexDatabase = (parserResult = (ParserResult)((Vector)object6).elementAt(((Vector)object6).size() - 1)).getDatabase());
                object3 = searchManagerNoGUI.getDBfromMatches();
                if (object3 != null && ((BibtexDatabase)object3).getEntryCount() > 0) {
                    object2 = null;
                    switch (((Object)object7).length) {
                        case 3: {
                            object2 = object7[2];
                            break;
                        }
                        case 2: {
                            object2 = "tablerefsabsbib";
                            break;
                        }
                        default: {
                            System.err.println(Globals.lang("Output file missing").concat(". \n \t ").concat("Usage").concat(": ") + JabRefCLI.getExportMatchesSyntax());
                            return null;
                        }
                    }
                    object = ExportFormats.getExportFormat((String)object2);
                    if (object != null) {
                        try {
                            System.out.println(Globals.lang("Exporting") + ": " + (String)object7[1]);
                            object.performExport((BibtexDatabase)object3, parserResult.getMetaData(), (String)object7[1], parserResult.getEncoding(), null);
                        }
                        catch (Exception exception) {
                            System.err.println(Globals.lang("Could not export file") + " '" + (String)object7[1] + "': " + exception.getMessage());
                        }
                    } else {
                        System.err.println(Globals.lang("Unknown export format") + ": " + (String)object2);
                    }
                } else {
                    System.err.println(Globals.lang("No search matches."));
                }
            } else {
                System.err.println(Globals.lang("The output option depends on a valid input option."));
            }
        }
        if (this.cli.isFileExport()) {
            if (((Vector)object6).size() > 0) {
                object7 = this.cli.getFileExport().split(",");
                if (((Object)object7).length == 1) {
                    if (((Vector)object6).size() > 0) {
                        ParserResult parserResult = (ParserResult)((Vector)object6).elementAt(((Vector)object6).size() - 1);
                        if (!parserResult.isInvalid()) {
                            try {
                                System.out.println(Globals.lang("Saving") + ": " + (String)object7[0]);
                                SaveSession saveSession = FileActions.saveDatabase(parserResult.getDatabase(), parserResult.getMetaData(), new File((String)object7[0]), Globals.prefs, false, false, Globals.prefs.get("defaultEncoding"), false);
                                if (!saveSession.getWriter().couldEncodeAll()) {
                                    System.err.println(Globals.lang("Warning") + ": " + Globals.lang("The chosen encoding '%0' could not encode the following characters: ", saveSession.getEncoding()) + saveSession.getWriter().getProblemCharacters());
                                }
                                saveSession.commit();
                            }
                            catch (SaveException saveException) {
                                System.err.println(Globals.lang("Could not save file") + " '" + (String)object7[0] + "': " + saveException.getMessage());
                            }
                        }
                    } else {
                        System.err.println(Globals.lang("The output option depends on a valid import option."));
                    }
                } else if (((Object)object7).length == 2) {
                    ParserResult parserResult = (ParserResult)((Vector)object6).elementAt(((Vector)object6).size() - 1);
                    File file = parserResult.getFile();
                    if (!file.isAbsolute()) {
                        file = file.getAbsoluteFile();
                    }
                    MetaData metaData = parserResult.getMetaData();
                    metaData.setFile(file);
                    Globals.prefs.fileDirForDatabase = metaData.getFileDirectory("file");
                    Globals.prefs.databaseFile = metaData.getFile();
                    System.out.println(Globals.lang("Exporting") + ": " + (String)object7[0]);
                    IExportFormat iExportFormat = ExportFormats.getExportFormat((String)object7[1]);
                    if (iExportFormat != null) {
                        try {
                            iExportFormat.performExport(parserResult.getDatabase(), parserResult.getMetaData(), (String)object7[0], parserResult.getEncoding(), null);
                        }
                        catch (Exception exception) {
                            System.err.println(Globals.lang("Could not export file") + " '" + (String)object7[0] + "': " + exception.getMessage());
                        }
                    } else {
                        System.err.println(Globals.lang("Unknown export format") + ": " + (String)object7[1]);
                    }
                }
            } else {
                System.err.println(Globals.lang("The output option depends on a valid import option."));
            }
        }
        if (this.cli.isPreferencesExport()) {
            try {
                Globals.prefs.exportPreferences(this.cli.getPreferencesExport());
            }
            catch (IOException iOException) {
                LOGGER.error("Cannot export preferences", iOException);
            }
        }
        if (!this.cli.isBlank() && this.cli.isAuxImport()) {
            boolean bl5 = false;
            if (((Vector)object6).size() > 0) {
                String[] stringArray2 = this.cli.getAuxImport().split(",");
                if (stringArray2.length == 2) {
                    ParserResult parserResult = (ParserResult)((Vector)object6).firstElement();
                    AuxCommandLine auxCommandLine = new AuxCommandLine(stringArray2[0], parserResult.getDatabase());
                    BibtexDatabase bibtexDatabase = auxCommandLine.perform();
                    boolean bl6 = false;
                    if (bibtexDatabase != null && bibtexDatabase.getEntryCount() > 0) {
                        object2 = StringUtil.getCorrectFileName(stringArray2[1], "bib");
                        try {
                            System.out.println(Globals.lang("Saving") + ": " + (String)object2);
                            object = FileActions.saveDatabase(bibtexDatabase, new MetaData(), new File((String)object2), Globals.prefs, false, false, Globals.prefs.get("defaultEncoding"), false);
                            if (!((SaveSession)object).getWriter().couldEncodeAll()) {
                                System.err.println(Globals.lang("Warning") + ": " + Globals.lang("The chosen encoding '%0' could not encode the following characters: ", ((SaveSession)object).getEncoding()) + ((SaveSession)object).getWriter().getProblemCharacters());
                            }
                            ((SaveSession)object).commit();
                        }
                        catch (SaveException saveException) {
                            System.err.println(Globals.lang("Could not save file") + " '" + (String)object2 + "': " + saveException.getMessage());
                        }
                        bl6 = true;
                    }
                    if (!bl6) {
                        System.out.println(Globals.lang("no database generated"));
                    }
                } else {
                    bl5 = true;
                }
            } else {
                bl5 = true;
            }
            if (bl5) {
                System.out.println(Globals.lang("no base-bibtex-file specified"));
                System.out.println(Globals.lang("usage") + " :");
                System.out.println("jabref --aux infile[.aux],outfile[.bib] base-bibtex-file");
            }
        }
        return object6;
    }

    private ParserResult fetch(String string) {
        if (string == null || !string.contains(":") || string.split(":").length != 2) {
            System.out.println(Globals.lang("Expected syntax for --fetch='<name of fetcher>:<query>'"));
            System.out.println(Globals.lang("The following fetchers are available:"));
            return null;
        }
        String string2 = string.split(":")[0];
        String string3 = string.split(":")[1];
        EntryFetcher entryFetcher = null;
        for (_JabRefPlugin.EntryFetcherExtension entryFetcherExtension : JabRefPlugin.getInstance(PluginCore.getManager()).getEntryFetcherExtensions()) {
            if (!string2.toLowerCase().equals(entryFetcherExtension.getId().replaceAll("Fetcher", "").toLowerCase())) continue;
            entryFetcher = entryFetcherExtension.getEntryFetcher();
        }
        if (entryFetcher == null) {
            System.out.println(Globals.lang("Could not find fetcher '%0'", string2));
            System.out.println(Globals.lang("The following fetchers are available:"));
            for (_JabRefPlugin.EntryFetcherExtension entryFetcherExtension : JabRefPlugin.getInstance(PluginCore.getManager()).getEntryFetcherExtensions()) {
                System.out.println("  " + entryFetcherExtension.getId().replaceAll("Fetcher", "").toLowerCase());
            }
            return null;
        }
        System.out.println(Globals.lang("Running Query '%0' with fetcher '%1'.", string3, string2) + " " + Globals.lang("Please wait..."));
        Collection<BibtexEntry> collection = new ImportInspectionCommandLine().query(string3, entryFetcher);
        if (collection == null || collection.size() == 0) {
            System.out.println(Globals.lang("Query '%0' with fetcher '%1' did not return any results.", string3, string2));
            return null;
        }
        return new ParserResult(collection);
    }

    private void setLookAndFeel() {
        Serializable serializable;
        try {
            String string = UIManager.getSystemLookAndFeelClassName();
            String string2 = Globals.prefs.getBoolean("useDefaultLookAndFeel") ? string : Globals.prefs.get("lookAndFeel");
            if (string2.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                serializable = new Plastic3DLookAndFeel();
                Plastic3DLookAndFeel.setCurrentTheme(new SkyBluer());
                Options.setPopupDropShadowEnabled(true);
                UIManager.setLookAndFeel((LookAndFeel)((Object)serializable));
            } else {
                try {
                    UIManager.setLookAndFeel(string2);
                }
                catch (Exception exception) {
                    UIManager.setLookAndFeel(string);
                    Globals.prefs.put("lookAndFeel", string);
                    JOptionPane.showMessageDialog(jrf, Globals.lang("Unable to find the requested Look & Feel and thus the default one is used."), Globals.lang("Warning"), 2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean bl = Globals.prefs.getBoolean("overrideDefaultFonts");
        if (bl) {
            int n = Globals.prefs.getInt("menuFontSize");
            serializable = UIManager.getDefaults();
            Enumeration enumeration = ((Hashtable)serializable).keys();
            Double d = null;
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (!(k instanceof String) || !((String)k).endsWith(".font")) continue;
                FontUIResource fontUIResource = (FontUIResource)UIManager.get(k);
                if (d == null) {
                    d = (double)n / (double)fontUIResource.getSize();
                }
                fontUIResource = new FontUIResource(fontUIResource.getName(), fontUIResource.getStyle(), n);
                ((UIDefaults)serializable).put(k, fontUIResource);
            }
            if (d != null) {
                GUIGlobals.zoomLevel = d;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void openWindow(Vector<ParserResult> vector) {
        void var6_18;
        void var6_16;
        Object object;
        Object object22;
        Util.performCompatibilityUpdate();
        Globals.prefs.updateExternalFileTypes();
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("swing.aatext", "true");
        System.setProperty("awt.useSystemAAFontSettings", "lcd");
        try {
            this.setLookAndFeel();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (!this.cli.isBlank() && Globals.prefs.getBoolean("openLastEdited") && Globals.prefs.get("lastEdited") != null) {
            String[] stringArray = Globals.prefs.getStringArray("lastEdited");
            block2: for (String iterator : stringArray) {
                ParserResult parserResult;
                object22 = new File(iterator);
                for (int i = 0; i < vector.size(); ++i) {
                    object = vector.elementAt(i);
                    if (((ParserResult)object).getFile() != null && ((ParserResult)object).getFile().equals(object22)) continue block2;
                }
                if (!((File)object22).exists() || (parserResult = JabRef.openBibFile(iterator, false)) == null) continue;
                if (parserResult == ParserResult.INVALID_FORMAT) {
                    System.out.println(Globals.lang("Error opening file") + " '" + ((File)object22).getPath() + "'");
                    continue;
                }
                if (parserResult == ParserResult.FILE_LOCKED) continue;
                vector.add(parserResult);
            }
        }
        GUIGlobals.init();
        GUIGlobals.CURRENTFONT = new Font(Globals.prefs.get("fontFamily"), Globals.prefs.getInt("fontStyle"), Globals.prefs.getInt("fontSize"));
        jrf = new JabRefFrame(this);
        boolean bl = true;
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        if (vector.size() > 0) {
            Iterator<ParserResult> n = vector.iterator();
            while (n.hasNext()) {
                object22 = n.next();
                if (((ParserResult)object22).isInvalid()) {
                    arrayList2.add(object22);
                    n.remove();
                    continue;
                }
                if (!((ParserResult)object22).isPostponedAutosaveFound()) {
                    if (((ParserResult)object22).toOpenTab()) {
                        arrayList3.add(object22);
                        continue;
                    }
                    jrf.addParserResult((ParserResult)object22, bl);
                    bl = false;
                    continue;
                }
                n.remove();
                arrayList.add(((ParserResult)object22).getFile());
            }
        }
        for (Object object22 : arrayList3) {
            jrf.addParserResult((ParserResult)object22, bl);
            bl = false;
        }
        if (this.cli.isLoadSession()) {
            JabRef.jrf.loadSessionAction.actionPerformed(new ActionEvent(jrf, 0, ""));
        }
        if (Globals.prefs.getBoolean("autoSave")) {
            Globals.startAutoSaveManager(jrf);
        }
        if (Globals.prefs.getBoolean("windowMaximised")) {
            jrf.setExtendedState(6);
        }
        jrf.setVisible(true);
        if (Globals.prefs.getBoolean("windowMaximised")) {
            jrf.setExtendedState(6);
        }
        this.startSidePanePlugins(jrf);
        for (Object object22 : arrayList2) {
            String string = "<html>" + Globals.lang("Error opening file '%0'.", ((ParserResult)object22).getFile().getName()) + "<p>" + ((ParserResult)object22).getErrorMessage() + "</html>";
            JOptionPane.showMessageDialog(jrf, string, Globals.lang("Error opening file"), 0);
        }
        boolean bl2 = false;
        while (var6_16 < vector.size()) {
            object22 = vector.elementAt((int)var6_16);
            if (Globals.prefs.getBoolean("displayKeyWarningDialogAtStartup") && ((ParserResult)object22).hasWarnings()) {
                String[] stringArray = ((ParserResult)object22).warnings();
                object = new StringBuilder();
                for (int i = 0; i < Math.min(10, stringArray.length); ++i) {
                    ((StringBuilder)object).append(i + 1).append(". ").append(stringArray[i]).append("\n");
                }
                if (stringArray.length > 10) {
                    ((StringBuilder)object).append("... ");
                    ((StringBuilder)object).append(Globals.lang("%0 warnings", String.valueOf(stringArray.length)));
                } else if (((StringBuilder)object).length() > 0) {
                    ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
                }
                jrf.showBaseAt((int)var6_16);
                JOptionPane.showMessageDialog(jrf, ((StringBuilder)object).toString(), Globals.lang("Warnings") + " (" + ((ParserResult)object22).getFile().getName() + ")", 2);
            }
            ++var6_16;
        }
        boolean bl3 = false;
        while (var6_18 < vector.size() && var6_18 < jrf.baseCount()) {
            object22 = vector.elementAt((int)var6_18);
            BasePanel basePanel = jrf.baseAt((int)var6_18);
            OpenDatabaseAction.performPostOpenActions(basePanel, (ParserResult)object22, true);
            ++var6_18;
        }
        if (arrayList.size() > 0) {
            AutosaveStartupPrompter autosaveStartupPrompter = new AutosaveStartupPrompter(jrf, arrayList);
            SwingUtilities.invokeLater(autosaveStartupPrompter);
        }
        if (vector.size() > 0) {
            JabRef.jrf.tabbedPane.setSelectedIndex(0);
            new FocusRequester(((BasePanel)JabRef.jrf.tabbedPane.getComponentAt((int)0)).mainTable);
        }
    }

    private void startSidePanePlugins(JabRefFrame jabRefFrame) {
        JabRefPlugin jabRefPlugin = JabRefPlugin.getInstance(PluginCore.getManager());
        List<_JabRefPlugin.SidePanePluginExtension> list = jabRefPlugin.getSidePanePluginExtensions();
        for (_JabRefPlugin.SidePanePluginExtension sidePanePluginExtension : list) {
            SidePanePlugin sidePanePlugin = sidePanePluginExtension.getSidePanePlugin();
            sidePanePlugin.init(jabRefFrame, jabRefFrame.sidePaneManager);
            SidePaneComponent sidePaneComponent = sidePanePlugin.getSidePaneComponent();
            jabRefFrame.sidePaneManager.register(sidePaneComponent.getName(), sidePaneComponent);
            jabRefFrame.addPluginMenuItem(sidePanePlugin.getMenuItem());
        }
    }

    public static ParserResult openBibFile(String string, boolean bl) {
        LOGGER.info(Globals.lang("Opening") + ": " + string);
        File file = new File(string);
        if (!file.exists()) {
            ParserResult parserResult = new ParserResult(null, null, null);
            parserResult.setFile(file);
            parserResult.setInvalid(true);
            System.err.println(Globals.lang("Error") + ": " + Globals.lang("File not found"));
            return parserResult;
        }
        try {
            boolean bl2;
            if (!bl && (bl2 = AutoSaveManager.newerAutoSaveExists(file))) {
                ParserResult parserResult = new ParserResult(null, null, null);
                parserResult.setPostponedAutosaveFound(true);
                parserResult.setFile(file);
                return parserResult;
            }
            if (!FileBasedLock.waitForFileLock(file, 10)) {
                System.out.println(Globals.lang("Error opening file") + " '" + string + "'. " + "File is locked by another JabRef instance.");
                return ParserResult.FILE_LOCKED;
            }
            String string2 = Globals.prefs.get("defaultEncoding");
            ParserResult parserResult = OpenDatabaseAction.loadDatabase(file, string2);
            if (parserResult == null) {
                parserResult = new ParserResult(null, null, null);
                parserResult.setFile(file);
                parserResult.setInvalid(true);
                return parserResult;
            }
            parserResult.setFile(file);
            if (parserResult.hasWarnings()) {
                String[] stringArray;
                for (String string3 : stringArray = parserResult.warnings()) {
                    System.out.println(Globals.lang("Warning") + ": " + string3);
                }
            }
            return parserResult;
        }
        catch (Throwable throwable) {
            ParserResult parserResult = new ParserResult(null, null, null);
            parserResult.setFile(file);
            parserResult.setInvalid(true);
            parserResult.setErrorMessage(throwable.getMessage());
            throwable.printStackTrace();
            return parserResult;
        }
    }

    private static ParserResult importFile(String string) {
        String[] stringArray = string.split(",");
        try {
            if (stringArray.length > 1 && !"*".equals(stringArray[1])) {
                System.out.println(Globals.lang("Importing") + ": " + stringArray[0]);
                try {
                    List<BibtexEntry> list = Globals.ON_WIN ? Globals.importFormatReader.importFromFile(stringArray[1], stringArray[0], (OutputPrinter)jrf) : Globals.importFormatReader.importFromFile(stringArray[1], stringArray[0].replaceAll("~", System.getProperty("user.home")), (OutputPrinter)jrf);
                    return new ParserResult(list);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(Globals.lang("Unknown import format") + ": " + stringArray[1]);
                    return null;
                }
            }
            System.out.println(Globals.lang("Importing in unknown format") + ": " + stringArray[0]);
            ImportFormatReader.UnknownFormatImport unknownFormatImport = Globals.ON_WIN ? Globals.importFormatReader.importUnknownFormat(stringArray[0]) : Globals.importFormatReader.importUnknownFormat(stringArray[0].replaceAll("~", System.getProperty("user.home")));
            if (unknownFormatImport != null) {
                System.out.println(Globals.lang("Format used") + ": " + unknownFormatImport.format);
                return unknownFormatImport.parserResult;
            }
            System.out.println(Globals.lang("Could not find a suitable import format."));
        }
        catch (IOException iOException) {
            System.err.println(Globals.lang("Error opening file") + " '" + stringArray[0] + "': " + iOException.getLocalizedMessage());
        }
        return null;
    }

    private static ParserResult importToOpenBase(String string) {
        ParserResult parserResult = JabRef.importFile(string);
        if (parserResult != null) {
            parserResult.setToOpenTab(true);
        }
        return parserResult;
    }

    static {
        LOGGER = LogFactory.getLog(JabRef.class);
    }
}

