/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.PrefsTab;

public class ImportSettingsTab
extends JPanel
implements PrefsTab {
    public static final String PREF_IMPORT_ALWAYSUSE = "importAlwaysUsePDFImportStyle";
    public static final String PREF_IMPORT_DEFAULT_PDF_IMPORT_STYLE = "importDefaultPDFimportStyle";
    public static final int DEFAULT_STYLE = 2;
    public static final String PREF_IMPORT_FILENAMEPATTERN = "importFileNamePattern";
    private static final String[] DEFAULT_FILENAMEPATTERNS_DISPLAY = new String[]{"bibtexkey", "bibtexkey - title"};
    public static final String[] DEFAULT_FILENAMEPATTERNS = new String[]{"\\bibtexkey", "\\bibtexkey\\begin{title} - \\format[RemoveBrackets]{\\title}\\end{title}"};
    private final JRadioButton radioButtonXmp;
    private final JRadioButton radioButtonPDFcontent;
    private final JRadioButton radioButtonMrDlib;
    private final JRadioButton radioButtonNoMeta;
    private final JRadioButton radioButtononlyAttachPDF;
    private final JRadioButton radioButtonUpdateEmptyFields;
    private final JCheckBox useDefaultPDFImportStyle;
    private final JTextField fileNamePattern;
    private final JButton selectFileNamePattern;

    public ImportSettingsTab() {
        this.setLayout(new BorderLayout());
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:3dlu");
        this.radioButtonNoMeta = new JRadioButton(Globals.lang("Create_blank_entry_linking_the_PDF"));
        this.radioButtonXmp = new JRadioButton(Globals.lang("Create_entry_based_on_XMP_data"));
        this.radioButtonPDFcontent = new JRadioButton(Globals.lang("Create_entry_based_on_content"));
        this.radioButtonMrDlib = new JRadioButton(Globals.lang("Create_entry_based_on_data_fetched_from") + " Mr.DLib");
        this.radioButtononlyAttachPDF = new JRadioButton(Globals.lang("Only_attach_PDF"));
        this.radioButtonUpdateEmptyFields = new JRadioButton(Globals.lang("Update_empty_fields_with_data_fetched_from") + " Mr.DLib");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioButtonNoMeta);
        buttonGroup.add(this.radioButtonXmp);
        buttonGroup.add(this.radioButtonPDFcontent);
        buttonGroup.add(this.radioButtonMrDlib);
        buttonGroup.add(this.radioButtononlyAttachPDF);
        buttonGroup.add(this.radioButtonUpdateEmptyFields);
        this.useDefaultPDFImportStyle = new JCheckBox(Globals.lang("Always use this PDF import style (and do not ask for each import)"));
        this.fileNamePattern = new JTextField(50);
        this.selectFileNamePattern = new JButton(Globals.lang("Choose pattern"));
        this.selectFileNamePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportSettingsTab.this.openFilePatternMenu();
            }
        });
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        JPanel jPanel = new JPanel();
        defaultFormBuilder.appendSeparator(Globals.lang("Default import style for drag&drop of PDFs"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.radioButtonNoMeta);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.radioButtonXmp);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.radioButtonPDFcontent);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.radioButtonMrDlib);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.radioButtononlyAttachPDF);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.radioButtonUpdateEmptyFields);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.useDefaultPDFImportStyle);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Default PDF file link action"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(Globals.lang("File name format pattern").concat(":"));
        jPanel2.add(jLabel);
        jPanel2.add(this.fileNamePattern);
        jPanel2.add(this.selectFileNamePattern);
        defaultFormBuilder.append(jPanel2);
        jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setValues() {
        this.useDefaultPDFImportStyle.setSelected(Globals.prefs.getBoolean(PREF_IMPORT_ALWAYSUSE));
        int n = Globals.prefs.getInt(PREF_IMPORT_DEFAULT_PDF_IMPORT_STYLE);
        switch (n) {
            case 0: {
                this.radioButtonNoMeta.setSelected(true);
                break;
            }
            case 1: {
                this.radioButtonXmp.setSelected(true);
                break;
            }
            case 2: {
                this.radioButtonPDFcontent.setSelected(true);
                break;
            }
            case 3: {
                this.radioButtonMrDlib.setSelected(true);
                break;
            }
            case 4: {
                this.radioButtononlyAttachPDF.setSelected(true);
                break;
            }
            case 5: {
                this.radioButtonUpdateEmptyFields.setSelected(true);
                break;
            }
            default: {
                this.radioButtonPDFcontent.setSelected(true);
            }
        }
        this.fileNamePattern.setText(Globals.prefs.get(PREF_IMPORT_FILENAMEPATTERN));
    }

    @Override
    public void storeSettings() {
        Globals.prefs.putBoolean(PREF_IMPORT_ALWAYSUSE, this.useDefaultPDFImportStyle.isSelected());
        int n = 2;
        if (this.radioButtonNoMeta.isSelected()) {
            n = 0;
        } else if (this.radioButtonXmp.isSelected()) {
            n = 1;
        } else if (this.radioButtonPDFcontent.isSelected()) {
            n = 2;
        } else if (this.radioButtonMrDlib.isSelected()) {
            n = 3;
        } else if (this.radioButtononlyAttachPDF.isSelected()) {
            n = 4;
        } else if (this.radioButtonUpdateEmptyFields.isSelected()) {
            n = 5;
        }
        Globals.prefs.putInt(PREF_IMPORT_DEFAULT_PDF_IMPORT_STYLE, n);
        Globals.prefs.put(PREF_IMPORT_FILENAMEPATTERN, this.fileNamePattern.getText());
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Import");
    }

    private void openFilePatternMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (int i = 0; i < DEFAULT_FILENAMEPATTERNS.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem(DEFAULT_FILENAMEPATTERNS_DISPLAY[i]);
            final String string = DEFAULT_FILENAMEPATTERNS[i];
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImportSettingsTab.this.fileNamePattern.setText(string);
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(this.selectFileNamePattern, 0, this.selectFileNamePattern.getHeight());
    }
}

