/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.GlobalFocusListener;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.collab.FileUpdateMonitor;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.help.HelpDialog;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.journals.logic.JournalAbbreviationRepository;
import net.sf.jabref.remote.server.RemoteListenerServerLifecycle;
import net.sf.jabref.util.BuildInfo;
import net.sf.jabref.util.error.StreamEavesdropper;
import net.sf.jabref.util.logging.CacheableHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Globals {
    public static final String JOURNALS_IEEE_INTERNAL_LIST = "/resource/IEEEJournalList.txt";
    public static RemoteListenerServerLifecycle remoteListener = new RemoteListenerServerLifecycle();
    private static int SHORTCUT_MASK = -1;
    public static final int FUTURE_YEAR = 2050;
    public static int STANDARD_EXPORT_COUNT = 5;
    public static final int METADATA_LINE_LENGTH = 70;
    public static final String highlightColor = "#3399FF";
    private static final String RESOURCE_PREFIX = "resource/JabRef";
    private static final String MENU_RESOURCE_PREFIX = "resource/Menu";
    private static final String INTEGRITY_RESOURCE_PREFIX = "resource/IntegrityMessage";
    public static final String JOURNALS_FILE_BUILTIN = "/resource/journalList.txt";
    public static final String additionalFields = "/resource/fields/fields.xml";
    private static ResourceBundle messages;
    private static ResourceBundle menuTitles;
    private static ResourceBundle intMessages;
    public static FileUpdateMonitor fileUpdateMonitor;
    public static final ImportFormatReader importFormatReader;
    public static StreamEavesdropper streamEavesdropper;
    public static CacheableHandler handler;
    public static final BuildInfo BUILD_INFO;
    private static Locale locale;
    public static final String FILETYPE_PREFS_EXT = "_dir";
    public static final String SELECTOR_META_PREFIX = "selector_";
    public static final String PROTECTED_FLAG_META = "protectedFlag";
    public static final String LAYOUT_PREFIX = "/resource/layout/";
    public static final String MAC = "Mac OS X";
    public static final String DOI_LOOKUP_PREFIX = "http://dx.doi.org/";
    public static final String NONE = "_non__";
    public static final String ARXIV_LOOKUP_PREFIX = "http://arxiv.org/abs/";
    public static final String FORMATTER_PACKAGE = "net.sf.jabref.export.layout.format.";
    public static final String[] ENCODINGS;
    private static final String[] ALL_ENCODINGS;
    public static final Map<String, String> ENCODING_NAMES_LOOKUP;
    public static GlobalFocusListener focusListener;
    public static AutoSaveManager autoSaveManager;
    public static JabRefPreferences prefs;
    public static HelpDialog helpDiag;
    public static final String osName;
    public static final boolean ON_MAC;
    public static final boolean ON_WIN;
    public static final boolean ON_LINUX;
    public static final String[] SKIP_WORDS;
    public static final String SEPARATING_CHARS = ";,\n ";
    public static final String SEPARATING_CHARS_NOSPACE = ";,\n";
    public static SidePaneManager sidePaneManager;
    public static String NEWLINE;
    public static int NEWLINE_LENGTH;
    private static final Log LOGGER;
    public static final boolean UNIX_NEWLINE;
    public static final String BIBTEX_STRING = "__string";
    public static JournalAbbreviationRepository journalAbbrev;
    public static final String SPECIAL_COMMAND_CHARS = "\"`^~'c=";
    public static final HashMap<String, String> HTMLCHARS;
    public static final HashMap<String, String> XML_CHARS;
    public static final HashMap<String, String> ASCII2XML_CHARS;
    public static final HashMap<String, String> UNICODE_CHARS;
    public static final HashMap<String, String> RTFCHARS;
    private static final HashMap<String, String> URL_CHARS;

    public static void startBackgroundTasks() {
        focusListener = new GlobalFocusListener();
        streamEavesdropper = StreamEavesdropper.eavesdropOnSystem();
        fileUpdateMonitor = new FileUpdateMonitor();
        JabRefExecutorService.INSTANCE.executeWithLowPriorityInOwnThread(fileUpdateMonitor, "FileUpdateMonitor");
    }

    public static void startAutoSaveManager(JabRefFrame jabRefFrame) {
        autoSaveManager = new AutoSaveManager(jabRefFrame);
        autoSaveManager.startAutoSaveTimer();
    }

    public static void stopAutoSaveManager() {
        if (autoSaveManager != null) {
            autoSaveManager.stopAutoSaveTimer();
            autoSaveManager.clearAutoSaves();
            autoSaveManager = null;
        }
    }

    public static void setLanguage(String string, String string2) {
        locale = new Locale(string, string2);
        messages = ResourceBundle.getBundle(RESOURCE_PREFIX, locale, new EncodingControl("UTF-8"));
        menuTitles = ResourceBundle.getBundle(MENU_RESOURCE_PREFIX, locale, new EncodingControl("UTF-8"));
        intMessages = ResourceBundle.getBundle(INTEGRITY_RESOURCE_PREFIX, locale, new EncodingControl("UTF-8"));
        Locale.setDefault(locale);
        JComponent.setDefaultLocale(locale);
    }

    public static String lang(String string, String[] stringArray) {
        String string2 = null;
        try {
            if (messages != null) {
                string2 = messages.getString(string.replaceAll(" ", "_"));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = string;
        }
        if (string2 != null && string2.length() != 0) {
            string2 = string2.replaceAll("_", " ");
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            block8: for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '%') {
                    bl = true;
                    continue;
                }
                if (!bl) {
                    stringBuffer.append(c);
                    continue;
                }
                bl = false;
                try {
                    int n = Integer.parseInt(String.valueOf(c));
                    if (stringArray == null || n < 0 || n > stringArray.length) continue;
                    stringBuffer.append(stringArray[n]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    switch (c) {
                        case 'c': {
                            stringBuffer.append(':');
                            continue block8;
                        }
                        case 'e': {
                            stringBuffer.append('=');
                            continue block8;
                        }
                        default: {
                            stringBuffer.append(c);
                        }
                    }
                }
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String lang(String string) {
        return Globals.lang(string, (String[])null);
    }

    public static String lang(String string, String string2) {
        return Globals.lang(string, new String[]{string2});
    }

    public static String lang(String string, String string2, String string3) {
        return Globals.lang(string, new String[]{string2, string3});
    }

    public static String lang(String string, String string2, String string3, String string4) {
        return Globals.lang(string, new String[]{string2, string3, string4});
    }

    public static String menuTitle(String string) {
        String string2 = null;
        try {
            if (messages != null) {
                string2 = menuTitles.getString(string.replaceAll(" ", "_"));
            }
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        if (string2 != null && string2.length() != 0) {
            return string2.replaceAll("_", " ");
        }
        return string;
    }

    public static String getIntegrityMessage(String string) {
        String string2 = null;
        try {
            if (intMessages != null) {
                string2 = intMessages.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        if (string2 != null && string2.length() != 0) {
            return string2;
        }
        return string;
    }

    public static BibtexEntryType getEntryType(String string) {
        BibtexEntryType bibtexEntryType = BibtexEntryType.getType(string);
        if (bibtexEntryType != null) {
            return bibtexEntryType;
        }
        return BibtexEntryTypes.OTHER;
    }

    public static int getShortcutMask() {
        if (SHORTCUT_MASK == -1) {
            try {
                SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return SHORTCUT_MASK;
    }

    public static void initializeJournalNames() {
        String[] stringArray;
        journalAbbrev = new JournalAbbreviationRepository();
        journalAbbrev.readJournalListFromResource(JOURNALS_FILE_BUILTIN);
        if (prefs.getBoolean("useIEEEAbrv")) {
            journalAbbrev.readJournalListFromResource(JOURNALS_IEEE_INTERNAL_LIST);
        }
        if ((stringArray = prefs.getStringArray("externalJournalLists")) != null && stringArray.length > 0) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                try {
                    journalAbbrev.readJournalListFromFile(new File(stringArray[i]));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOGGER.info("Cannot find file", fileNotFoundException);
                }
            }
        }
        if (prefs.get("personalJournalList") != null) {
            try {
                journalAbbrev.readJournalListFromFile(new File(prefs.get("personalJournalList")));
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.info("Personal journal list file '" + prefs.get("personalJournalList") + "' not found.", fileNotFoundException);
            }
        }
    }

    public static Pattern getPatternForWords(ArrayList<String> arrayList) {
        if (arrayList == null || arrayList.isEmpty() || arrayList.get(0).isEmpty()) {
            return Pattern.compile("");
        }
        boolean bl = prefs.getBoolean("regExpSearch");
        String string = "(".concat(bl ? arrayList.get(0) : Pattern.quote(arrayList.get(0))).concat(")");
        for (int i = 1; i < arrayList.size(); ++i) {
            string = string.concat("|(").concat(bl ? arrayList.get(i) : Pattern.quote(arrayList.get(i))).concat(")");
        }
        Pattern pattern = prefs.getBoolean("caseSensitiveSearch") ? Pattern.compile(string) : Pattern.compile(string, 2);
        return pattern;
    }

    static {
        importFormatReader = new ImportFormatReader();
        BUILD_INFO = new BuildInfo();
        ALL_ENCODINGS = new String[]{"ISO8859_1", "UTF8", "UTF-16", "ASCII", "Cp1250", "Cp1251", "Cp1252", "Cp1253", "Cp1254", "Cp1257", "SJIS", "KOI8_R", "EUC_JP", "Big5", "Big5_HKSCS", "GBK", "ISO8859_2", "ISO8859_3", "ISO8859_4", "ISO8859_5", "ISO8859_6", "ISO8859_7", "ISO8859_8", "ISO8859_9", "ISO8859_13", "ISO8859_15"};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : ALL_ENCODINGS) {
            if (!Charset.isSupported(string)) continue;
            arrayList.add(string);
        }
        ENCODINGS = arrayList.toArray(new String[arrayList.size()]);
        ENCODING_NAMES_LOOKUP = new HashMap<String, String>();
        ENCODING_NAMES_LOOKUP.put("Cp1250", "windows-1250");
        ENCODING_NAMES_LOOKUP.put("Cp1251", "windows-1251");
        ENCODING_NAMES_LOOKUP.put("Cp1252", "windows-1252");
        ENCODING_NAMES_LOOKUP.put("Cp1253", "windows-1253");
        ENCODING_NAMES_LOOKUP.put("Cp1254", "windows-1254");
        ENCODING_NAMES_LOOKUP.put("Cp1257", "windows-1257");
        ENCODING_NAMES_LOOKUP.put("ISO8859_1", "ISO-8859-1");
        ENCODING_NAMES_LOOKUP.put("ISO8859_2", "ISO-8859-2");
        ENCODING_NAMES_LOOKUP.put("ISO8859_3", "ISO-8859-3");
        ENCODING_NAMES_LOOKUP.put("ISO8859_4", "ISO-8859-4");
        ENCODING_NAMES_LOOKUP.put("ISO8859_5", "ISO-8859-5");
        ENCODING_NAMES_LOOKUP.put("ISO8859_6", "ISO-8859-6");
        ENCODING_NAMES_LOOKUP.put("ISO8859_7", "ISO-8859-7");
        ENCODING_NAMES_LOOKUP.put("ISO8859_8", "ISO-8859-8");
        ENCODING_NAMES_LOOKUP.put("ISO8859_9", "ISO-8859-9");
        ENCODING_NAMES_LOOKUP.put("ISO8859_13", "ISO-8859-13");
        ENCODING_NAMES_LOOKUP.put("ISO8859_15", "ISO-8859-15");
        ENCODING_NAMES_LOOKUP.put("KOI8_R", "KOI8-R");
        ENCODING_NAMES_LOOKUP.put("UTF8", "UTF-8");
        ENCODING_NAMES_LOOKUP.put("UTF-16", "UTF-16");
        ENCODING_NAMES_LOOKUP.put("SJIS", "Shift_JIS");
        ENCODING_NAMES_LOOKUP.put("GBK", "GBK");
        ENCODING_NAMES_LOOKUP.put("Big5_HKSCS", "Big5-HKSCS");
        ENCODING_NAMES_LOOKUP.put("Big5", "Big5");
        ENCODING_NAMES_LOOKUP.put("EUC_JP", "EUC-JP");
        ENCODING_NAMES_LOOKUP.put("ASCII", "US-ASCII");
        autoSaveManager = null;
        prefs = null;
        helpDiag = null;
        osName = System.getProperty("os.name", "def");
        ON_MAC = osName.equals(MAC);
        ON_WIN = osName.startsWith("Windows");
        ON_LINUX = osName.startsWith("Linux");
        SKIP_WORDS = new String[]{"a", "an", "the", "for", "on", "of"};
        NEWLINE = System.getProperty("line.separator");
        NEWLINE_LENGTH = NEWLINE.length();
        LOGGER = LogFactory.getLog(Globals.class);
        UNIX_NEWLINE = NEWLINE.equals("\n");
        HTMLCHARS = new HashMap();
        XML_CHARS = new HashMap();
        ASCII2XML_CHARS = new HashMap();
        UNICODE_CHARS = new HashMap();
        RTFCHARS = new HashMap();
        URL_CHARS = new HashMap();
        URL_CHARS.put("<", "%3c");
        URL_CHARS.put(">", "%3e");
        URL_CHARS.put("(", "%28");
        URL_CHARS.put(")", "%29");
        URL_CHARS.put(" ", "%20");
        URL_CHARS.put("&", "%26");
        URL_CHARS.put("$", "%24");
        HTMLCHARS.put("`A", "&Agrave;");
        HTMLCHARS.put("'A", "&Aacute;");
        HTMLCHARS.put("^A", "&Acirc;");
        HTMLCHARS.put("~A", "&Atilde;");
        HTMLCHARS.put("\"A", "&Auml;");
        HTMLCHARS.put("AA", "&Aring;");
        HTMLCHARS.put("AE", "&AElig;");
        HTMLCHARS.put("cC", "&Ccedil;");
        HTMLCHARS.put("`E", "&Egrave;");
        HTMLCHARS.put("'E", "&Eacute;");
        HTMLCHARS.put("^E", "&Ecirc;");
        HTMLCHARS.put("\"E", "&Euml;");
        HTMLCHARS.put("`I", "&Igrave;");
        HTMLCHARS.put("'I", "&Iacute;");
        HTMLCHARS.put("^I", "&Icirc;");
        HTMLCHARS.put("\"I", "&Iuml;");
        HTMLCHARS.put("DH", "&ETH;");
        HTMLCHARS.put("~N", "&Ntilde;");
        HTMLCHARS.put("`O", "&Ograve;");
        HTMLCHARS.put("'O", "&Oacute;");
        HTMLCHARS.put("^O", "&Ocirc;");
        HTMLCHARS.put("~O", "&Otilde;");
        HTMLCHARS.put("\"O", "&Ouml;");
        HTMLCHARS.put("O", "&Oslash;");
        HTMLCHARS.put("`U", "&Ugrave;");
        HTMLCHARS.put("'U", "&Uacute;");
        HTMLCHARS.put("^U", "&Ucirc;");
        HTMLCHARS.put("\"U", "&Uuml;");
        HTMLCHARS.put("'Y", "&Yacute;");
        HTMLCHARS.put("TH", "&THORN;");
        HTMLCHARS.put("ss", "&szlig;");
        HTMLCHARS.put("`a", "&agrave;");
        HTMLCHARS.put("'a", "&aacute;");
        HTMLCHARS.put("^a", "&acirc;");
        HTMLCHARS.put("~a", "&atilde;");
        HTMLCHARS.put("\"a", "&auml;");
        HTMLCHARS.put("aa", "&aring;");
        HTMLCHARS.put("ae", "&aelig;");
        HTMLCHARS.put("cc", "&ccedil;");
        HTMLCHARS.put("`e", "&egrave;");
        HTMLCHARS.put("'e", "&eacute;");
        HTMLCHARS.put("^e", "&ecirc;");
        HTMLCHARS.put("\"e", "&euml;");
        HTMLCHARS.put("`i", "&igrave;");
        HTMLCHARS.put("'i", "&iacute;");
        HTMLCHARS.put("^i", "&icirc;");
        HTMLCHARS.put("\"i", "&iuml;");
        HTMLCHARS.put("dh", "&eth;");
        HTMLCHARS.put("~n", "&ntilde;");
        HTMLCHARS.put("`o", "&ograve;");
        HTMLCHARS.put("'o", "&oacute;");
        HTMLCHARS.put("^o", "&ocirc;");
        HTMLCHARS.put("~o", "&otilde;");
        HTMLCHARS.put("\"o", "&ouml;");
        HTMLCHARS.put("o", "&oslash;");
        HTMLCHARS.put("`u", "&ugrave;");
        HTMLCHARS.put("'u", "&uacute;");
        HTMLCHARS.put("^u", "&ucirc;");
        HTMLCHARS.put("\"u", "&uuml;");
        HTMLCHARS.put("'y", "&yacute;");
        HTMLCHARS.put("th", "&thorn;");
        HTMLCHARS.put("\"y", "&yuml;");
        HTMLCHARS.put("=A", "&#256;");
        HTMLCHARS.put("=a", "&#257;");
        HTMLCHARS.put("uA", "&#258;");
        HTMLCHARS.put("ua", "&#259;");
        HTMLCHARS.put("kA", "&#260;");
        HTMLCHARS.put("ka", "&#261;");
        HTMLCHARS.put("'C", "&#262;");
        HTMLCHARS.put("'c", "&#263;");
        HTMLCHARS.put("^C", "&#264;");
        HTMLCHARS.put("^c", "&#265;");
        HTMLCHARS.put(".C", "&#266;");
        HTMLCHARS.put(".c", "&#267;");
        HTMLCHARS.put("vC", "&#268;");
        HTMLCHARS.put("vc", "&#269;");
        HTMLCHARS.put("vD", "&#270;");
        HTMLCHARS.put("DJ", "&#272;");
        HTMLCHARS.put("dj", "&#273;");
        HTMLCHARS.put("=E", "&#274;");
        HTMLCHARS.put("=e", "&#275;");
        HTMLCHARS.put("uE", "&#276;");
        HTMLCHARS.put("ue", "&#277;");
        HTMLCHARS.put(".E", "&#278;");
        HTMLCHARS.put(".e", "&#279;");
        HTMLCHARS.put("kE", "&#280;");
        HTMLCHARS.put("ke", "&#281;");
        HTMLCHARS.put("vE", "&#282;");
        HTMLCHARS.put("ve", "&#283;");
        HTMLCHARS.put("^G", "&#284;");
        HTMLCHARS.put("^g", "&#285;");
        HTMLCHARS.put("uG", "&#286;");
        HTMLCHARS.put("ug", "&#287;");
        HTMLCHARS.put(".G", "&#288;");
        HTMLCHARS.put(".g", "&#289;");
        HTMLCHARS.put("cG", "&#290;");
        HTMLCHARS.put("'g", "&#291;");
        HTMLCHARS.put("^H", "&#292;");
        HTMLCHARS.put("^h", "&#293;");
        HTMLCHARS.put("Hstrok", "&#294;");
        HTMLCHARS.put("hstrok", "&#295;");
        HTMLCHARS.put("~I", "&#296;");
        HTMLCHARS.put("~i", "&#297;");
        HTMLCHARS.put("=I", "&#298;");
        HTMLCHARS.put("=i", "&#299;");
        HTMLCHARS.put("uI", "&#300;");
        HTMLCHARS.put("ui", "&#301;");
        HTMLCHARS.put("kI", "&#302;");
        HTMLCHARS.put("ki", "&#303;");
        HTMLCHARS.put(".I", "&#304;");
        HTMLCHARS.put("i", "&#305;");
        HTMLCHARS.put("^J", "&#308;");
        HTMLCHARS.put("^j", "&#309;");
        HTMLCHARS.put("cK", "&#310;");
        HTMLCHARS.put("ck", "&#311;");
        HTMLCHARS.put("'L", "&#313;");
        HTMLCHARS.put("'l", "&#314;");
        HTMLCHARS.put("cL", "&#315;");
        HTMLCHARS.put("cl", "&#316;");
        HTMLCHARS.put("Lmidot", "&#319;");
        HTMLCHARS.put("lmidot", "&#320;");
        HTMLCHARS.put("L", "&#321;");
        HTMLCHARS.put("l", "&#322;");
        HTMLCHARS.put("'N", "&#323;");
        HTMLCHARS.put("'n", "&#324;");
        HTMLCHARS.put("cN", "&#325;");
        HTMLCHARS.put("cn", "&#326;");
        HTMLCHARS.put("vN", "&#327;");
        HTMLCHARS.put("vn", "&#328;");
        HTMLCHARS.put("NG", "&#330;");
        HTMLCHARS.put("ng", "&#331;");
        HTMLCHARS.put("=O", "&#332;");
        HTMLCHARS.put("=o", "&#333;");
        HTMLCHARS.put("uO", "&#334;");
        HTMLCHARS.put("uo", "&#335;");
        HTMLCHARS.put("HO", "&#336;");
        HTMLCHARS.put("Ho", "&#337;");
        HTMLCHARS.put("OE", "&#338;");
        HTMLCHARS.put("oe", "&#339;");
        HTMLCHARS.put("'R", "&#340;");
        HTMLCHARS.put("'r", "&#341;");
        HTMLCHARS.put("cR", "&#342;");
        HTMLCHARS.put("cr", "&#343;");
        HTMLCHARS.put("vR", "&#344;");
        HTMLCHARS.put("vr", "&#345;");
        HTMLCHARS.put("'S", "&#346;");
        HTMLCHARS.put("'s", "&#347;");
        HTMLCHARS.put("^S", "&#348;");
        HTMLCHARS.put("^s", "&#349;");
        HTMLCHARS.put("cS", "&#350;");
        HTMLCHARS.put("cs", "&#351;");
        HTMLCHARS.put("vS", "&#352;");
        HTMLCHARS.put("vs", "&#353;");
        HTMLCHARS.put("cT", "&#354;");
        HTMLCHARS.put("ct", "&#355;");
        HTMLCHARS.put("vT", "&#356;");
        HTMLCHARS.put("Tstrok", "&#358;");
        HTMLCHARS.put("tstrok", "&#359;");
        HTMLCHARS.put("~U", "&#360;");
        HTMLCHARS.put("~u", "&#361;");
        HTMLCHARS.put("=U", "&#362;");
        HTMLCHARS.put("=u", "&#363;");
        HTMLCHARS.put("uU", "&#364;");
        HTMLCHARS.put("uu", "&#365;");
        HTMLCHARS.put("rU", "&#366;");
        HTMLCHARS.put("ru", "&#367;");
        HTMLCHARS.put("HU", "&#368;");
        HTMLCHARS.put("Hu", "&#369;");
        HTMLCHARS.put("kU", "&#370;");
        HTMLCHARS.put("ku", "&#371;");
        HTMLCHARS.put("^W", "&#372;");
        HTMLCHARS.put("^w", "&#373;");
        HTMLCHARS.put("^Y", "&#374;");
        HTMLCHARS.put("^y", "&#375;");
        HTMLCHARS.put("\"Y", "&#376;");
        HTMLCHARS.put("'Z", "&#377;");
        HTMLCHARS.put("'z", "&#378;");
        HTMLCHARS.put(".Z", "&#379;");
        HTMLCHARS.put(".z", "&#380;");
        HTMLCHARS.put("vZ", "&#381;");
        HTMLCHARS.put("vz", "&#382;");
        HTMLCHARS.put("%", "%");
        XML_CHARS.put("\\{\\\\\\\"\\{a\\}\\}", "&#x00E4;");
        XML_CHARS.put("\\{\\\\\\\"\\{A\\}\\}", "&#x00C4;");
        XML_CHARS.put("\\{\\\\\\\"\\{e\\}\\}", "&#x00EB;");
        XML_CHARS.put("\\{\\\\\\\"\\{E\\}\\}", "&#x00CB;");
        XML_CHARS.put("\\{\\\\\\\"\\{i\\}\\}", "&#x00EF;");
        XML_CHARS.put("\\{\\\\\\\"\\{I\\}\\}", "&#x00CF;");
        XML_CHARS.put("\\{\\\\\\\"\\{o\\}\\}", "&#x00F6;");
        XML_CHARS.put("\\{\\\\\\\"\\{O\\}\\}", "&#x00D6;");
        XML_CHARS.put("\\{\\\\\\\"\\{u\\}\\}", "&#x00FC;");
        XML_CHARS.put("\\{\\\\\\\"\\{U\\}\\}", "&#x00DC;");
        XML_CHARS.put("\\{\\\\\\`\\{a\\}\\}", "&#x00E0;");
        XML_CHARS.put("\\{\\\\\\`\\{A\\}\\}", "&#x00C0;");
        XML_CHARS.put("\\{\\\\\\`\\{e\\}\\}", "&#x00E8;");
        XML_CHARS.put("\\{\\\\\\`\\{E\\}\\}", "&#x00C8;");
        XML_CHARS.put("\\{\\\\\\`\\{i\\}\\}", "&#x00EC;");
        XML_CHARS.put("\\{\\\\\\`\\{I\\}\\}", "&#x00CC;");
        XML_CHARS.put("\\{\\\\\\`\\{o\\}\\}", "&#x00F2;");
        XML_CHARS.put("\\{\\\\\\`\\{O\\}\\}", "&#x00D2;");
        XML_CHARS.put("\\{\\\\\\`\\{u\\}\\}", "&#x00F9;");
        XML_CHARS.put("\\{\\\\\\`\\{U\\}\\}", "&#x00D9;");
        XML_CHARS.put("\\{\\\\\\'\\{a\\}\\}", "&#x00E1;");
        XML_CHARS.put("\\{\\\\\\'\\{A\\}\\}", "&#x00C1;");
        XML_CHARS.put("\\{\\\\\\'\\{e\\}\\}", "&#x00E9;");
        XML_CHARS.put("\\{\\\\\\'\\{E\\}\\}", "&#x00C9;");
        XML_CHARS.put("\\{\\\\\\'\\{i\\}\\}", "&#x00ED;");
        XML_CHARS.put("\\{\\\\\\'\\{I\\}\\}", "&#x00CD;");
        XML_CHARS.put("\\{\\\\\\'\\{o\\}\\}", "&#x00F3;");
        XML_CHARS.put("\\{\\\\\\'\\{O\\}\\}", "&#x00D3;");
        XML_CHARS.put("\\{\\\\\\'\\{u\\}\\}", "&#x00FA;");
        XML_CHARS.put("\\{\\\\\\'\\{U\\}\\}", "&#x00DA;");
        XML_CHARS.put("\\{\\\\\\'\\{c\\}\\}", "&#x0107;");
        XML_CHARS.put("\\{\\\\\\'\\{C\\}\\}", "&#x0106;");
        XML_CHARS.put("\\{\\\\c\\{c\\}\\}", "&#x00E7;");
        XML_CHARS.put("\\{\\\\c\\{C\\}\\}", "&#x00C7;");
        XML_CHARS.put("\\{\\\\\\\ufffd\\{E\\}\\}", "&#x00C9;");
        XML_CHARS.put("\\{\\\\\\\ufffd\\{i\\}\\}", "&#x00ED;");
        XML_CHARS.put("\\{\\\\\\\ufffd\\{I\\}\\}", "&#x00CD;");
        XML_CHARS.put("\\{\\\\\\\ufffd\\{o\\}\\}", "&#x00F3;");
        XML_CHARS.put("\\{\\\\\\\ufffd\\{O\\}\\}", "&#x00D3;");
        XML_CHARS.put("\\{\\\\\\\ufffd\\{u\\}\\}", "&#x00FA;");
        XML_CHARS.put("\\{\\\\\\\ufffd\\{U\\}\\}", "&#x00DA;");
        XML_CHARS.put("\\{\\\\\\\ufffd\\{a\\}\\}", "&#x00E1;");
        XML_CHARS.put("\\{\\\\\\\ufffd\\{A\\}\\}", "&#x00C1;");
        XML_CHARS.put("\\{\\\\\\^\\{a\\}\\}", "&#x00E2;");
        XML_CHARS.put("\\{\\\\\\^\\{A\\}\\}", "&#x00C2;");
        XML_CHARS.put("\\{\\\\\\^\\{o\\}\\}", "&#x00F4;");
        XML_CHARS.put("\\{\\\\\\^\\{O\\}\\}", "&#x00D4;");
        XML_CHARS.put("\\{\\\\\\^\\{u\\}\\}", "&#x00F9;");
        XML_CHARS.put("\\{\\\\\\^\\{U\\}\\}", "&#x00D9;");
        XML_CHARS.put("\\{\\\\\\^\\{e\\}\\}", "&#x00EA;");
        XML_CHARS.put("\\{\\\\\\^\\{E\\}\\}", "&#x00CA;");
        XML_CHARS.put("\\{\\\\\\^\\{i\\}\\}", "&#x00EE;");
        XML_CHARS.put("\\{\\\\\\^\\{I\\}\\}", "&#x00CE;");
        XML_CHARS.put("\\{\\\\\\~\\{o\\}\\}", "&#x00F5;");
        XML_CHARS.put("\\{\\\\\\~\\{O\\}\\}", "&#x00D5;");
        XML_CHARS.put("\\{\\\\\\~\\{n\\}\\}", "&#x00F1;");
        XML_CHARS.put("\\{\\\\\\~\\{N\\}\\}", "&#x00D1;");
        XML_CHARS.put("\\{\\\\\\~\\{a\\}\\}", "&#x00E3;");
        XML_CHARS.put("\\{\\\\\\~\\{A\\}\\}", "&#x00C3;");
        XML_CHARS.put("\\{\\\\\\\"a\\}", "&#x00E4;");
        XML_CHARS.put("\\{\\\\\\\"A\\}", "&#x00C4;");
        XML_CHARS.put("\\{\\\\\\\"e\\}", "&#x00EB;");
        XML_CHARS.put("\\{\\\\\\\"E\\}", "&#x00CB;");
        XML_CHARS.put("\\{\\\\\\\"i\\}", "&#x00EF;");
        XML_CHARS.put("\\{\\\\\\\"I\\}", "&#x00CF;");
        XML_CHARS.put("\\{\\\\\\\"o\\}", "&#x00F6;");
        XML_CHARS.put("\\{\\\\\\\"O\\}", "&#x00D6;");
        XML_CHARS.put("\\{\\\\\\\"u\\}", "&#x00FC;");
        XML_CHARS.put("\\{\\\\\\\"U\\}", "&#x00DC;");
        XML_CHARS.put("\\{\\\\\\`a\\}", "&#x00E0;");
        XML_CHARS.put("\\{\\\\\\`A\\}", "&#x00C0;");
        XML_CHARS.put("\\{\\\\\\`e\\}", "&#x00E8;");
        XML_CHARS.put("\\{\\\\\\`E\\}", "&#x00C8;");
        XML_CHARS.put("\\{\\\\\\`i\\}", "&#x00EC;");
        XML_CHARS.put("\\{\\\\\\`I\\}", "&#x00CC;");
        XML_CHARS.put("\\{\\\\\\`o\\}", "&#x00F2;");
        XML_CHARS.put("\\{\\\\\\`O\\}", "&#x00D2;");
        XML_CHARS.put("\\{\\\\\\`u\\}", "&#x00F9;");
        XML_CHARS.put("\\{\\\\\\`U\\}", "&#x00D9;");
        XML_CHARS.put("\\{\\\\\\'e\\}", "&#x00E9;");
        XML_CHARS.put("\\{\\\\\\'E\\}", "&#x00C9;");
        XML_CHARS.put("\\{\\\\\\'i\\}", "&#x00ED;");
        XML_CHARS.put("\\{\\\\\\'I\\}", "&#x00CD;");
        XML_CHARS.put("\\{\\\\\\'o\\}", "&#x00F3;");
        XML_CHARS.put("\\{\\\\\\'O\\}", "&#x00D3;");
        XML_CHARS.put("\\{\\\\\\'u\\}", "&#x00FA;");
        XML_CHARS.put("\\{\\\\\\'U\\}", "&#x00DA;");
        XML_CHARS.put("\\{\\\\\\'a\\}", "&#x00E1;");
        XML_CHARS.put("\\{\\\\\\'A\\}", "&#x00C1;");
        XML_CHARS.put("\\{\\\\\\'c\\}", "&#x0107;");
        XML_CHARS.put("\\{\\\\\\'C\\}", "&#x0106;");
        XML_CHARS.put("\\{\\\\\\^a\\}", "&#x00E2;");
        XML_CHARS.put("\\{\\\\\\^A\\}", "&#x00C2;");
        XML_CHARS.put("\\{\\\\\\^o\\}", "&#x00F4;");
        XML_CHARS.put("\\{\\\\\\^O\\}", "&#x00D4;");
        XML_CHARS.put("\\{\\\\\\^u\\}", "&#x00F9;");
        XML_CHARS.put("\\{\\\\\\^U\\}", "&#x00D9;");
        XML_CHARS.put("\\{\\\\\\^e\\}", "&#x00EA;");
        XML_CHARS.put("\\{\\\\\\^E\\}", "&#x00CA;");
        XML_CHARS.put("\\{\\\\\\^i\\}", "&#x00EE;");
        XML_CHARS.put("\\{\\\\\\^I\\}", "&#x00CE;");
        XML_CHARS.put("\\{\\\\\\~o\\}", "&#x00F5;");
        XML_CHARS.put("\\{\\\\\\~O\\}", "&#x00D5;");
        XML_CHARS.put("\\{\\\\\\~n\\}", "&#x00F1;");
        XML_CHARS.put("\\{\\\\\\~N\\}", "&#x00D1;");
        XML_CHARS.put("\\{\\\\\\~a\\}", "&#x00E3;");
        XML_CHARS.put("\\{\\\\\\~A\\}", "&#x00C3;");
        ASCII2XML_CHARS.put("<", "&lt;");
        ASCII2XML_CHARS.put("\"", "&quot;");
        ASCII2XML_CHARS.put(">", "&gt;");
        UNICODE_CHARS.put("\u00c0", "A");
        UNICODE_CHARS.put("\u00c1", "A");
        UNICODE_CHARS.put("\u00c2", "A");
        UNICODE_CHARS.put("\u00c3", "A");
        UNICODE_CHARS.put("\u00c4", "Ae");
        UNICODE_CHARS.put("\u00c5", "Aa");
        UNICODE_CHARS.put("\u00c6", "Ae");
        UNICODE_CHARS.put("\u00c7", "C");
        UNICODE_CHARS.put("\u00c8", "E");
        UNICODE_CHARS.put("\u00c9", "E");
        UNICODE_CHARS.put("\u00ca", "E");
        UNICODE_CHARS.put("\u00cb", "E");
        UNICODE_CHARS.put("\u00cc", "I");
        UNICODE_CHARS.put("\u00cd", "I");
        UNICODE_CHARS.put("\u00ce", "I");
        UNICODE_CHARS.put("\u00cf", "I");
        UNICODE_CHARS.put("\u00d0", "D");
        UNICODE_CHARS.put("\u00d1", "N");
        UNICODE_CHARS.put("\u00d2", "O");
        UNICODE_CHARS.put("\u00d3", "O");
        UNICODE_CHARS.put("\u00d4", "O");
        UNICODE_CHARS.put("\u00d5", "O");
        UNICODE_CHARS.put("\u00d6", "Oe");
        UNICODE_CHARS.put("\u00d8", "Oe");
        UNICODE_CHARS.put("\u00d9", "U");
        UNICODE_CHARS.put("\u00da", "U");
        UNICODE_CHARS.put("\u00db", "U");
        UNICODE_CHARS.put("\u00dc", "Ue");
        UNICODE_CHARS.put("\u00dd", "Y");
        UNICODE_CHARS.put("\u00df", "ss");
        UNICODE_CHARS.put("\u00e0", "a");
        UNICODE_CHARS.put("\u00e1", "a");
        UNICODE_CHARS.put("\u00e2", "a");
        UNICODE_CHARS.put("\u00e3", "a");
        UNICODE_CHARS.put("\u00e4", "ae");
        UNICODE_CHARS.put("\u00e5", "aa");
        UNICODE_CHARS.put("\u00e6", "ae");
        UNICODE_CHARS.put("\u00e7", "c");
        UNICODE_CHARS.put("\u00e8", "e");
        UNICODE_CHARS.put("\u00e9", "e");
        UNICODE_CHARS.put("\u00ea", "e");
        UNICODE_CHARS.put("\u00eb", "e");
        UNICODE_CHARS.put("\u00ec", "i");
        UNICODE_CHARS.put("\u00ed", "i");
        UNICODE_CHARS.put("\u00ee", "i");
        UNICODE_CHARS.put("\u00ef", "i");
        UNICODE_CHARS.put("\u00f0", "o");
        UNICODE_CHARS.put("\u00f1", "n");
        UNICODE_CHARS.put("\u00f2", "o");
        UNICODE_CHARS.put("\u00f3", "o");
        UNICODE_CHARS.put("\u00f4", "o");
        UNICODE_CHARS.put("\u00f5", "o");
        UNICODE_CHARS.put("\u00f6", "oe");
        UNICODE_CHARS.put("\u00f8", "oe");
        UNICODE_CHARS.put("\u00f9", "u");
        UNICODE_CHARS.put("\u00fa", "u");
        UNICODE_CHARS.put("\u00fb", "u");
        UNICODE_CHARS.put("\u00fc", "ue");
        UNICODE_CHARS.put("\u00fd", "y");
        UNICODE_CHARS.put("\u00ff", "y");
        UNICODE_CHARS.put("\u0100", "A");
        UNICODE_CHARS.put("\u0101", "a");
        UNICODE_CHARS.put("\u0102", "A");
        UNICODE_CHARS.put("\u0103", "a");
        UNICODE_CHARS.put("\u0104", "A");
        UNICODE_CHARS.put("\u0105", "a");
        UNICODE_CHARS.put("\u0106", "C");
        UNICODE_CHARS.put("\u0107", "c");
        UNICODE_CHARS.put("\u0108", "C");
        UNICODE_CHARS.put("\u0109", "c");
        UNICODE_CHARS.put("\u010a", "C");
        UNICODE_CHARS.put("\u010b", "c");
        UNICODE_CHARS.put("\u010c", "C");
        UNICODE_CHARS.put("\u010d", "c");
        UNICODE_CHARS.put("\u010e", "D");
        UNICODE_CHARS.put("\u010f", "d");
        UNICODE_CHARS.put("\u0110", "D");
        UNICODE_CHARS.put("\u0111", "d");
        UNICODE_CHARS.put("\u0112", "E");
        UNICODE_CHARS.put("\u0113", "e");
        UNICODE_CHARS.put("\u0114", "E");
        UNICODE_CHARS.put("\u0115", "e");
        UNICODE_CHARS.put("\u0116", "E");
        UNICODE_CHARS.put("\u0117", "e");
        UNICODE_CHARS.put("\u0118", "E");
        UNICODE_CHARS.put("\u0119", "e");
        UNICODE_CHARS.put("\u011a", "E");
        UNICODE_CHARS.put("\u011b", "e");
        UNICODE_CHARS.put("\u011c", "G");
        UNICODE_CHARS.put("\u011d", "g");
        UNICODE_CHARS.put("\u011e", "G");
        UNICODE_CHARS.put("\u011f", "g");
        UNICODE_CHARS.put("\u0120", "G");
        UNICODE_CHARS.put("\u0121", "g");
        UNICODE_CHARS.put("\u0122", "G");
        UNICODE_CHARS.put("\u0123", "g");
        UNICODE_CHARS.put("\u0124", "H");
        UNICODE_CHARS.put("\u0125", "h");
        UNICODE_CHARS.put("\u0127", "h");
        UNICODE_CHARS.put("\u0128", "I");
        UNICODE_CHARS.put("\u0129", "i");
        UNICODE_CHARS.put("\u012a", "I");
        UNICODE_CHARS.put("\u012b", "i");
        UNICODE_CHARS.put("\u012c", "I");
        UNICODE_CHARS.put("\u012d", "i");
        UNICODE_CHARS.put("\u012e", "I");
        UNICODE_CHARS.put("\u012f", "i");
        UNICODE_CHARS.put("\u0130", "I");
        UNICODE_CHARS.put("\u0131", "i");
        UNICODE_CHARS.put("\u0132", "IJ");
        UNICODE_CHARS.put("\u0133", "ij");
        UNICODE_CHARS.put("\u0134", "J");
        UNICODE_CHARS.put("\u0135", "j");
        UNICODE_CHARS.put("\u0136", "K");
        UNICODE_CHARS.put("\u0137", "k");
        UNICODE_CHARS.put("\u0138", "k");
        UNICODE_CHARS.put("\u0139", "L");
        UNICODE_CHARS.put("\u013a", "l");
        UNICODE_CHARS.put("\u013b", "L");
        UNICODE_CHARS.put("\u013c", "l");
        UNICODE_CHARS.put("\u013d", "L");
        UNICODE_CHARS.put("\u013e", "l");
        UNICODE_CHARS.put("\u013f", "L");
        UNICODE_CHARS.put("\u0140", "l");
        UNICODE_CHARS.put("\u0141", "L");
        UNICODE_CHARS.put("\u0142", "l");
        UNICODE_CHARS.put("\u0143", "N");
        UNICODE_CHARS.put("\u0144", "n");
        UNICODE_CHARS.put("\u0145", "N");
        UNICODE_CHARS.put("\u0146", "n");
        UNICODE_CHARS.put("\u0147", "N");
        UNICODE_CHARS.put("\u0148", "n");
        UNICODE_CHARS.put("\u0149", "n");
        UNICODE_CHARS.put("\u014a", "N");
        UNICODE_CHARS.put("\u014b", "n");
        UNICODE_CHARS.put("\u014c", "O");
        UNICODE_CHARS.put("\u014d", "o");
        UNICODE_CHARS.put("\u014e", "O");
        UNICODE_CHARS.put("\u014f", "o");
        UNICODE_CHARS.put("\u0150", "Oe");
        UNICODE_CHARS.put("\u0151", "oe");
        UNICODE_CHARS.put("\u0152", "OE");
        UNICODE_CHARS.put("\u0153", "oe");
        UNICODE_CHARS.put("\u0154", "R");
        UNICODE_CHARS.put("\u0155", "r");
        UNICODE_CHARS.put("\u0156", "R");
        UNICODE_CHARS.put("\u0157", "r");
        UNICODE_CHARS.put("\u0158", "R");
        UNICODE_CHARS.put("\u0159", "r");
        UNICODE_CHARS.put("\u015a", "S");
        UNICODE_CHARS.put("\u015b", "s");
        UNICODE_CHARS.put("\u015c", "S");
        UNICODE_CHARS.put("\u015d", "s");
        UNICODE_CHARS.put("\u015e", "S");
        UNICODE_CHARS.put("\u015f", "s");
        UNICODE_CHARS.put("\u0160", "S");
        UNICODE_CHARS.put("\u0161", "s");
        UNICODE_CHARS.put("\u0162", "T");
        UNICODE_CHARS.put("\u0163", "t");
        UNICODE_CHARS.put("\u0164", "T");
        UNICODE_CHARS.put("\u0165", "t");
        UNICODE_CHARS.put("\u0166", "T");
        UNICODE_CHARS.put("\u0167", "t");
        UNICODE_CHARS.put("\u0168", "U");
        UNICODE_CHARS.put("\u0169", "u");
        UNICODE_CHARS.put("\u016a", "U");
        UNICODE_CHARS.put("\u016b", "u");
        UNICODE_CHARS.put("\u016c", "U");
        UNICODE_CHARS.put("\u016d", "u");
        UNICODE_CHARS.put("\u016e", "UU");
        UNICODE_CHARS.put("\u016f", "uu");
        UNICODE_CHARS.put("\u0170", "Ue");
        UNICODE_CHARS.put("\u0171", "ue");
        UNICODE_CHARS.put("\u0172", "U");
        UNICODE_CHARS.put("\u0173", "u");
        UNICODE_CHARS.put("\u0174", "W");
        UNICODE_CHARS.put("\u0175", "w");
        UNICODE_CHARS.put("\u0176", "Y");
        UNICODE_CHARS.put("\u0177", "y");
        UNICODE_CHARS.put("\u0178", "Y");
        UNICODE_CHARS.put("\u0179", "Z");
        UNICODE_CHARS.put("\u017a", "z");
        UNICODE_CHARS.put("\u017b", "Z");
        UNICODE_CHARS.put("\u017c", "z");
        UNICODE_CHARS.put("\u017d", "Z");
        UNICODE_CHARS.put("\u017e", "z");
        UNICODE_CHARS.put("\u1ebc", "E");
        UNICODE_CHARS.put("\u1ebd", "e");
        UNICODE_CHARS.put("\u1ef8", "Y");
        UNICODE_CHARS.put("\u1ef9", "y");
        UNICODE_CHARS.put("\u01cd", "A");
        UNICODE_CHARS.put("\u01ce", "a");
        UNICODE_CHARS.put("\u01cf", "I");
        UNICODE_CHARS.put("\u01d0", "i");
        UNICODE_CHARS.put("\u01d1", "O");
        UNICODE_CHARS.put("\u01d2", "o");
        UNICODE_CHARS.put("\u01d3", "U");
        UNICODE_CHARS.put("\u01d4", "u");
        UNICODE_CHARS.put("\u0232", "Y");
        UNICODE_CHARS.put("\u0233", "y");
        UNICODE_CHARS.put("\u01ea", "O");
        UNICODE_CHARS.put("\u01eb", "o");
        UNICODE_CHARS.put("\u1e0c", "D");
        UNICODE_CHARS.put("\u1e0d", "d");
        UNICODE_CHARS.put("\u1e24", "H");
        UNICODE_CHARS.put("\u1e25", "h");
        UNICODE_CHARS.put("\u1e36", "L");
        UNICODE_CHARS.put("\u1e37", "l");
        UNICODE_CHARS.put("\u1e38", "L");
        UNICODE_CHARS.put("\u1e39", "l");
        UNICODE_CHARS.put("\u1e42", "M");
        UNICODE_CHARS.put("\u1e43", "m");
        UNICODE_CHARS.put("\u1e46", "N");
        UNICODE_CHARS.put("\u1e47", "n");
        UNICODE_CHARS.put("\u1e5a", "R");
        UNICODE_CHARS.put("\u1e5b", "r");
        UNICODE_CHARS.put("\u1e5c", "R");
        UNICODE_CHARS.put("\u1e5d", "r");
        UNICODE_CHARS.put("\u1e62", "S");
        UNICODE_CHARS.put("\u1e63", "s");
        UNICODE_CHARS.put("\u1e6c", "T");
        UNICODE_CHARS.put("\u1e6d", "t");
        UNICODE_CHARS.put("\u00cf", "I");
        UNICODE_CHARS.put("\u008c", "AE");
        UNICODE_CHARS.put("\u016e", "U");
        UNICODE_CHARS.put("\u016f", "u");
        UNICODE_CHARS.put("\u0178", "Y");
        UNICODE_CHARS.put("\u00fe", "");
        RTFCHARS.put("`a", "\\'e0");
        RTFCHARS.put("`e", "\\'e8");
        RTFCHARS.put("`i", "\\'ec");
        RTFCHARS.put("`o", "\\'f2");
        RTFCHARS.put("`u", "\\'f9");
        RTFCHARS.put("?a", "\\'e1");
        RTFCHARS.put("?e", "\\'e9");
        RTFCHARS.put("?i", "\\'ed");
        RTFCHARS.put("?o", "\\'f3");
        RTFCHARS.put("?u", "\\'fa");
        RTFCHARS.put("^a", "\\'e2");
        RTFCHARS.put("^e", "\\'ea");
        RTFCHARS.put("^i", "\\'ee");
        RTFCHARS.put("^o", "\\'f4");
        RTFCHARS.put("^u", "\\'fa");
        RTFCHARS.put("\"a", "\\'e4");
        RTFCHARS.put("\"e", "\\'eb");
        RTFCHARS.put("\"i", "\\'ef");
        RTFCHARS.put("\"o", "\\'f6");
        RTFCHARS.put("\"u", "\\u252u");
        RTFCHARS.put("~n", "\\'f1");
        RTFCHARS.put("`A", "\\'c0");
        RTFCHARS.put("`E", "\\'c8");
        RTFCHARS.put("`I", "\\'cc");
        RTFCHARS.put("`O", "\\'d2");
        RTFCHARS.put("`U", "\\'d9");
        RTFCHARS.put("?A", "\\'c1");
        RTFCHARS.put("?E", "\\'c9");
        RTFCHARS.put("?I", "\\'cd");
        RTFCHARS.put("?O", "\\'d3");
        RTFCHARS.put("?U", "\\'da");
        RTFCHARS.put("^A", "\\'c2");
        RTFCHARS.put("^E", "\\'ca");
        RTFCHARS.put("^I", "\\'ce");
        RTFCHARS.put("^O", "\\'d4");
        RTFCHARS.put("^U", "\\'db");
        RTFCHARS.put("\"A", "\\'c4");
        RTFCHARS.put("\"E", "\\'cb");
        RTFCHARS.put("\"I", "\\'cf");
        RTFCHARS.put("\"O", "\\'d6");
        RTFCHARS.put("\"U", "\\'dc");
        RTFCHARS.put("`A", "\\u192A");
        RTFCHARS.put("'A", "\\u193A");
        RTFCHARS.put("^A", "\\u194A");
        RTFCHARS.put("~A", "\\u195A");
        RTFCHARS.put("\"A", "\\u196A");
        RTFCHARS.put("AA", "\\u197A");
        RTFCHARS.put("AE", "{\\u198A}");
        RTFCHARS.put("cC", "\\u199C");
        RTFCHARS.put("`E", "\\u200E");
        RTFCHARS.put("'E", "\\u201E");
        RTFCHARS.put("^E", "\\u202E");
        RTFCHARS.put("\"E", "\\u203E");
        RTFCHARS.put("`I", "\\u204I");
        RTFCHARS.put("'I", "\\u205I");
        RTFCHARS.put("^I", "\\u206I");
        RTFCHARS.put("\"I", "\\u207I");
        RTFCHARS.put("DH", "\\u208D");
        RTFCHARS.put("~N", "\\u209N");
        RTFCHARS.put("`O", "\\u210O");
        RTFCHARS.put("'O", "\\u211O");
        RTFCHARS.put("^O", "\\u212O");
        RTFCHARS.put("~O", "\\u213O");
        RTFCHARS.put("\"O", "\\u214O");
        RTFCHARS.put("O", "\\u216O");
        RTFCHARS.put("o", "\\'f8");
        RTFCHARS.put("`U", "\\u217U");
        RTFCHARS.put("'U", "\\u218U");
        RTFCHARS.put("^U", "\\u219U");
        RTFCHARS.put("\"U", "\\u220U");
        RTFCHARS.put("'Y", "\\u221Y");
        RTFCHARS.put("TH", "{\\uc2\\u222TH}");
        RTFCHARS.put("ss", "{\\uc2\\u223ss}");
        RTFCHARS.put("`a", "\\u224a");
        RTFCHARS.put("'a", "\\u225a");
        RTFCHARS.put("^a", "\\u226a");
        RTFCHARS.put("~a", "\\u227a");
        RTFCHARS.put("\"a", "\\u228a");
        RTFCHARS.put("aa", "\\u229a");
        RTFCHARS.put("ae", "{\\u230a}");
        RTFCHARS.put("cc", "\\u231c");
        RTFCHARS.put("`e", "\\u232e");
        RTFCHARS.put("'e", "\\u233e");
        RTFCHARS.put("^e", "\\u234e");
        RTFCHARS.put("\"e", "\\u235e");
        RTFCHARS.put("`i", "\\u236i");
        RTFCHARS.put("'i", "\\u237i");
        RTFCHARS.put("^i", "\\u238i");
        RTFCHARS.put("\"i", "\\u239i");
        RTFCHARS.put("dh", "\\u240d");
        RTFCHARS.put("~n", "\\u241n");
        RTFCHARS.put("`o", "\\u242o");
        RTFCHARS.put("'o", "\\u243o");
        RTFCHARS.put("^o", "\\u244o");
        RTFCHARS.put("~o", "\\u245o");
        RTFCHARS.put("\"o", "\\u246o");
        RTFCHARS.put("o", "\\u248o");
        RTFCHARS.put("`u", "\\u249u");
        RTFCHARS.put("'u", "\\u250u");
        RTFCHARS.put("^u", "\\u251u");
        RTFCHARS.put("'y", "\\u253y");
        RTFCHARS.put("th", "{\\uc2\\u254th}");
        RTFCHARS.put("\"y", "\\u255y");
        RTFCHARS.put("=A", "\\u256A");
        RTFCHARS.put("=a", "\\u257a");
        RTFCHARS.put("uA", "\\u258A");
        RTFCHARS.put("ua", "\\u259a");
        RTFCHARS.put("kA", "\\u260A");
        RTFCHARS.put("ka", "\\u261a");
        RTFCHARS.put("'C", "\\u262C");
        RTFCHARS.put("'c", "\\u263c");
        RTFCHARS.put("^C", "\\u264C");
        RTFCHARS.put("^c", "\\u265c");
        RTFCHARS.put(".C", "\\u266C");
        RTFCHARS.put(".c", "\\u267c");
        RTFCHARS.put("vC", "\\u268C");
        RTFCHARS.put("vc", "\\u269c");
        RTFCHARS.put("vD", "\\u270D");
        RTFCHARS.put("DJ", "\\u272D");
        RTFCHARS.put("dj", "\\u273d");
        RTFCHARS.put("=E", "\\u274E");
        RTFCHARS.put("=e", "\\u275e");
        RTFCHARS.put("uE", "\\u276E");
        RTFCHARS.put("ue", "\\u277e");
        RTFCHARS.put(".E", "\\u278E");
        RTFCHARS.put(".e", "\\u279e");
        RTFCHARS.put("kE", "\\u280E");
        RTFCHARS.put("ke", "\\u281e");
        RTFCHARS.put("vE", "\\u282E");
        RTFCHARS.put("ve", "\\u283e");
        RTFCHARS.put("^G", "\\u284G");
        RTFCHARS.put("^g", "\\u285g");
        RTFCHARS.put("uG", "\\u286G");
        RTFCHARS.put("ug", "\\u287g");
        RTFCHARS.put(".G", "\\u288G");
        RTFCHARS.put(".g", "\\u289g");
        RTFCHARS.put("cG", "\\u290G");
        RTFCHARS.put("'g", "\\u291g");
        RTFCHARS.put("^H", "\\u292H");
        RTFCHARS.put("^h", "\\u293h");
        RTFCHARS.put("Hstrok", "\\u294H");
        RTFCHARS.put("hstrok", "\\u295h");
        RTFCHARS.put("~I", "\\u296I");
        RTFCHARS.put("~i", "\\u297i");
        RTFCHARS.put("=I", "\\u298I");
        RTFCHARS.put("=i", "\\u299i");
        RTFCHARS.put("uI", "\\u300I");
        RTFCHARS.put("ui", "\\u301i");
        RTFCHARS.put("kI", "\\u302I");
        RTFCHARS.put("ki", "\\u303i");
        RTFCHARS.put(".I", "\\u304I");
        RTFCHARS.put("i", "\\u305i");
        RTFCHARS.put("^J", "\\u308J");
        RTFCHARS.put("^j", "\\u309j");
        RTFCHARS.put("cK", "\\u310K");
        RTFCHARS.put("ck", "\\u311k");
        RTFCHARS.put("'L", "\\u313L");
        RTFCHARS.put("'l", "\\u314l");
        RTFCHARS.put("cL", "\\u315L");
        RTFCHARS.put("cl", "\\u316l");
        RTFCHARS.put("Lmidot", "\\u319L");
        RTFCHARS.put("lmidot", "\\u320l");
        RTFCHARS.put("L", "\\u321L");
        RTFCHARS.put("l", "\\u322l");
        RTFCHARS.put("'N", "\\u323N");
        RTFCHARS.put("'n", "\\u324n");
        RTFCHARS.put("cN", "\\u325N");
        RTFCHARS.put("cn", "\\u326n");
        RTFCHARS.put("vN", "\\u327N");
        RTFCHARS.put("vn", "\\u328n");
        RTFCHARS.put("NG", "\\u330G");
        RTFCHARS.put("ng", "\\u331g");
        RTFCHARS.put("=O", "\\u332O");
        RTFCHARS.put("=o", "\\u333o");
        RTFCHARS.put("uO", "\\u334O");
        RTFCHARS.put("uo", "\\u335o");
        RTFCHARS.put("HO", "\\u336?");
        RTFCHARS.put("Ho", "\\u337?");
        RTFCHARS.put("OE", "{\\uc2\\u338OE}");
        RTFCHARS.put("oe", "{\\uc2\\u339oe}");
        RTFCHARS.put("'R", "\\u340R");
        RTFCHARS.put("'r", "\\u341r");
        RTFCHARS.put("cR", "\\u342R");
        RTFCHARS.put("cr", "\\u343r");
        RTFCHARS.put("vR", "\\u344R");
        RTFCHARS.put("vr", "\\u345r");
        RTFCHARS.put("'S", "\\u346S");
        RTFCHARS.put("'s", "\\u347s");
        RTFCHARS.put("^S", "\\u348S");
        RTFCHARS.put("^s", "\\u349s");
        RTFCHARS.put("cS", "\\u350S");
        RTFCHARS.put("cs", "\\u351s");
        RTFCHARS.put("vS", "\\u352S");
        RTFCHARS.put("vs", "\\u353s");
        RTFCHARS.put("cT", "\\u354T");
        RTFCHARS.put("ct", "\\u355t");
        RTFCHARS.put("vT", "\\u356T");
        RTFCHARS.put("Tstrok", "\\u358T");
        RTFCHARS.put("tstrok", "\\u359t");
        RTFCHARS.put("~U", "\\u360U");
        RTFCHARS.put("~u", "\\u361u");
        RTFCHARS.put("=U", "\\u362U");
        RTFCHARS.put("=u", "\\u363u");
        RTFCHARS.put("uU", "\\u364U");
        RTFCHARS.put("uu", "\\u365u");
        RTFCHARS.put("rU", "\\u366U");
        RTFCHARS.put("ru", "\\u367u");
        RTFCHARS.put("HU", "\\u368?");
        RTFCHARS.put("Hu", "\\u369?");
        RTFCHARS.put("kU", "\\u370U");
        RTFCHARS.put("ku", "\\u371u");
        RTFCHARS.put("^W", "\\u372W");
        RTFCHARS.put("^w", "\\u373w");
        RTFCHARS.put("^Y", "\\u374Y");
        RTFCHARS.put("^y", "\\u375y");
        RTFCHARS.put("\"Y", "\\u376Y");
        RTFCHARS.put("'Z", "\\u377Z");
        RTFCHARS.put("'z", "\\u378z");
        RTFCHARS.put(".Z", "\\u379Z");
        RTFCHARS.put(".z", "\\u380z");
        RTFCHARS.put("vZ", "\\u381Z");
        RTFCHARS.put("vz", "\\u382z");
    }

    private static class EncodingControl
    extends ResourceBundle.Control {
        private final String encoding;

        public EncodingControl(String string) {
            this.encoding = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            String string3 = this.toBundleName(string, locale);
            String string4 = this.toResourceName(string3, "properties");
            PropertyResourceBundle propertyResourceBundle = null;
            InputStream inputStream = null;
            if (bl) {
                URLConnection uRLConnection;
                URL uRL = classLoader.getResource(string4);
                if (uRL != null && (uRLConnection = uRL.openConnection()) != null) {
                    uRLConnection.setUseCaches(false);
                    inputStream = uRLConnection.getInputStream();
                }
            } else {
                inputStream = classLoader.getResourceAsStream(string4);
            }
            if (inputStream != null) {
                try {
                    propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(inputStream, this.encoding));
                }
                finally {
                    inputStream.close();
                }
            }
            return propertyResourceBundle;
        }
    }
}

