/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.specialfields.Printed;
import net.sf.jabref.specialfields.Priority;
import net.sf.jabref.specialfields.Quality;
import net.sf.jabref.specialfields.Rank;
import net.sf.jabref.specialfields.ReadStatus;
import net.sf.jabref.specialfields.Relevance;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.shortcut.EmacsKeyBindings;

public class GUIGlobals {
    public static final String frameTitle = "JabRef";
    public static final String stringsTitle = "Strings for database";
    public static final String untitledTitle = "untitled";
    public static String helpTitle = "JabRef help";
    public static final String TYPE_HEADER = "entrytype";
    public static final String NUMBER_COL = "#";
    public static final String encPrefix = "Encoding: ";
    public static Font CURRENTFONT;
    public static Font typeNameFont;
    public static Font jabRefFont;
    private static Font fieldNameFont;
    private static final Log LOGGER;
    public static final String SIGNATURE = "This file was created with JabRef";
    public static final Dimension helpSize;
    public static final Dimension aboutSize;
    public static final Dimension searchPaneSize;
    public static final Dimension searchFieldSize;
    public static Double zoomLevel;
    public static final int SPLIT_PANE_DIVIDER_SIZE = 4;
    public static final int SPLIT_PANE_DIVIDER_LOCATION = 160;
    public static final int TABLE_ROW_PADDING = 8;
    public static final int KEYBIND_COL_0 = 200;
    public static final int KEYBIND_COL_1 = 80;
    public static final int MAX_CONTENT_SELECTOR_WIDTH = 240;
    public static final String backupExt = ".bak";
    private static final String imageSize = "24";
    private static final String extension = ".gif";
    public static String ex;
    public static String pre;
    public static final String helpPre = "/help/";
    public static String fontPath;
    private static final HashMap<String, JLabel> tableIcons;
    public static final Color activeEditor;
    private static HashMap<String, String> iconMap;
    public static final String baseFrameHelp = "BaseFrameHelp.html";
    public static final String entryEditorHelp = "EntryEditorHelp.html";
    public static final String stringEditorHelp = "StringEditorHelp.html";
    public static final String helpContents = "Contents.html";
    public static final String searchHelp = "SearchHelp.html";
    public static final String groupsHelp = "GroupsHelp.html";
    public static final String customEntriesHelp = "CustomEntriesHelp.html";
    public static final String contentSelectorHelp = "ContentSelectorHelp.html";
    public static final String specialFieldsHelp = "SpecialFieldsHelp.html";
    public static final String labelPatternHelp = "LabelPatterns.html";
    public static final String ownerHelp = "OwnerHelp.html";
    public static final String timeStampHelp = "TimeStampHelp.html";
    public static final String pdfHelp = "ExternalFiles.html";
    public static final String exportCustomizationHelp = "CustomExports.html";
    public static final String importCustomizationHelp = "CustomImports.html";
    public static final String medlineHelp = "MedlineHelp.html";
    public static final String citeSeerHelp = "CiteSeerHelp.html";
    public static final String generalFieldsHelp = "GeneralFields.html";
    public static final String aboutPage = "About.html";
    public static final String shortPlainImport = "ShortPlainImport.html";
    public static final String importInspectionHelp = "ImportInspectionDialog.html";
    public static final String shortIntegrityCheck = "ShortIntegrityCheck.html";
    public static final String remoteHelp = "RemoteHelp.html";
    public static final String journalAbbrHelp = "JournalAbbreviations.html";
    public static final String regularExpressionSearchHelp = "ExternalFiles.html#RegularExpressionSearch";
    public static final String nameFormatterHelp = "CustomExports.html#NameFormatter";
    public static final String previewHelp = "PreviewHelp.html";
    public static final String pluginHelp = "Plugin.html";
    public static final String autosaveHelp = "Autosave.html";
    public static Color lightGray;
    public static final Color entryEditorLabelColor;
    public static final Color nullFieldColor;
    public static Color gradientGray;
    public static Color gradientBlue;
    public static final Color activeTabbed;
    public static final Color inActiveTabbed;
    public static final Color infoField;
    public static Color editorTextColor;
    public static Color validFieldBackgroundColor;
    public static Color activeBackground;
    public static Color invalidFieldBackgroundColor;
    public static final String META_FLAG = "jabref-meta: ";
    public static final String META_FLAG_OLD = "bibkeeper-meta: ";
    public static final String ENTRYTYPE_FLAG = "jabref-entrytype: ";
    public static final double DEFAULT_FIELD_WEIGHT = 1.0;
    public static final double MAX_FIELD_WEIGHT = 2.0;
    public static final int STANDARD_EDITOR = 1;
    public static final int FILE_LIST_EDITOR = 2;
    public static final int MAX_BACK_HISTORY_SIZE = 10;
    public static final String FILE_FIELD = "file";
    private static final String FOLDER_FIELD = "folder";
    public static final double SMALL_W = 0.3;
    public static final double MEDIUM_W = 0.5;
    public static final double LARGE_W = 1.5;
    public static final double PE_HEIGHT = 2.0;
    public static final int[] FORM_WIDTH;
    public static final int[] FORM_HEIGHT;
    public static final int INDENT = 4;
    public static final int LINE_LENGTH = 65;
    public static final int DEFAULT_FIELD_LENGTH = 100;
    public static final int NUMBER_COL_LENGTH = 32;
    public static final int WIDTH_ICON_COL_RANKING = 35;
    public static final int WIDTH_ICON_COL = 19;
    public static final int EXPORT_DIALOG_COL_0_WIDTH = 50;
    public static final int EXPORT_DIALOG_COL_1_WIDTH = 200;
    public static final int EXPORT_DIALOG_COL_2_WIDTH = 30;
    public static final int IMPORT_DIALOG_COL_0_WIDTH = 200;
    public static final int IMPORT_DIALOG_COL_1_WIDTH = 80;
    public static final int IMPORT_DIALOG_COL_2_WIDTH = 200;
    public static final int IMPORT_DIALOG_COL_3_WIDTH = 200;
    public static final Map<String, String> LANGUAGES;

    public static JLabel getTableIcon(String string) {
        JLabel jLabel = tableIcons.get(string);
        if (jLabel == null) {
            LOGGER.info("Error: no table icon defined for type '" + string + "'.");
            return null;
        }
        return jLabel;
    }

    public static void updateEntryEditorColors() {
        activeBackground = JabRefPreferences.getInstance().getColor("activeFieldEditorBackgroundColor");
        validFieldBackgroundColor = JabRefPreferences.getInstance().getColor("validFieldBackgroundColor");
        invalidFieldBackgroundColor = JabRefPreferences.getInstance().getColor("invalidFieldBackgroundColor");
        editorTextColor = JabRefPreferences.getInstance().getColor("fieldEditorTextColor");
    }

    public static void setUpIconTheme() {
        block7: {
            String string;
            URL uRL;
            String string2;
            String string3 = string2 = "/images/crystal_16/";
            URL uRL2 = uRL = GUIGlobals.class.getResource(string3 + "Icons.properties");
            if (Globals.prefs.getBoolean("useCustomIconTheme") && (string = Globals.prefs.get("customIconThemeFile")) != null) {
                try {
                    File file = new File(string);
                    String string4 = file.getParentFile().getAbsolutePath();
                    string3 = "file://" + string4 + System.getProperty("file.separator");
                    uRL2 = new URL("file://" + file.getAbsolutePath());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            try {
                iconMap = GUIGlobals.readIconThemeFile(uRL2, string3);
            }
            catch (IOException iOException) {
                System.err.println(Globals.lang("Unable to read icon theme file") + " '" + uRL2.toString() + '\'');
                if (uRL2 == uRL) break block7;
                try {
                    iconMap = GUIGlobals.readIconThemeFile(uRL, string2);
                }
                catch (IOException iOException2) {
                    System.err.println(Globals.lang("Unable to read default icon theme."));
                }
            }
        }
    }

    public static URL getIconUrl(String string) {
        if (iconMap.containsKey(string)) {
            String string2 = iconMap.get(string);
            URL uRL = GUIGlobals.class.getResource(string2);
            if (uRL == null) {
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL == null) {
                System.err.println(Globals.lang("Could not find image file") + " '" + string2 + '\'');
            }
            return uRL;
        }
        return null;
    }

    public static ImageIcon getImage(String string) {
        URL uRL = GUIGlobals.getIconUrl(string);
        return uRL != null ? new ImageIcon(GUIGlobals.getIconUrl(string)) : null;
    }

    public static Map<String, String> getAllIcons() {
        return Collections.unmodifiableMap(iconMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, String> readIconThemeFile(URL uRL, String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        InputStream inputStream = null;
        try {
            String[] stringArray;
            int n;
            inputStream = uRL.openStream();
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = inputStream.read()) != -1) {
                stringBuilder.append((char)n);
            }
            for (String string2 : stringArray = stringBuilder.toString().split("\n")) {
                String string3 = string2.trim();
                int n2 = string3.indexOf("=");
                if (n2 < 0) continue;
                String string4 = string3.substring(0, n2).trim();
                String string5 = string + string3.substring(n2 + 1).trim();
                hashMap.put(string4, string5);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return hashMap;
    }

    public static String getLocaleHelpPath() {
        JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        String string = jabRefPreferences.get("language") + '/';
        if (string.equals("en/")) {
            string = "";
        }
        return helpPre + string;
    }

    public static void init() {
        typeNameFont = new Font("dialog", 3, 18);
        fieldNameFont = new Font("arial", 3, 14);
        JLabel jLabel = new JLabel(GUIGlobals.getImage("pdfSmall"));
        jLabel.setToolTipText(Globals.lang("Open") + " PDF");
        tableIcons.put("pdf", jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("wwwSmall"));
        jLabel.setToolTipText(Globals.lang("Open") + " URL");
        tableIcons.put("url", jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("citeseer"));
        jLabel.setToolTipText(Globals.lang("Open") + " CiteSeer URL");
        tableIcons.put("citeseerurl", jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("arxiv"));
        jLabel.setToolTipText(Globals.lang("Open") + " ArXiv URL");
        tableIcons.put("eprint", jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("doiSmall"));
        jLabel.setToolTipText(Globals.lang("Open") + " DOI " + Globals.lang("web link"));
        tableIcons.put("doi", jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("psSmall"));
        jLabel.setToolTipText(Globals.lang("Open") + " PS");
        tableIcons.put("ps", jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("psSmall"));
        jLabel.setToolTipText(Globals.lang("Open folder"));
        tableIcons.put(FOLDER_FIELD, jLabel);
        jLabel = new JLabel(GUIGlobals.getImage("psSmall"));
        jLabel.setToolTipText(Globals.lang("Open file"));
        tableIcons.put(FILE_FIELD, jLabel);
        for (ExternalFileType externalFileType : Globals.prefs.getExternalFileTypeSelection()) {
            jLabel = new JLabel(externalFileType.getIcon());
            jLabel.setToolTipText(Globals.lang("Open " + externalFileType.getName() + " file"));
            tableIcons.put(externalFileType.getName(), jLabel);
        }
        jLabel = new JLabel(Relevance.getInstance().getRepresentingIcon());
        jLabel.setToolTipText(Relevance.getInstance().getToolTip());
        tableIcons.put("relevance", jLabel);
        jLabel = new JLabel(Quality.getInstance().getRepresentingIcon());
        jLabel.setToolTipText(Quality.getInstance().getToolTip());
        tableIcons.put("qualityassured", jLabel);
        jLabel = new JLabel(Rank.getInstance().getRepresentingIcon());
        jLabel.setToolTipText(Rank.getInstance().getToolTip());
        tableIcons.put("ranking", jLabel);
        jLabel = new JLabel(Priority.getInstance().getRepresentingIcon());
        jLabel.setToolTipText(Rank.getInstance().getToolTip());
        tableIcons.put("priority", jLabel);
        jLabel = new JLabel(ReadStatus.getInstance().getRepresentingIcon());
        jLabel.setToolTipText(ReadStatus.getInstance().getToolTip());
        tableIcons.put("readstatus", jLabel);
        jLabel = new JLabel(Printed.getInstance().getRepresentingIcon());
        jLabel.setToolTipText(Printed.getInstance().getToolTip());
        tableIcons.put("printed", jLabel);
        if (Globals.prefs.getBoolean("editorEMACSkeyBindings")) {
            EmacsKeyBindings.load();
        }
    }

    static {
        LOGGER = LogFactory.getLog(GUIGlobals.class);
        helpSize = new Dimension(700, 600);
        aboutSize = new Dimension(600, 265);
        searchPaneSize = new Dimension(430, 70);
        searchFieldSize = new Dimension(215, 25);
        zoomLevel = 1.0;
        ex = "24.gif";
        pre = "/images/";
        fontPath = "/images/font/";
        tableIcons = new HashMap();
        activeEditor = new Color(230, 230, 255);
        lightGray = new Color(230, 30, 30);
        entryEditorLabelColor = new Color(100, 100, 150);
        nullFieldColor = new Color(75, 130, 95);
        gradientGray = new Color(112, 121, 165);
        gradientBlue = new Color(0, 27, 102);
        activeTabbed = entryEditorLabelColor.darker();
        inActiveTabbed = Color.black;
        infoField = new Color(254, 255, 225);
        editorTextColor = null;
        validFieldBackgroundColor = null;
        activeBackground = null;
        invalidFieldBackgroundColor = null;
        FORM_WIDTH = new int[]{500, 650, 820};
        FORM_HEIGHT = new int[]{90, 110, 130};
        LANGUAGES = new TreeMap<String, String>();
        LANGUAGES.put("English", "en");
        LANGUAGES.put("Dansk", "da");
        LANGUAGES.put("Deutsch", "de");
        LANGUAGES.put("Fran\u00e7ais", "fr");
        LANGUAGES.put("Italiano", "it");
        LANGUAGES.put("Japanese", "ja");
        LANGUAGES.put("Nederlands", "nl");
        LANGUAGES.put("Norsk", "no");
        LANGUAGES.put("Espa\u00f1ol", "es");
        LANGUAGES.put("Turkish", "tr");
        LANGUAGES.put("Simplified Chinese", "zh");
        LANGUAGES.put("Vietnamese", "vi");
        LANGUAGES.put("Bahasa Indonesia", "in");
        LANGUAGES.put("Brazilian Portugese", "pt_BR");
        LANGUAGES.put("Russian", "ru");
        LANGUAGES.put("Persian (\u0641\u0627\u0631\u0633\u06cc)", "fa");
        GUIGlobals.updateEntryEditorColors();
    }
}

