/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.Globals;

public class FontSelectorDialog
extends JDialog {
    private static final long serialVersionUID = -8670346696048738055L;
    private static final String PLAIN = "plain";
    private static final String BOLD = "bold";
    private static final String BOLD_ITALIC = "bold-italic";
    private static final String ITALIC = "italic";
    private boolean isOK;
    private final JTextField familyField;
    private final JList familyList;
    private final JTextField sizeField;
    private final JList sizeList;
    private final JTextField styleField;
    private final JList styleList;
    private final JLabel preview;
    private final JButton ok;
    private final JButton cancel;
    private static final String[] HIDEFONTS = new String[]{".bold", ".italic"};

    public FontSelectorDialog(Component component, Font font) {
        super(JOptionPane.getFrameForComponent(component), Globals.lang("FontSelector"), true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 6, 6));
        this.familyField = new JTextField();
        this.familyList = new JList<String>(this.getFontList());
        JPanel jPanel3 = this.createTextFieldAndListPanel(Globals.lang("Font Family"), this.familyField, this.familyList);
        jPanel2.add(jPanel3);
        String[] stringArray = new String[]{"9", "10", "12", "14", "16", "18", "24"};
        this.sizeField = new JTextField();
        this.sizeList = new JList<String>(stringArray);
        JPanel jPanel4 = this.createTextFieldAndListPanel(Globals.lang("Font Size"), this.sizeField, this.sizeList);
        jPanel2.add(jPanel4);
        String[] stringArray2 = new String[]{PLAIN, BOLD, ITALIC, BOLD_ITALIC};
        this.styleField = new JTextField();
        this.styleList = new JList<String>(stringArray2);
        JPanel jPanel5 = this.createTextFieldAndListPanel(Globals.lang("Font Style"), this.styleField, this.styleList);
        this.styleField.setEditable(false);
        jPanel2.add(jPanel5);
        this.familyList.setSelectedValue(font.getFamily(), true);
        this.familyField.setText(font.getFamily());
        this.sizeList.setSelectedValue(String.valueOf(font.getSize()), true);
        this.sizeField.setText(String.valueOf(font.getSize()));
        this.styleList.setSelectedIndex(font.getStyle());
        this.styleField.setText((String)this.styleList.getSelectedValue());
        ListHandler listHandler = new ListHandler();
        this.familyList.addListSelectionListener(listHandler);
        this.sizeList.addListSelectionListener(listHandler);
        this.styleList.addListSelectionListener(listHandler);
        jPanel.add("North", jPanel2);
        this.preview = new JLabel(Globals.lang("Font Preview")){
            private static final long serialVersionUID = -4191591634265068189L;

            @Override
            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paint(graphics2D);
            }
        };
        this.preview.setBorder(new TitledBorder(Globals.lang("Font Preview")));
        this.updatePreview();
        Dimension dimension = this.preview.getPreferredSize();
        dimension.height = 50;
        this.preview.setPreferredSize(dimension);
        jPanel.add("Center", this.preview);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel6.add(Box.createGlue());
        this.ok = new JButton(Globals.lang("Ok"));
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        jPanel6.add(this.ok);
        jPanel6.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.cancel.addActionListener(new ActionHandler());
        jPanel6.add(this.cancel);
        jPanel6.add(Box.createGlue());
        jPanel.add("South", jPanel6);
        this.pack();
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(component));
        this.setVisible(true);
    }

    private void ok() {
        this.isOK = true;
        this.dispose();
    }

    private void cancel() {
        this.dispose();
    }

    public Font getSelectedFont() {
        int n;
        if (!this.isOK) {
            return null;
        }
        try {
            n = Integer.parseInt(this.sizeField.getText());
        }
        catch (Exception exception) {
            n = 14;
        }
        return new Font(this.familyField.getText(), this.styleList.getSelectedIndex(), n);
    }

    private String[] getFontList() {
        try {
            Class<?> clazz = Class.forName("java.awt.GraphicsEnvironment");
            Object object = clazz.getMethod("getLocalGraphicsEnvironment", new Class[0]).invoke(null, new Object[0]);
            String[] stringArray = (String[])clazz.getMethod("getAvailableFontFamilyNames", new Class[0]).invoke(object, new Object[0]);
            Vector<String> vector = new Vector<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                for (n = 0; n < HIDEFONTS.length && !stringArray[i].contains(HIDEFONTS[n]); ++n) {
                }
                if (n != HIDEFONTS.length) continue;
                vector.addElement(stringArray[i]);
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private JPanel createTextFieldAndListPanel(String string, JTextField jTextField, JList jList) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel(string);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = 1;
        Component component = Box.createVerticalStrut(6);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        jPanel.add(jTextField);
        gridBagConstraints.gridy = 3;
        component = Box.createVerticalStrut(6);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(jList);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private void updatePreview() {
        int n;
        String string = this.familyField.getText();
        try {
            n = Integer.parseInt(this.sizeField.getText());
        }
        catch (Exception exception) {
            n = 14;
        }
        int n2 = this.styleList.getSelectedIndex();
        this.preview.setFont(new Font(string, n2, n));
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string;
            Object object = listSelectionEvent.getSource();
            if (object == FontSelectorDialog.this.familyList) {
                String string2 = (String)FontSelectorDialog.this.familyList.getSelectedValue();
                if (string2 != null) {
                    FontSelectorDialog.this.familyField.setText(string2);
                }
            } else if (object == FontSelectorDialog.this.sizeList) {
                String string3 = (String)FontSelectorDialog.this.sizeList.getSelectedValue();
                if (string3 != null) {
                    FontSelectorDialog.this.sizeField.setText(string3);
                }
            } else if (object == FontSelectorDialog.this.styleList && (string = (String)FontSelectorDialog.this.styleList.getSelectedValue()) != null) {
                FontSelectorDialog.this.styleField.setText(string);
            }
            FontSelectorDialog.this.updatePreview();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FontSelectorDialog.this.ok) {
                FontSelectorDialog.this.ok();
            } else if (actionEvent.getSource() == FontSelectorDialog.this.cancel) {
                FontSelectorDialog.this.cancel();
            }
        }
    }
}

