/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.help.HelpAction;

public class FileTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences _prefs;
    private final JabRefFrame _frame;
    private final JCheckBox backup;
    private final JCheckBox openLast;
    private final JCheckBox autoDoubleBraces;
    private final JCheckBox autoSave;
    private final JCheckBox promptBeforeUsingAutoSave;
    private final JCheckBox includeEmptyFields;
    private final JCheckBox camelCase;
    private final JCheckBox sameColumn;
    private final JComboBox valueDelimiter;
    private final JComboBox newlineSeparator;
    private final JRadioButton resolveStringsStandard;
    private final JRadioButton resolveStringsAll;
    private final JTextField bracesAroundCapitalsFields;
    private final JTextField nonWrappableFields;
    private final JTextField doNotResolveStringsFor;
    private final JSpinner autoSaveInterval;
    private boolean origAutoSaveSetting = false;
    private final ButtonGroup bgFieldOrderStyle;
    private JTextField userDefinedFieldOrder;
    private final JCheckBox wrapFieldLine;

    public FileTab(JabRefFrame jabRefFrame, JabRefPreferences jabRefPreferences) {
        this._prefs = jabRefPreferences;
        this._frame = jabRefFrame;
        HelpAction helpAction = new HelpAction(jabRefFrame.helpDiag, "Autosave.html", "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.openLast = new JCheckBox(Globals.lang("Open last edited databases at startup"));
        this.backup = new JCheckBox(Globals.lang("Backup old file when saving"));
        this.autoSave = new JCheckBox(Globals.lang("autoSave"));
        this.promptBeforeUsingAutoSave = new JCheckBox(Globals.lang("Prompt before recovering a database from an autosave file"));
        this.autoSaveInterval = new JSpinner(new SpinnerNumberModel(1, 1, 60, 1));
        this.valueDelimiter = new JComboBox<String>(new String[]{Globals.lang("Quotes") + ": \", \"", Globals.lang("Curly Brackets") + ": {, }"});
        this.includeEmptyFields = new JCheckBox(Globals.lang("Include empty fields"));
        this.sameColumn = new JCheckBox(Globals.lang("Start field contents in same column"));
        this.camelCase = new JCheckBox(Globals.lang("Use camel case for field names (e.g., \"HowPublished\" instead of \"howpublished\")"));
        this.resolveStringsAll = new JRadioButton(Globals.lang("Resolve strings for all fields except") + ":");
        this.resolveStringsStandard = new JRadioButton(Globals.lang("Resolve strings for standard BibTeX fields only"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.resolveStringsAll);
        buttonGroup.add(this.resolveStringsStandard);
        this.userDefinedFieldOrder = new JTextField(this._prefs.get("writefieldUserdefinedOrder"));
        this.newlineSeparator = new JComboBox<String>(new String[]{"CR", "CR/LF", "LF"});
        this.bracesAroundCapitalsFields = new JTextField(25);
        this.nonWrappableFields = new JTextField(25);
        this.doNotResolveStringsFor = new JTextField(30);
        this.autoDoubleBraces = new JCheckBox(Globals.lang("Remove double braces around BibTeX fields when loading."));
        this.autoSave.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FileTab.this.autoSaveInterval.setEnabled(FileTab.this.autoSave.isSelected());
                FileTab.this.promptBeforeUsingAutoSave.setEnabled(FileTab.this.autoSave.isSelected());
            }
        });
        FormLayout formLayout = new FormLayout("left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(Globals.lang("General"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.openLast, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.backup, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.autoDoubleBraces, 3);
        defaultFormBuilder.nextLine();
        JLabel jLabel = new JLabel(Globals.lang("Store the following fields with braces around capital letters") + ":");
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.bracesAroundCapitalsFields);
        defaultFormBuilder.nextLine();
        jLabel = new JLabel(Globals.lang("Do not wrap the following fields when saving") + ":");
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.nonWrappableFields);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.resolveStringsStandard, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resolveStringsAll);
        defaultFormBuilder.append(this.doNotResolveStringsFor);
        defaultFormBuilder.nextLine();
        JLabel jLabel2 = new JLabel(Globals.lang("Newline separator") + ":");
        defaultFormBuilder.append(jLabel2);
        defaultFormBuilder.append(this.newlineSeparator);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Autosave"));
        defaultFormBuilder.append((Component)this.autoSave, 1);
        JButton jButton = new JButton(helpAction);
        jButton.setText(null);
        jButton.setPreferredSize(new Dimension(24, 24));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jButton, "East");
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Autosave interval (minutes)") + ":");
        defaultFormBuilder.append(this.autoSaveInterval);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.promptBeforeUsingAutoSave);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Field saving options"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.camelCase);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.sameColumn);
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.includeEmptyFields);
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.nextLine();
        this.wrapFieldLine = new JCheckBox(Globals.lang("Wrap fields as ver 2.9.2"));
        defaultFormBuilder.append(this.wrapFieldLine);
        defaultFormBuilder.nextLine();
        String[] stringArray = new String[]{"Save fields sorted in alphabetic order (as in versions 2.10+)", "Save fields in unsorted order (as until version 2.9.2)", "Save fields in user-defined order"};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(Globals.lang(string));
        }
        this.bgFieldOrderStyle = this.createRadioBg(arrayList);
        this.userDefinedFieldOrder = new JTextField(this._prefs.get("writefieldUserdefinedOrder"));
        this.createAdFieldOrderBg(defaultFormBuilder, this.bgFieldOrderStyle, this.userDefinedFieldOrder);
        JPanel jPanel2 = defaultFormBuilder.getPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel2, "Center");
    }

    private ButtonGroup createRadioBg(Iterable<String> iterable) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (String string : iterable) {
            JRadioButton jRadioButton = new JRadioButton(string);
            buttonGroup.add(jRadioButton);
        }
        return buttonGroup;
    }

    private int getBgValue(ButtonGroup buttonGroup) {
        int n = 0;
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().isSelected()) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private void setBgSelected(ButtonGroup buttonGroup, int n) {
        int n2 = 0;
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            if (n2 == n) {
                enumeration.nextElement().setSelected(true);
            } else {
                enumeration.nextElement().setSelected(false);
            }
            ++n2;
        }
    }

    private void createAdFieldOrderBg(DefaultFormBuilder defaultFormBuilder, ButtonGroup buttonGroup, JTextField jTextField) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            defaultFormBuilder.append(enumeration.nextElement());
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append(jTextField);
        defaultFormBuilder.nextLine();
    }

    @Override
    public void setValues() {
        this.openLast.setSelected(this._prefs.getBoolean("openLastEdited"));
        this.backup.setSelected(this._prefs.getBoolean("backup"));
        String string = this._prefs.get("newline");
        if ("\r".equals(string)) {
            this.newlineSeparator.setSelectedIndex(0);
        } else if ("\n".equals(string)) {
            this.newlineSeparator.setSelectedIndex(2);
        } else {
            this.newlineSeparator.setSelectedIndex(1);
        }
        this.wrapFieldLine.setSelected(this._prefs.getBoolean("wrapFieldLine"));
        this.autoDoubleBraces.setSelected(this._prefs.getBoolean("autoDoubleBraces"));
        this.resolveStringsAll.setSelected(this._prefs.getBoolean("resolveStringsAllFields"));
        this.resolveStringsStandard.setSelected(!this.resolveStringsAll.isSelected());
        this.doNotResolveStringsFor.setText(this._prefs.get("doNotResolveStringsFor"));
        this.bracesAroundCapitalsFields.setText(this._prefs.get("putBracesAroundCapitals"));
        this.nonWrappableFields.setText(this._prefs.get("nonWrappableFields"));
        this.autoSave.setSelected(this._prefs.getBoolean("autoSave"));
        this.promptBeforeUsingAutoSave.setSelected(this._prefs.getBoolean("promptBeforeUsingAutosave"));
        this.autoSaveInterval.setValue(this._prefs.getInt("autoSaveInterval"));
        this.origAutoSaveSetting = this.autoSave.isSelected();
        this.valueDelimiter.setSelectedIndex(this._prefs.getInt("valueDelimiters"));
        this.includeEmptyFields.setSelected(this._prefs.getBoolean("includeEmptyFields"));
        this.camelCase.setSelected(this._prefs.getBoolean("writeFieldCamelCase"));
        this.sameColumn.setSelected(this._prefs.getBoolean("writeFieldAddSpaces"));
        this.setBgSelected(this.bgFieldOrderStyle, this._prefs.getInt("writefieldSortStyle"));
        this.userDefinedFieldOrder.setText(this._prefs.get("writefieldUserdefinedOrder"));
    }

    @Override
    public void storeSettings() {
        String string;
        switch (this.newlineSeparator.getSelectedIndex()) {
            case 0: {
                string = "\r";
                break;
            }
            case 2: {
                string = "\n";
                break;
            }
            default: {
                string = "\r\n";
            }
        }
        this._prefs.put("newline", string);
        Globals.NEWLINE = string;
        Globals.NEWLINE_LENGTH = string.length();
        this._prefs.putBoolean("backup", this.backup.isSelected());
        this._prefs.putBoolean("openLastEdited", this.openLast.isSelected());
        this._prefs.putBoolean("autoDoubleBraces", this.autoDoubleBraces.isSelected());
        this._prefs.putBoolean("resolveStringsAllFields", this.resolveStringsAll.isSelected());
        this._prefs.put("doNotResolveStringsFor", this.doNotResolveStringsFor.getText().trim());
        this._prefs.putBoolean("autoSave", this.autoSave.isSelected());
        this._prefs.putBoolean("promptBeforeUsingAutosave", this.promptBeforeUsingAutoSave.isSelected());
        this._prefs.putInt("autoSaveInterval", (Integer)this.autoSaveInterval.getValue());
        this._prefs.putInt("valueDelimiters", this.valueDelimiter.getSelectedIndex());
        this._prefs.putBoolean("includeEmptyFields", this.includeEmptyFields.isSelected());
        this._prefs.putBoolean("writeFieldCamelCase", this.camelCase.isSelected());
        this._prefs.putBoolean("writeFieldAddSpaces", this.sameColumn.isSelected());
        this.doNotResolveStringsFor.setText(this._prefs.get("doNotResolveStringsFor"));
        this._prefs.putInt("writefieldSortStyle", this.getBgValue(this.bgFieldOrderStyle));
        this._prefs.put("writefieldUserdefinedOrder", this.userDefinedFieldOrder.getText().trim());
        this._prefs.putBoolean("wrapFieldLine", this.wrapFieldLine.isSelected());
        boolean bl = false;
        if (!this.bracesAroundCapitalsFields.getText().trim().equals(this._prefs.get("putBracesAroundCapitals"))) {
            this._prefs.put("putBracesAroundCapitals", this.bracesAroundCapitalsFields.getText());
            bl = true;
        }
        if (!this.nonWrappableFields.getText().trim().equals(this._prefs.get("nonWrappableFields"))) {
            this._prefs.put("nonWrappableFields", this.nonWrappableFields.getText());
            bl = true;
        }
        if (bl) {
            this._prefs.updateSpecialFieldHandling();
        }
        if (!this.origAutoSaveSetting && this.autoSave.isSelected()) {
            Globals.startAutoSaveManager(this._frame);
        } else if (this.origAutoSaveSetting && !this.autoSave.isSelected()) {
            Globals.stopAutoSaveManager();
        }
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("File");
    }
}

