/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.UndoableEditListener;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldNameLabel;
import net.sf.jabref.FieldTextMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JTextAreaWithHighlighting;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.util.StringUtil;

public class FieldTextArea
extends JTextAreaWithHighlighting
implements FieldEditor {
    Dimension PREFERRED_SIZE;
    private final JScrollPane sp;
    private final FieldNameLabel label;
    private String fieldName;
    static final Pattern bull = Pattern.compile("\\s*[-\\*]+.*");
    static final Pattern indent = Pattern.compile("\\s+.*");
    private AutoCompleteListener autoCompleteListener = null;

    public FieldTextArea(String string, String string2) {
        super(string2);
        this.updateFont();
        this.addFocusListener(Globals.focusListener);
        this.addFocusListener(new FieldEditorFocusListener());
        this.sp = new JScrollPane(this, 20, 31);
        this.sp.setMinimumSize(new Dimension(200, 1));
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.fieldName = string;
        this.label = new FieldNameLabel(' ' + StringUtil.nCase(this.fieldName) + ' ');
        this.setBackground(GUIGlobals.validFieldBackgroundColor);
        this.setForeground(GUIGlobals.editorTextColor);
        FieldTextMenu fieldTextMenu = new FieldTextMenu(this);
        this.addMouseListener(fieldTextMenu);
        this.label.addMouseListener(fieldTextMenu);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color color) {
        this.label.setForeground(color);
    }

    @Override
    public JComponent getPane() {
        return this.sp;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public void setActiveBackgroundColor() {
        this.setBackground(GUIGlobals.activeBackground);
    }

    @Override
    public void setValidBackgroundColor() {
        this.setBackground(GUIGlobals.validFieldBackgroundColor);
    }

    @Override
    public void setInvalidBackgroundColor() {
        this.setBackground(GUIGlobals.invalidFieldBackgroundColor);
    }

    @Override
    public void updateFontColor() {
        this.setForeground(GUIGlobals.editorTextColor);
    }

    @Override
    public void updateFont() {
        this.setFont(GUIGlobals.CURRENTFONT);
    }

    @Override
    public void paste(String string) {
        int n = this.getSelectionEnd() - this.getSelectionStart();
        if (n > 0) {
            this.replaceSelection(string);
        } else {
            int n2 = this.getCaretPosition();
            this.insert(string, n2);
        }
    }

    @Override
    public boolean hasUndoInformation() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean hasRedoInformation() {
        return false;
    }

    @Override
    public void redo() {
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.getDocument().addUndoableEditListener(undoableEditListener);
    }

    @Override
    public void setAutoCompleteListener(AutoCompleteListener autoCompleteListener) {
        this.autoCompleteListener = autoCompleteListener;
    }

    @Override
    public void clearAutoCompleteSuggestion() {
        if (this.autoCompleteListener != null) {
            this.autoCompleteListener.clearCurrentSuggestion(this);
        }
    }
}

