/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

public class EntryMarker {
    public static final int MARK_COLOR_LEVELS = 6;
    public static final int MAX_MARKING_LEVEL = 5;
    public static final int IMPORT_MARK_LEVEL = 6;
    private static final Pattern MARK_NUMBER_PATTERN = Pattern.compile(JabRefPreferences.getInstance().MARKING_WITH_NUMBER_PATTERN);

    public static void markEntry(BibtexEntry bibtexEntry, int n, boolean bl, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("__markedentry");
        String string2 = null;
        if (string != null) {
            String string3 = string.toString();
            int n2 = string3.indexOf(Globals.prefs.WRAPPED_USERNAME);
            if (n2 >= 0) {
                int n3 = 1;
                string2 = string3.substring(0, n2) + string3.substring(n2 + Globals.prefs.WRAPPED_USERNAME.length()) + Globals.prefs.WRAPPED_USERNAME.substring(0, Globals.prefs.WRAPPED_USERNAME.length() - 1) + ":" + (bl ? Math.min(5, n3 + n) : n) + "]";
            } else {
                Matcher matcher = MARK_NUMBER_PATTERN.matcher(string3);
                if (matcher.find()) {
                    try {
                        int n4 = Integer.parseInt(matcher.group(1));
                        string2 = string3.substring(0, matcher.start(1)) + (bl ? Math.min(5, n4 + n) : n) + string3.substring(matcher.end(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (string2 == null) {
            string2 = Globals.prefs.WRAPPED_USERNAME.substring(0, Globals.prefs.WRAPPED_USERNAME.length() - 1) + ":" + n + "]";
        }
        namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "__markedentry", bibtexEntry.getField("__markedentry"), string2));
        bibtexEntry.setField("__markedentry", string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unmarkEntry(BibtexEntry bibtexEntry, boolean bl, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("__markedentry");
        if (string == null) return;
        String string2 = string.toString();
        if (string2.equals("0")) {
            if (bl) return;
            EntryMarker.unmarkOldStyle(bibtexEntry, bibtexDatabase, namedCompound);
            return;
        }
        String string3 = null;
        int n = string2.indexOf(Globals.prefs.WRAPPED_USERNAME);
        if (n >= 0) {
            if (bl) return;
            string3 = string2.substring(0, n) + string2.substring(n + Globals.prefs.WRAPPED_USERNAME.length());
        } else {
            Matcher matcher = MARK_NUMBER_PATTERN.matcher(string2);
            if (matcher.find()) {
                try {
                    int n2 = Integer.parseInt(matcher.group(1));
                    if (bl && n2 != 6) return;
                    if (n2 > 1) {
                        string3 = string2.substring(0, matcher.start(1)) + string2.substring(matcher.end(1));
                    } else {
                        String string4 = Globals.prefs.WRAPPED_USERNAME.substring(0, Globals.prefs.WRAPPED_USERNAME.length() - 1) + ":1]";
                        n = string2.indexOf(string4);
                        if (n >= 0) {
                            string3 = string2.substring(0, n) + string2.substring(n + string4.length());
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "__markedentry", bibtexEntry.getField("__markedentry"), string3));
        bibtexEntry.setField("__markedentry", string3);
    }

    /*
     * WARNING - void declaration
     */
    private static void unmarkOldStyle(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        void var5_9;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (BibtexEntry object2 : bibtexDatabase.getEntries()) {
            String string = object2.getField("owner");
            if (string == null) continue;
            treeSet.add(string);
        }
        treeSet.remove(Globals.prefs.get("defaultOwner"));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : treeSet) {
            stringBuilder.append('[');
            stringBuilder.append(string.toString());
            stringBuilder.append(']');
        }
        String string = stringBuilder.toString();
        if (string.length() == 0) {
            Object var5_8 = null;
        }
        namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "__markedentry", bibtexEntry.getField("__markedentry"), (String)var5_9));
        bibtexEntry.setField("__markedentry", (String)var5_9);
    }

    public static int isMarked(BibtexEntry bibtexEntry) {
        String string = bibtexEntry.getField("__markedentry");
        if (string == null) {
            return 0;
        }
        String string2 = string;
        if (string2.equals("0")) {
            return 1;
        }
        int n = string2.indexOf(Globals.prefs.WRAPPED_USERNAME);
        if (n >= 0) {
            return 1;
        }
        Matcher matcher = MARK_NUMBER_PATTERN.matcher(string2);
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                return 1;
            }
        }
        return 0;
    }
}

