/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.EntryEditorTabFocusListener;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldTextArea;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SearchTextListener;
import net.sf.jabref.autocompleter.AutoCompleter;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.gui.FileListEditor;

class EntryEditorTab {
    private final JPanel panel = new JPanel();
    private final JScrollPane scrollPane = new JScrollPane(this.panel, 20, 31);
    private final String[] fields;
    private final EntryEditor parent;
    private final HashMap<String, FieldEditor> editors = new HashMap();
    private FieldEditor activeField = null;
    public FileListEditor fileListEditor = null;
    private BibtexEntry entry;
    private boolean updating = false;
    private final FocusListener fieldListener = new EntryEditorTabFocusListener(this);

    public EntryEditorTab(JabRefFrame jabRefFrame, BasePanel basePanel, List<String> list, EntryEditor entryEditor, boolean bl, boolean bl2, String string) {
        this.fields = list != null ? list.toArray(new String[list.size()]) : new String[0];
        this.parent = entryEditor;
        this.setupPanel(jabRefFrame, basePanel, bl, bl2, string);
        this.scrollPane.setFocusCycleRoot(true);
    }

    private void setupPanel(JabRefFrame jabRefFrame, BasePanel basePanel, boolean bl, boolean bl2, String string) {
        InputMap inputMap = this.panel.getInputMap(0);
        ActionMap actionMap = this.panel.getActionMap();
        inputMap.put(Globals.prefs.getKey("Entry editor, previous entry"), "prev");
        actionMap.put("prev", this.parent.prevEntryAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, next entry"), "next");
        actionMap.put("next", this.parent.nextEntryAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, store field"), "store");
        actionMap.put("store", this.parent.storeFieldAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, next panel"), "right");
        inputMap.put(Globals.prefs.getKey("Entry editor, next panel 2"), "right");
        actionMap.put("left", this.parent.switchLeftAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, previous panel"), "left");
        inputMap.put(Globals.prefs.getKey("Entry editor, previous panel 2"), "left");
        actionMap.put("right", this.parent.switchRightAction);
        inputMap.put(Globals.prefs.getKey("Help"), "help");
        actionMap.put("help", this.parent.helpAction);
        inputMap.put(Globals.prefs.getKey("Save database"), "save");
        actionMap.put("save", this.parent.saveDatabaseAction);
        inputMap.put(Globals.prefs.getKey("Next tab"), "nexttab");
        actionMap.put("nexttab", this.parent.frame.nextTab);
        inputMap.put(Globals.prefs.getKey("Previous tab"), "prevtab");
        actionMap.put("prevtab", this.parent.frame.prevTab);
        this.panel.setName(string);
        int n = bl2 ? 2 : 1;
        String string2 = bl2 ? "fill:pref, 1dlu, fill:10dlu:grow, 1dlu, fill:pref, 8dlu, fill:pref, 1dlu, fill:10dlu:grow, 1dlu, fill:pref" : "fill:pref, 1dlu, fill:pref:grow, 1dlu, fill:pref";
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = (int)Math.ceil((double)this.fields.length / (double)n);
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append("fill:pref:grow, ");
        }
        if (bl) {
            stringBuilder.append("4dlu, fill:pref");
        } else if (stringBuilder.length() >= 2) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        String string3 = stringBuilder.toString();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout(string2, string3), this.panel);
        for (int i = 0; i < this.fields.length; ++i) {
            int n3;
            JComponent jComponent;
            int n4 = BibtexFields.getEditorType(this.fields[i]);
            int n5 = (int)(50.0 * BibtexFields.getFieldWeight(this.fields[i]));
            if (n4 == 2) {
                jComponent = new FileListEditor(jabRefFrame, basePanel.metaData(), this.fields[i], null, this.parent);
                this.fileListEditor = (FileListEditor)jComponent;
                n3 = 0;
            } else {
                jComponent = new FieldTextArea(this.fields[i], null);
                jabRefFrame.getSearchManager().addSearchListener((SearchTextListener)((Object)jComponent));
                n3 = jComponent.getPane().getPreferredSize().height;
            }
            JComponent jComponent2 = this.parent.getExtra(this.fields[i], (FieldEditor)((Object)jComponent));
            AutoCompleter autoCompleter = basePanel.getAutoCompleters().get(this.fields[i]);
            AutoCompleteListener autoCompleteListener = null;
            if (autoCompleter != null) {
                autoCompleteListener = new AutoCompleteListener(autoCompleter);
            }
            this.setupJTextComponent(jComponent.getTextComponent(), autoCompleteListener);
            jComponent.setAutoCompleteListener(autoCompleteListener);
            this.editors.put(this.fields[i], (FieldEditor)((Object)jComponent));
            if (i == 0) {
                this.activeField = jComponent;
            }
            if (!bl2) {
                jComponent.getPane().setPreferredSize(new Dimension(100, Math.max(n3, n5)));
            }
            defaultFormBuilder.append(jComponent.getLabel());
            if (jComponent2 == null) {
                defaultFormBuilder.append((Component)jComponent.getPane(), 3);
            } else {
                defaultFormBuilder.append(jComponent.getPane());
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)jComponent2, "North");
                defaultFormBuilder.append(jPanel);
            }
            if ((i + 1) % n != 0) continue;
            defaultFormBuilder.nextLine();
        }
        if (bl) {
            FieldTextField fieldTextField = new FieldTextField("bibtexkey", this.parent.getEntry().getField("bibtexkey"), true);
            this.setupJTextComponent(fieldTextField, null);
            this.editors.put("bibtexkey", fieldTextField);
            if (this.editors.size() == 1) {
                this.activeField = fieldTextField;
            }
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(fieldTextField.getLabel());
            defaultFormBuilder.append((Component)fieldTextField, 3);
        }
    }

    private BibtexEntry getEntry() {
        return this.entry;
    }

    private boolean isFieldModified(FieldEditor fieldEditor) {
        String string = fieldEditor.getText().trim();
        if (string.isEmpty()) {
            return this.getEntry().getField(fieldEditor.getFieldName()) != null;
        }
        String string2 = this.getEntry().getField(fieldEditor.getFieldName());
        return string2 == null || !string2.toString().equals(string);
    }

    public void markIfModified(FieldEditor fieldEditor) {
        if (!this.updating && !this.parent.panel.isBaseChanged() && this.isFieldModified(fieldEditor)) {
            this.markBaseChanged();
        }
    }

    private void markBaseChanged() {
        this.parent.panel.markBaseChanged();
    }

    public void setActive(FieldEditor fieldEditor) {
        this.activeField = fieldEditor;
    }

    public FieldEditor getActive() {
        return this.activeField;
    }

    public List<String> getFields() {
        return Arrays.asList(this.fields);
    }

    public void activate() {
        if (this.activeField != null) {
            new FocusRequester(this.activeField.getTextComponent());
        }
    }

    public void updateAll() {
        this.setEntry(this.getEntry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(BibtexEntry bibtexEntry) {
        try {
            this.updating = true;
            for (FieldEditor fieldEditor : this.editors.values()) {
                String string = bibtexEntry.getField(fieldEditor.getFieldName());
                String string2 = string == null ? "" : string.toString();
                if (string2.equals(fieldEditor.getText())) continue;
                fieldEditor.setText(string2);
            }
            this.entry = bibtexEntry;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean updateField(String string, String string2) {
        if (!this.editors.containsKey(string)) {
            return false;
        }
        FieldEditor fieldEditor = this.editors.get(string);
        fieldEditor.setText(string2);
        return true;
    }

    public void validateAllFields() {
        for (Map.Entry<String, FieldEditor> entry : this.editors.entrySet()) {
            FieldEditor fieldEditor = entry.getValue();
            fieldEditor.updateFontColor();
            fieldEditor.setEnabled(true);
            if (((Component)((Object)fieldEditor)).hasFocus()) {
                fieldEditor.setActiveBackgroundColor();
                continue;
            }
            fieldEditor.setValidBackgroundColor();
        }
    }

    public void setEnabled(boolean bl) {
        for (FieldEditor fieldEditor : this.editors.values()) {
            fieldEditor.setEnabled(bl);
        }
    }

    public Component getPane() {
        return this.scrollPane;
    }

    public EntryEditor getParent() {
        return this.parent;
    }

    private void setupJTextComponent(JComponent jComponent, AutoCompleteListener autoCompleteListener) {
        if (autoCompleteListener != null) {
            jComponent.addKeyListener(autoCompleteListener);
            jComponent.addFocusListener(autoCompleteListener);
            autoCompleteListener.setNextFocusListener(this.fieldListener);
        } else {
            jComponent.addFocusListener(this.fieldListener);
        }
        InputMap inputMap = jComponent.getInputMap(0);
        ActionMap actionMap = jComponent.getActionMap();
        inputMap.put(Globals.prefs.getKey("Entry editor, previous entry"), "prev");
        actionMap.put("prev", this.parent.prevEntryAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, next entry"), "next");
        actionMap.put("next", this.parent.nextEntryAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, store field"), "store");
        actionMap.put("store", this.parent.storeFieldAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, next panel"), "right");
        inputMap.put(Globals.prefs.getKey("Entry editor, next panel 2"), "right");
        actionMap.put("left", this.parent.switchLeftAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, previous panel"), "left");
        inputMap.put(Globals.prefs.getKey("Entry editor, previous panel 2"), "left");
        actionMap.put("right", this.parent.switchRightAction);
        inputMap.put(Globals.prefs.getKey("Help"), "help");
        actionMap.put("help", this.parent.helpAction);
        inputMap.put(Globals.prefs.getKey("Save database"), "save");
        actionMap.put("save", this.parent.saveDatabaseAction);
        inputMap.put(Globals.prefs.getKey("Next tab"), "nexttab");
        actionMap.put("nexttab", this.parent.frame.nextTab);
        inputMap.put(Globals.prefs.getKey("Previous tab"), "prevtab");
        actionMap.put("prevtab", this.parent.frame.prevTab);
        try {
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(jComponent.getFocusTraversalKeys(0));
            hashSet.clear();
            hashSet.add(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
            jComponent.setFocusTraversalKeys(0, hashSet);
            hashSet = new HashSet<AWTKeyStroke>(jComponent.getFocusTraversalKeys(1));
            hashSet.clear();
            hashSet.add(KeyStroke.getKeyStroke("shift pressed TAB"));
            jComponent.setFocusTraversalKeys(1, hashSet);
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
    }
}

