/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.autocompleter.AutoCompleterFactory;
import org.xnap.commons.gui.shortcut.EmacsKeyBindings;

public class EntryEditorPrefsTab
extends JPanel
implements PrefsTab {
    private final JCheckBox autoOpenForm;
    private final JCheckBox showSource;
    private final JCheckBox defSource;
    private final JCheckBox emacsMode;
    private final JCheckBox emacsRebindCtrlA;
    private final JCheckBox emacsRebindCtrlF;
    private final JCheckBox disableOnMultiple;
    private final JCheckBox autoComplete;
    private final JRadioButton autoCompBoth;
    private final JRadioButton autoCompFF;
    private final JRadioButton autoCompLF;
    private final JRadioButton autoCompFirstNameMode_Full;
    private final JRadioButton autoCompFirstNameMode_Abbr;
    private final JRadioButton autoCompFirstNameMode_Both;
    private boolean oldAutoCompFF;
    private boolean oldAutoCompLF;
    private boolean oldAutoCompFModeAbbr;
    private boolean oldAutoCompFModeFull;
    private final JSpinner shortestToComplete;
    private final JTextField autoCompFields;
    private final JabRefPreferences _prefs;
    private final JabRefFrame _frame;

    private void setAutoCompleteElementsEnabled(boolean bl) {
        this.autoCompFields.setEnabled(bl);
        this.autoCompLF.setEnabled(bl);
        this.autoCompFF.setEnabled(bl);
        this.autoCompBoth.setEnabled(bl);
        this.autoCompFirstNameMode_Abbr.setEnabled(bl);
        this.autoCompFirstNameMode_Full.setEnabled(bl);
        this.autoCompFirstNameMode_Both.setEnabled(bl);
        this.shortestToComplete.setEnabled(bl);
    }

    public EntryEditorPrefsTab(JabRefFrame jabRefFrame, JabRefPreferences jabRefPreferences) {
        this._prefs = jabRefPreferences;
        this._frame = jabRefFrame;
        this.setLayout(new BorderLayout());
        this.autoOpenForm = new JCheckBox(Globals.lang("Open editor when a new entry is created"));
        this.defSource = new JCheckBox(Globals.lang("Show BibTeX source by default"));
        this.showSource = new JCheckBox(Globals.lang("Show BibTeX source panel"));
        this.emacsMode = new JCheckBox(Globals.lang("Use Emacs key bindings"));
        this.emacsRebindCtrlA = new JCheckBox(Globals.lang("Rebind C-a, too"));
        this.emacsRebindCtrlF = new JCheckBox(Globals.lang("Rebind C-f, too"));
        this.disableOnMultiple = new JCheckBox(Globals.lang("Disable entry editor when multiple entries are selected"));
        this.autoComplete = new JCheckBox(Globals.lang("Enable word/name autocompletion"));
        this.shortestToComplete = new JSpinner(new SpinnerNumberModel(jabRefPreferences.getInt("shortestToComplete"), 1, 5, 1));
        this.autoCompFF = new JRadioButton(Globals.lang("Autocomplete names in 'Firstname Lastname' format only"));
        this.autoCompLF = new JRadioButton(Globals.lang("Autocomplete names in 'Lastname, Firstname' format only"));
        this.autoCompBoth = new JRadioButton(Globals.lang("Autocomplete names in both formats"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.autoCompLF);
        buttonGroup.add(this.autoCompFF);
        buttonGroup.add(this.autoCompBoth);
        this.autoCompFirstNameMode_Full = new JRadioButton(Globals.lang("Use full firstname whenever possible"));
        this.autoCompFirstNameMode_Abbr = new JRadioButton(Globals.lang("Use abbreviated firstname whenever possible"));
        this.autoCompFirstNameMode_Both = new JRadioButton(Globals.lang("Use abbreviated and full firstname"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.autoCompFirstNameMode_Full);
        buttonGroup2.add(this.autoCompFirstNameMode_Abbr);
        buttonGroup2.add(this.autoCompFirstNameMode_Both);
        Insets insets = new Insets(0, 20, 3, 0);
        this.defSource.setMargin(insets);
        this.showSource.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                EntryEditorPrefsTab.this.defSource.setEnabled(EntryEditorPrefsTab.this.showSource.isSelected());
            }
        });
        this.emacsRebindCtrlA.setMargin(insets);
        this.emacsMode.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                EntryEditorPrefsTab.this.emacsRebindCtrlA.setEnabled(EntryEditorPrefsTab.this.emacsMode.isSelected());
            }
        });
        this.emacsRebindCtrlF.setMargin(insets);
        this.emacsMode.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                EntryEditorPrefsTab.this.emacsRebindCtrlF.setEnabled(EntryEditorPrefsTab.this.emacsMode.isSelected());
            }
        });
        this.autoCompFields = new JTextField(40);
        this.autoComplete.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                EntryEditorPrefsTab.this.setAutoCompleteElementsEnabled(EntryEditorPrefsTab.this.autoComplete.isSelected());
            }
        });
        FormLayout formLayout = new FormLayout("8dlu, left:pref, 8dlu, fill:150dlu, 4dlu, fill:pref", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, pref, pref, pref, 6dlu, pref, pref, pref, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.addSeparator(Globals.lang("Editor options"), cellConstraints.xyw(1, 1, 5));
        defaultFormBuilder.add((Component)this.autoOpenForm, cellConstraints.xy(2, 3));
        defaultFormBuilder.add((Component)this.disableOnMultiple, cellConstraints.xy(2, 5));
        defaultFormBuilder.add((Component)this.showSource, cellConstraints.xy(2, 7));
        defaultFormBuilder.add((Component)this.defSource, cellConstraints.xy(2, 9));
        defaultFormBuilder.add((Component)this.emacsMode, cellConstraints.xy(2, 11));
        defaultFormBuilder.add((Component)this.emacsRebindCtrlA, cellConstraints.xy(2, 13));
        defaultFormBuilder.add((Component)this.emacsRebindCtrlF, cellConstraints.xy(2, 15));
        defaultFormBuilder.addSeparator(Globals.lang("Autocompletion options"), cellConstraints.xyw(1, 17, 5));
        defaultFormBuilder.add((Component)this.autoComplete, cellConstraints.xy(2, 19));
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:150dlu", ""));
        JLabel jLabel = new JLabel(Globals.lang("Use autocompletion for the following fields") + ":");
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.autoCompFields);
        JLabel jLabel2 = new JLabel(Globals.lang("Autocomplete after following number of characters") + ":");
        defaultFormBuilder2.append(jLabel2);
        defaultFormBuilder2.append(this.shortestToComplete);
        defaultFormBuilder.add((Component)defaultFormBuilder2.getPanel(), cellConstraints.xyw(2, 21, 3));
        defaultFormBuilder.addSeparator(Globals.lang("Name format used for autocompletion"), cellConstraints.xyw(2, 23, 4));
        defaultFormBuilder.add((Component)this.autoCompFF, cellConstraints.xy(2, 24));
        defaultFormBuilder.add((Component)this.autoCompLF, cellConstraints.xy(2, 25));
        defaultFormBuilder.add((Component)this.autoCompBoth, cellConstraints.xy(2, 26));
        defaultFormBuilder.addSeparator(Globals.lang("Treatment of first names"), cellConstraints.xyw(2, 28, 4));
        defaultFormBuilder.add((Component)this.autoCompFirstNameMode_Abbr, cellConstraints.xy(2, 29));
        defaultFormBuilder.add((Component)this.autoCompFirstNameMode_Full, cellConstraints.xy(2, 30));
        defaultFormBuilder.add((Component)this.autoCompFirstNameMode_Both, cellConstraints.xy(2, 31));
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setValues() {
        this.autoOpenForm.setSelected(this._prefs.getBoolean("autoOpenForm"));
        this.defSource.setSelected(this._prefs.getBoolean("defaultShowSource"));
        this.showSource.setSelected(this._prefs.getBoolean("showSource"));
        this.emacsMode.setSelected(this._prefs.getBoolean("editorEMACSkeyBindings"));
        this.emacsRebindCtrlA.setSelected(this._prefs.getBoolean("editorEMACSkeyBindingsRebindCA"));
        this.emacsRebindCtrlF.setSelected(this._prefs.getBoolean("editorEMACSkeyBindingsRebindCF"));
        this.disableOnMultiple.setSelected(this._prefs.getBoolean("disableOnMultipleSelection"));
        this.autoComplete.setSelected(this._prefs.getBoolean("autoComplete"));
        this.autoCompFields.setText(this._prefs.get("autoCompleteFields"));
        this.shortestToComplete.setValue(this._prefs.getInt("shortestToComplete"));
        if (this._prefs.getBoolean("autoCompFF")) {
            this.autoCompFF.setSelected(true);
        } else if (this._prefs.getBoolean("autoCompLF")) {
            this.autoCompLF.setSelected(true);
        } else {
            this.autoCompBoth.setSelected(true);
        }
        this.oldAutoCompFF = this.autoCompFF.isSelected();
        this.oldAutoCompLF = this.autoCompLF.isSelected();
        if (this._prefs.get("autoCompFirstNameMode").equals("abbrOnly")) {
            this.autoCompFirstNameMode_Abbr.setSelected(true);
        } else if (this._prefs.get("autoCompFirstNameMode").equals("fullOnly")) {
            this.autoCompFirstNameMode_Full.setSelected(true);
        } else {
            this.autoCompFirstNameMode_Both.setSelected(true);
        }
        this.oldAutoCompFModeAbbr = this.autoCompFirstNameMode_Abbr.isSelected();
        this.oldAutoCompFModeFull = this.autoCompFirstNameMode_Full.isSelected();
        this.defSource.setEnabled(this.showSource.isSelected());
        this.emacsRebindCtrlA.setEnabled(this.emacsMode.isSelected());
        this.setAutoCompleteElementsEnabled(this.autoComplete.isSelected());
    }

    @Override
    public void storeSettings() {
        boolean bl;
        this._prefs.putBoolean("autoOpenForm", this.autoOpenForm.isSelected());
        this._prefs.putBoolean("defaultShowSource", this.defSource.isSelected());
        boolean bl2 = this._prefs.getBoolean("editorEMACSkeyBindings") != this.emacsMode.isSelected();
        boolean bl3 = this._prefs.getBoolean("editorEMACSkeyBindingsRebindCA") != this.emacsRebindCtrlA.isSelected();
        boolean bl4 = bl = this._prefs.getBoolean("editorEMACSkeyBindingsRebindCF") != this.emacsRebindCtrlF.isSelected();
        if (bl2 || bl3 || bl) {
            this._prefs.putBoolean("editorEMACSkeyBindings", this.emacsMode.isSelected());
            this._prefs.putBoolean("editorEMACSkeyBindingsRebindCA", this.emacsRebindCtrlA.isSelected());
            this._prefs.putBoolean("editorEMACSkeyBindingsRebindCF", this.emacsRebindCtrlF.isSelected());
            if (bl2) {
                if (this.emacsMode.isSelected()) {
                    EmacsKeyBindings.load();
                } else {
                    EmacsKeyBindings.unload();
                }
            } else {
                assert (this.emacsMode.isSelected());
                EmacsKeyBindings.unload();
                EmacsKeyBindings.load();
            }
        }
        this._prefs.putBoolean("disableOnMultipleSelection", this.disableOnMultiple.isSelected());
        boolean bl5 = this._prefs.getBoolean("autoComplete");
        boolean bl6 = this._prefs.getBoolean("showSource");
        String string = this._prefs.get("autoCompleteFields");
        this._prefs.putInt("shortestToComplete", (Integer)this.shortestToComplete.getValue());
        this._prefs.putBoolean("autoComplete", this.autoComplete.isSelected());
        this._prefs.put("autoCompleteFields", this.autoCompFields.getText());
        this._prefs.putBoolean("showSource", this.showSource.isSelected());
        if (this.autoCompBoth.isSelected()) {
            this._prefs.putBoolean("autoCompFF", false);
            this._prefs.putBoolean("autoCompLF", false);
        } else if (this.autoCompFF.isSelected()) {
            this._prefs.putBoolean("autoCompFF", true);
            this._prefs.putBoolean("autoCompLF", false);
        } else {
            this._prefs.putBoolean("autoCompFF", false);
            this._prefs.putBoolean("autoCompLF", true);
        }
        if (this.autoCompFirstNameMode_Abbr.isSelected()) {
            this._prefs.put("autoCompFirstNameMode", "abbrOnly");
        } else if (this.autoCompFirstNameMode_Full.isSelected()) {
            this._prefs.put("autoCompFirstNameMode", "fullOnly");
        } else {
            this._prefs.put("autoCompFirstNameMode", "both");
        }
        if (bl6 != this.showSource.isSelected() || bl5 != this.autoComplete.isSelected() || !string.equals(this.autoCompFields.getText()) || this.oldAutoCompFF != this.autoCompFF.isSelected() || this.oldAutoCompLF != this.autoCompLF.isSelected() || this.oldAutoCompFModeAbbr != this.autoCompFirstNameMode_Abbr.isSelected() || this.oldAutoCompFModeFull != this.autoCompFirstNameMode_Full.isSelected()) {
            for (int i = 0; i < this._frame.getTabbedPane().getTabCount(); ++i) {
                BasePanel basePanel = (BasePanel)this._frame.getTabbedPane().getComponentAt(i);
                basePanel.entryEditors.clear();
            }
        }
        AutoCompleterFactory.SHORTEST_TO_COMPLETE = (Integer)this.shortestToComplete.getValue();
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Entry editor");
    }
}

