/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.TitleLabel;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.util.Util;

public class DuplicateResolverDialog
extends JDialog {
    private static final int NOT_CHOSEN = -1;
    public static final int KEEP_BOTH = 0;
    public static final int KEEP_UPPER = 1;
    public static final int KEEP_LOWER = 2;
    public static final int AUTOREMOVE_EXACT = 3;
    public static final int BREAK = 5;
    public static final int IMPORT_AND_DELETE_OLD = 1;
    public static final int IMPORT_AND_KEEP_OLD = 0;
    public static final int DO_NOT_IMPORT = 2;
    public static final int DUPLICATE_SEARCH = 1;
    public static final int IMPORT_CHECK = 2;
    public static final int INSPECTION = 3;
    public static final int DUPLICATE_SEARCH_WITH_EXACT = 4;
    private final Dimension DIM = new Dimension(650, 600);
    private PreviewPanel p1;
    private PreviewPanel p2;
    private JTextArea ta1;
    private JTextArea ta2;
    private final JTabbedPane tabbed = new JTabbedPane();
    private final GridBagLayout gbl = new GridBagLayout();
    private final GridBagConstraints con = new GridBagConstraints();
    private final JButton cancel = new JButton(Globals.lang("Cancel"));
    private JButton removeExact = null;
    private final JPanel options = new JPanel();
    private final JPanel main = new JPanel();
    private final JPanel source = new JPanel();
    private int status = -1;
    private boolean block = true;

    public DuplicateResolverDialog(JFrame jFrame, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2, int n) {
        super(jFrame, Globals.lang("Possible duplicate entries"), true);
        this.init(bibtexEntry, bibtexEntry2, n);
        Util.placeDialog(this, jFrame);
    }

    public DuplicateResolverDialog(JDialog jDialog, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2, int n) {
        super(jDialog, Globals.lang("Possible duplicate entries"), true);
        this.init(bibtexEntry, bibtexEntry2, n);
        Util.placeDialog(this, jDialog);
    }

    private void init(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2, int n) {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        switch (n) {
            case 1: {
                jButton3 = new JButton(Globals.lang("Keep upper"));
                jButton2 = new JButton(Globals.lang("Keep lower"));
                jButton = new JButton(Globals.lang("Keep both"));
                break;
            }
            case 3: {
                jButton3 = new JButton(Globals.lang("Remove old entry"));
                jButton2 = new JButton(Globals.lang("Remove entry from import"));
                jButton = new JButton(Globals.lang("Keep both"));
                break;
            }
            case 4: {
                jButton3 = new JButton(Globals.lang("Keep upper"));
                jButton2 = new JButton(Globals.lang("Keep lower"));
                jButton = new JButton(Globals.lang("Keep both"));
                this.removeExact = new JButton(Globals.lang("Automatically remove exact duplicates"));
                break;
            }
            default: {
                jButton3 = new JButton(Globals.lang("Import and remove old entry"));
                jButton2 = new JButton(Globals.lang("Do not import entry"));
                jButton = new JButton(Globals.lang("Import and keep old entry"));
            }
        }
        String string = Globals.prefs.get("preview0");
        this.p1 = new PreviewPanel(null, bibtexEntry, null, new MetaData(), string);
        this.p2 = new PreviewPanel(null, bibtexEntry2, null, new MetaData(), string);
        this.ta1 = new JTextArea();
        this.ta2 = new JTextArea();
        this.ta1.setEditable(false);
        this.ta2.setEditable(false);
        this.setSourceView(bibtexEntry, bibtexEntry2);
        this.main.setLayout(this.gbl);
        this.source.setLayout(this.gbl);
        this.con.insets = new Insets(10, 10, 0, 10);
        this.con.fill = 1;
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        TitleLabel titleLabel = new TitleLabel(n == 1 ? "" : Globals.lang("Entry in current database"));
        this.gbl.setConstraints(titleLabel, this.con);
        this.main.add(titleLabel);
        this.con.weighty = 1.0;
        this.con.insets = new Insets(5, 10, 10, 10);
        JScrollPane jScrollPane = new JScrollPane(this.p1);
        this.gbl.setConstraints(jScrollPane, this.con);
        this.main.add(jScrollPane);
        this.con.weighty = 0.0;
        this.con.insets = new Insets(10, 10, 0, 10);
        titleLabel = new TitleLabel(n == 1 ? "" : Globals.lang("Entry in import"));
        this.gbl.setConstraints(titleLabel, this.con);
        this.main.add(titleLabel);
        this.con.weighty = 1.0;
        this.con.insets = new Insets(5, 10, 10, 10);
        jScrollPane = new JScrollPane(this.ta1);
        this.gbl.setConstraints(jScrollPane, this.con);
        this.source.add(jScrollPane);
        jScrollPane = new JScrollPane(this.p2);
        this.gbl.setConstraints(jScrollPane, this.con);
        this.main.add(jScrollPane);
        jScrollPane = new JScrollPane(this.ta2);
        this.gbl.setConstraints(jScrollPane, this.con);
        this.source.add(jScrollPane);
        this.tabbed.add(Globals.lang("Short form"), this.main);
        this.tabbed.add(Globals.lang("Complete record"), this.source);
        if (this.removeExact != null) {
            this.options.add(this.removeExact);
        }
        this.options.add(jButton3);
        this.options.add(jButton2);
        this.options.add(jButton);
        if (n != 2) {
            this.options.add(Box.createHorizontalStrut(5));
            this.options.add(this.cancel);
        }
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DuplicateResolverDialog.this.status = 1;
                DuplicateResolverDialog.this.block = false;
                DuplicateResolverDialog.this.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DuplicateResolverDialog.this.status = 2;
                DuplicateResolverDialog.this.block = false;
                DuplicateResolverDialog.this.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DuplicateResolverDialog.this.status = 0;
                DuplicateResolverDialog.this.block = false;
                DuplicateResolverDialog.this.dispose();
            }
        });
        if (this.removeExact != null) {
            this.removeExact.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DuplicateResolverDialog.this.status = 3;
                    DuplicateResolverDialog.this.block = false;
                    DuplicateResolverDialog.this.dispose();
                }
            });
        }
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DuplicateResolverDialog.this.status = 5;
                DuplicateResolverDialog.this.block = false;
                DuplicateResolverDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.tabbed, "Center");
        this.getContentPane().add((Component)this.options, "South");
        this.pack();
        if (this.getHeight() > this.DIM.height) {
            this.setSize(new Dimension(this.getWidth(), this.DIM.height));
        }
        if (this.getWidth() > this.DIM.width) {
            this.setSize(new Dimension(this.DIM.width, this.getHeight()));
        }
        jButton.requestFocus();
    }

    private void setSourceView(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        try {
            StringWriter stringWriter = new StringWriter();
            bibtexEntry.write(stringWriter, new LatexFieldFormatter(), false);
            this.ta1.setText(stringWriter.getBuffer().toString());
            stringWriter = new StringWriter();
            bibtexEntry2.write(stringWriter, new LatexFieldFormatter(), false);
            this.ta2.setText(stringWriter.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setEntries(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        this.setSourceView(bibtexEntry, bibtexEntry2);
        this.p1.setEntry(bibtexEntry);
        this.p2.setEntry(bibtexEntry2);
        this.status = -1;
        this.p1.revalidate();
        this.p1.repaint();
        this.block = true;
    }

    public boolean isBlocking() {
        return this.block;
    }

    public int getSelected() {
        return this.status;
    }

    public static int resolveDuplicate(JFrame jFrame, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        DuplicateResolverDialog duplicateResolverDialog = new DuplicateResolverDialog(jFrame, bibtexEntry, bibtexEntry2, 1);
        duplicateResolverDialog.setVisible(true);
        return duplicateResolverDialog.getSelected();
    }

    public static int resolveDuplicate(JDialog jDialog, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        DuplicateResolverDialog duplicateResolverDialog = new DuplicateResolverDialog(jDialog, bibtexEntry, bibtexEntry2, 1);
        duplicateResolverDialog.setVisible(true);
        return duplicateResolverDialog.getSelected();
    }

    public static int resolveDuplicateInImport(JabRefFrame jabRefFrame, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        DuplicateResolverDialog duplicateResolverDialog = new DuplicateResolverDialog(jabRefFrame, bibtexEntry, bibtexEntry2, 2);
        duplicateResolverDialog.setVisible(true);
        return duplicateResolverDialog.getSelected();
    }
}

