/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.jabref.BibLatexEntryTypes;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.util.Util;

public abstract class BibtexEntryType
implements Comparable<BibtexEntryType> {
    private static final TreeMap<String, BibtexEntryType> ALL_TYPES = new TreeMap();
    private static final TreeMap<String, BibtexEntryType> STANDARD_TYPES;

    public abstract String getName();

    @Override
    public int compareTo(BibtexEntryType bibtexEntryType) {
        return this.getName().compareTo(bibtexEntryType.getName());
    }

    public abstract String[] getOptionalFields();

    public abstract String[] getRequiredFields();

    public String[] getPrimaryOptionalFields() {
        return this.getOptionalFields();
    }

    public String[] getSecondaryOptionalFields() {
        return Util.getRemainder(this.getOptionalFields(), this.getPrimaryOptionalFields());
    }

    public abstract String describeRequiredFields();

    public abstract boolean hasAllRequiredFields(BibtexEntry var1, BibtexDatabase var2);

    public String[] getUtilityFields() {
        return new String[]{"search"};
    }

    public boolean isRequired(String string) {
        String[] stringArray = this.getRequiredFields();
        if (stringArray == null) {
            return false;
        }
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isOptional(String string) {
        String[] stringArray = this.getOptionalFields();
        if (stringArray == null) {
            return false;
        }
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isVisibleAtNewEntryDialog() {
        return true;
    }

    public static BibtexEntryType getType(String string) {
        BibtexEntryType bibtexEntryType = ALL_TYPES.get(string.toLowerCase(Locale.US));
        if (bibtexEntryType == null) {
            return null;
        }
        return bibtexEntryType;
    }

    public static BibtexEntryType getStandardType(String string) {
        BibtexEntryType bibtexEntryType = STANDARD_TYPES.get(string.toLowerCase());
        if (bibtexEntryType == null) {
            return null;
        }
        return bibtexEntryType;
    }

    public static void addOrModifyCustomEntryType(CustomEntryType customEntryType) {
        ALL_TYPES.put(customEntryType.getName().toLowerCase(Locale.US), customEntryType);
    }

    public static Set<String> getAllTypes() {
        return ALL_TYPES.keySet();
    }

    public static Collection<BibtexEntryType> getAllValues() {
        return ALL_TYPES.values();
    }

    public static void removeType(String string) {
        String string2 = string.toLowerCase();
        ALL_TYPES.remove(string2);
        if (STANDARD_TYPES.get(string2) != null) {
            BibtexEntryType.addOrModifyCustomEntryType((CustomEntryType)STANDARD_TYPES.get(string2));
        }
    }

    public static void loadCustomEntryTypes(JabRefPreferences jabRefPreferences) {
        CustomEntryType customEntryType;
        int n = 0;
        while ((customEntryType = jabRefPreferences.getCustomEntryType(n)) != null) {
            BibtexEntryType.addOrModifyCustomEntryType(customEntryType);
            ++n;
        }
    }

    public static void saveCustomEntryTypes(JabRefPreferences jabRefPreferences) {
        Iterator<String> iterator = ALL_TYPES.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            BibtexEntryType bibtexEntryType = ALL_TYPES.get(iterator.next());
            if (!(bibtexEntryType instanceof CustomEntryType)) continue;
            jabRefPreferences.storeCustomEntryType((CustomEntryType)bibtexEntryType, n);
            ++n;
        }
        jabRefPreferences.purgeCustomEntryTypes(n);
    }

    public String[] getRequiredFieldsForCustomization() {
        return this.getRequiredFields();
    }

    static {
        if (!Globals.prefs.getBoolean("biblatexMode")) {
            ALL_TYPES.put("article", BibtexEntryTypes.ARTICLE);
            ALL_TYPES.put("inbook", BibtexEntryTypes.INBOOK);
            ALL_TYPES.put("book", BibtexEntryTypes.BOOK);
            ALL_TYPES.put("booklet", BibtexEntryTypes.BOOKLET);
            ALL_TYPES.put("incollection", BibtexEntryTypes.INCOLLECTION);
            ALL_TYPES.put("conference", BibtexEntryTypes.CONFERENCE);
            ALL_TYPES.put("inproceedings", BibtexEntryTypes.INPROCEEDINGS);
            ALL_TYPES.put("proceedings", BibtexEntryTypes.PROCEEDINGS);
            ALL_TYPES.put("manual", BibtexEntryTypes.MANUAL);
            ALL_TYPES.put("mastersthesis", BibtexEntryTypes.MASTERSTHESIS);
            ALL_TYPES.put("phdthesis", BibtexEntryTypes.PHDTHESIS);
            ALL_TYPES.put("techreport", BibtexEntryTypes.TECHREPORT);
            ALL_TYPES.put("unpublished", BibtexEntryTypes.UNPUBLISHED);
            ALL_TYPES.put("patent", BibtexEntryTypes.PATENT);
            ALL_TYPES.put("standard", BibtexEntryTypes.STANDARD);
            ALL_TYPES.put("electronic", BibtexEntryTypes.ELECTRONIC);
            ALL_TYPES.put("periodical", BibtexEntryTypes.PERIODICAL);
            ALL_TYPES.put("misc", BibtexEntryTypes.MISC);
            ALL_TYPES.put("other", BibtexEntryTypes.OTHER);
            ALL_TYPES.put("ieeetranbstctl", BibtexEntryTypes.IEEETRANBSTCTL);
        } else {
            ALL_TYPES.put("article", BibLatexEntryTypes.ARTICLE);
            ALL_TYPES.put("book", BibLatexEntryTypes.BOOK);
            ALL_TYPES.put("inbook", BibLatexEntryTypes.INBOOK);
            ALL_TYPES.put("bookinbook", BibLatexEntryTypes.BOOKINBOOK);
            ALL_TYPES.put("suppbook", BibLatexEntryTypes.SUPPBOOK);
            ALL_TYPES.put("booklet", BibLatexEntryTypes.BOOKLET);
            ALL_TYPES.put("collection", BibLatexEntryTypes.COLLECTION);
            ALL_TYPES.put("incollection", BibLatexEntryTypes.INCOLLECTION);
            ALL_TYPES.put("suppcollection", BibLatexEntryTypes.SUPPCOLLECTION);
            ALL_TYPES.put("manual", BibLatexEntryTypes.MANUAL);
            ALL_TYPES.put("misc", BibLatexEntryTypes.MISC);
            ALL_TYPES.put("online", BibLatexEntryTypes.ONLINE);
            ALL_TYPES.put("patent", BibLatexEntryTypes.PATENT);
            ALL_TYPES.put("periodical", BibLatexEntryTypes.PERIODICAL);
            ALL_TYPES.put("suppperiodical", BibLatexEntryTypes.SUPPPERIODICAL);
            ALL_TYPES.put("proceedings", BibLatexEntryTypes.PROCEEDINGS);
            ALL_TYPES.put("inproceedings", BibLatexEntryTypes.INPROCEEDINGS);
            ALL_TYPES.put("reference", BibLatexEntryTypes.REFERENCE);
            ALL_TYPES.put("inreference", BibLatexEntryTypes.INREFERENCE);
            ALL_TYPES.put("report", BibLatexEntryTypes.REPORT);
            ALL_TYPES.put("set", BibLatexEntryTypes.SET);
            ALL_TYPES.put("thesis", BibLatexEntryTypes.THESIS);
            ALL_TYPES.put("unpublished", BibLatexEntryTypes.UNPUBLISHED);
            ALL_TYPES.put("conference", BibLatexEntryTypes.CONFERENCE);
            ALL_TYPES.put("electronic", BibLatexEntryTypes.ELECTRONIC);
            ALL_TYPES.put("mastersthesis", BibLatexEntryTypes.MASTERSTHESIS);
            ALL_TYPES.put("phdthesis", BibLatexEntryTypes.PHDTHESIS);
            ALL_TYPES.put("techreport", BibLatexEntryTypes.TECHREPORT);
            ALL_TYPES.put("www", BibLatexEntryTypes.WWW);
            ALL_TYPES.put("ieeetranbstctl", BibLatexEntryTypes.IEEETRANBSTCTL);
        }
        STANDARD_TYPES = new TreeMap<String, BibtexEntryType>((SortedMap<String, BibtexEntryType>)ALL_TYPES);
    }
}

