/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BaseAction;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.CallBack;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.ContentSelectorDialog2;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;
import net.sf.jabref.DuplicateSearch;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.EntryMarker;
import net.sf.jabref.EntryTypeDialog;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FindUnlinkedFilesDialog;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MarkEntriesAction;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreambleEditor;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.ReplaceStringDialog;
import net.sf.jabref.RightClickMenu;
import net.sf.jabref.SendAsEMailAction;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.StringDialog;
import net.sf.jabref.TransferableBibtexEntry;
import net.sf.jabref.Worker;
import net.sf.jabref.autocompleter.AutoCompleter;
import net.sf.jabref.autocompleter.AutoCompleterFactory;
import net.sf.jabref.autocompleter.ContentAutoCompleters;
import net.sf.jabref.collab.ChangeScanner;
import net.sf.jabref.collab.FileUpdateListener;
import net.sf.jabref.collab.FileUpdatePanel;
import net.sf.jabref.export.ExportToClipboardAction;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.SaveDatabaseAction;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.external.AttachFileAction;
import net.sf.jabref.external.AutoSetExternalFileForEntries;
import net.sf.jabref.external.ExternalFileMenuItem;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.FindFullTextAction;
import net.sf.jabref.external.RegExpFileSearch;
import net.sf.jabref.external.SynchronizeFileField;
import net.sf.jabref.external.WriteXMPAction;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.gui.CleanUpAction;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.GlazedEntrySorter;
import net.sf.jabref.gui.GroupAddRemoveDialog;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.gui.MainTableFormat;
import net.sf.jabref.gui.MainTableSelectionListener;
import net.sf.jabref.gui.MergeEntriesDialog;
import net.sf.jabref.imports.AppendDatabaseAction;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.SPIRESFetcher;
import net.sf.jabref.journals.AbbreviateAction;
import net.sf.jabref.journals.UnabbreviateAction;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.labelPattern.SearchFixDuplicateLabels;
import net.sf.jabref.search.matchers.NoSearchMatcher;
import net.sf.jabref.search.matchers.SearchMatcher;
import net.sf.jabref.specialfields.Printed;
import net.sf.jabref.specialfields.Priority;
import net.sf.jabref.specialfields.Quality;
import net.sf.jabref.specialfields.Rank;
import net.sf.jabref.specialfields.ReadStatus;
import net.sf.jabref.specialfields.Relevance;
import net.sf.jabref.specialfields.SpecialFieldAction;
import net.sf.jabref.specialfields.SpecialFieldDatabaseChangeListener;
import net.sf.jabref.specialfields.SpecialFieldValue;
import net.sf.jabref.sql.DBConnectDialog;
import net.sf.jabref.sql.DBExporterAndImporterFactory;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.DbConnectAction;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.sql.exporter.DBExporter;
import net.sf.jabref.undo.CountingUndoManager;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableChangeType;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableKeyChange;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.util.FileBasedLock;
import net.sf.jabref.util.Util;
import net.sf.jabref.wizard.text.gui.TextInputDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasePanel
extends JPanel
implements ClipboardOwner,
FileUpdateListener {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(BasePanel.class);
    public static final int SHOWING_NOTHING = 0;
    private static final int SHOWING_PREVIEW = 1;
    public static final int SHOWING_EDITOR = 2;
    public static final int WILL_SHOW_EDITOR = 3;
    BibtexDatabase database;
    private int mode = 0;
    private EntryEditor currentEditor = null;
    private PreviewPanel currentPreview = null;
    boolean tmp = true;
    private MainTableSelectionListener selectionListener = null;
    private ListEventListener<BibtexEntry> groupsHighlightListener;
    JSplitPane contentPane = new JSplitPane();
    private JSplitPane splitPane;
    JabRefFrame frame;
    private String fileMonitorHandle = null;
    private boolean saving = false;
    private boolean updatedExternally = false;
    private String encoding;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    private AutoCompleter searchAutoCompleter;
    private AutoCompleteListener searchCompleteListener = null;
    public final CountingUndoManager undoManager = new CountingUndoManager(this);
    private final UndoAction undoAction = new UndoAction();
    private final RedoAction redoAction = new RedoAction();
    private final List<BibtexEntry> previousEntries = new ArrayList<BibtexEntry>();
    private final List<BibtexEntry> nextEntries = new ArrayList<BibtexEntry>();
    private boolean baseChanged = false;
    private boolean nonUndoableChange = false;
    public MainTable mainTable = null;
    public MainTableFormat tableFormat = null;
    private FilterList<BibtexEntry> searchFilterList = null;
    private FilterList<BibtexEntry> groupFilterList = null;
    public RightClickMenu rcm;
    private BibtexEntry showing = null;
    private boolean backOrForwardInProgress = false;
    public final HashMap<String, EntryEditor> entryEditors = new HashMap();
    private PreambleEditor preambleEditor = null;
    private StringDialog stringDialog = null;
    private SaveDatabaseAction saveAction;
    private boolean showingSearch = false;
    public boolean sortingBySearchResults = false;
    public boolean coloringBySearchResults = false;
    public boolean hidingNonHits = false;
    public boolean sortingByGroup = false;
    public boolean sortingByCiteSeerResults = false;
    public boolean coloringByGroup = false;
    int lastSearchHits = -1;
    final MetaData metaData;
    private final HashMap<String, Object> actions = new HashMap();
    private SidePaneManager sidePaneManager;
    private ContentAutoCompleters autoCompleters;

    public ContentAutoCompleters getAutoCompleters() {
        return this.autoCompleters;
    }

    public BasePanel(JabRefFrame jabRefFrame, BibtexDatabase bibtexDatabase, File file, MetaData metaData, String string) {
        assert (jabRefFrame != null);
        assert (bibtexDatabase != null);
        assert (string != null);
        assert (metaData != null);
        this.encoding = string;
        this.metaData = metaData;
        this.sidePaneManager = Globals.sidePaneManager;
        this.frame = jabRefFrame;
        this.database = bibtexDatabase;
        this.setupActions();
        this.setupMainPanel();
        metaData.setFile(file);
        bibtexDatabase.addDatabaseChangeListener(new GroupTreeUpdater());
        if (file == null) {
            if (!this.database.getEntries().isEmpty()) {
                this.baseChanged = true;
            }
        } else {
            try {
                this.fileMonitorHandle = Globals.fileUpdateMonitor.addUpdateListener(this, file);
            }
            catch (IOException iOException) {
                LOGGER.warn("Could not register FileUpdateMonitor", iOException);
            }
        }
    }

    public boolean isBaseChanged() {
        return this.baseChanged;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public BibtexDatabase database() {
        return this.database;
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public JabRefFrame frame() {
        return this.frame;
    }

    public JabRefPreferences prefs() {
        return Globals.prefs;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void output(String string) {
        boolean bl = false;
        if (!bl) {
            this.frame.output(string);
        }
    }

    private void setupActions() {
        this.saveAction = new SaveDatabaseAction(this);
        CleanUpAction cleanUpAction = new CleanUpAction(this);
        this.actions.put("undo", this.undoAction);
        this.actions.put("redo", this.redoAction);
        this.actions.put("focusTable", new BaseAction(){

            @Override
            public void action() throws Throwable {
                new FocusRequester(BasePanel.this.mainTable);
            }
        });
        this.actions.put("edit", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.selectionListener.editSignalled();
            }
        });
        this.actions.put("test", new FindFullTextAction(this));
        this.actions.put("save", this.saveAction);
        this.actions.put("saveAs", new BaseAction(){

            @Override
            public void action() throws Throwable {
                BasePanel.this.saveAction.saveAs();
            }
        });
        this.actions.put("saveSelectedAs", new SaveSelectedAction(FileActions.DatabaseSaveType.DEFAULT));
        this.actions.put("saveSelectedAsPlain", new SaveSelectedAction(FileActions.DatabaseSaveType.PLAIN_BIBTEX));
        this.actions.put("copy", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                    TransferableBibtexEntry transferableBibtexEntry = new TransferableBibtexEntry(bibtexEntryArray);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferableBibtexEntry, BasePanel.this);
                    BasePanel.this.output(Globals.lang("Copied") + ' ' + (bibtexEntryArray.length > 1 ? bibtexEntryArray.length + " " + Globals.lang("entries") : "1 " + Globals.lang("entry") + '.'));
                } else {
                    Object object;
                    int[] nArray = BasePanel.this.mainTable.getSelectedRows();
                    int[] nArray2 = BasePanel.this.mainTable.getSelectedColumns();
                    if (nArray2.length == 1 && nArray.length == 1 && (object = BasePanel.this.mainTable.getValueAt(nArray[0], nArray2[0])) != null) {
                        StringSelection stringSelection = new StringSelection(object.toString());
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, BasePanel.this);
                        BasePanel.this.output(Globals.lang("Copied cell contents") + '.');
                    }
                }
            }
        });
        this.actions.put("cut", new BaseAction(){

            @Override
            public void action() throws Throwable {
                BasePanel.this.runCommand("copy");
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                    NamedCompound namedCompound = new NamedCompound(Globals.lang(bibtexEntryArray.length > 1 ? "cut entries" : "cut entry"));
                    for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                        BasePanel.this.database.removeEntry(bibtexEntry.getId());
                        BasePanel.this.ensureNotShowing(bibtexEntry);
                        namedCompound.addEdit(new UndoableRemoveEntry(BasePanel.this.database, bibtexEntry, BasePanel.this));
                    }
                    BasePanel.this.frame.output(Globals.lang("Cut_pr") + ' ' + (bibtexEntryArray.length > 1 ? bibtexEntryArray.length + " " + Globals.lang("entries") : Globals.lang("entry")) + '.');
                    namedCompound.end();
                    BasePanel.this.undoManager.addEdit(namedCompound);
                    BasePanel.this.markBaseChanged();
                }
            }
        });
        this.actions.put("delete", new BaseAction(){

            @Override
            public void action() {
                boolean bl;
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0 && (bl = BasePanel.this.showDeleteConfirmationDialog(bibtexEntryArray.length))) {
                    NamedCompound namedCompound = new NamedCompound(Globals.lang(bibtexEntryArray.length > 1 ? "delete entries" : "delete entry"));
                    for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                        BasePanel.this.database.removeEntry(bibtexEntry.getId());
                        BasePanel.this.ensureNotShowing(bibtexEntry);
                        namedCompound.addEdit(new UndoableRemoveEntry(BasePanel.this.database, bibtexEntry, BasePanel.this));
                    }
                    BasePanel.this.markBaseChanged();
                    BasePanel.this.frame.output(Globals.lang("Deleted") + ' ' + (bibtexEntryArray.length > 1 ? bibtexEntryArray.length + " " + Globals.lang("entries") : Globals.lang("entry")) + '.');
                    namedCompound.end();
                    BasePanel.this.undoManager.addEdit(namedCompound);
                }
            }
        });
        this.actions.put("paste", new BaseAction(){

            @Override
            public void action() {
                Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (transferable != null) {
                    Object object;
                    Object object2;
                    BibtexEntry[] bibtexEntryArray = null;
                    if (transferable.isDataFlavorSupported(TransferableBibtexEntry.entryFlavor)) {
                        try {
                            bibtexEntryArray = (BibtexEntry[])transferable.getTransferData(TransferableBibtexEntry.entryFlavor);
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            unsupportedFlavorException.printStackTrace();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        try {
                            object2 = new BibtexParser(new StringReader((String)transferable.getTransferData(DataFlavor.stringFlavor)));
                            object = ((BibtexParser)object2).parse().getDatabase();
                            LOGGER.info("Parsed " + ((BibtexDatabase)object).getEntryCount() + " entries from clipboard text");
                            if (((BibtexDatabase)object).getEntryCount() > 0) {
                                bibtexEntryArray = ((BibtexDatabase)object).getEntries().toArray(new BibtexEntry[((BibtexDatabase)object).getEntryCount()]);
                            }
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            unsupportedFlavorException.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                        object2 = new NamedCompound(Globals.lang(bibtexEntryArray.length > 1 ? "paste entries" : "paste entry"));
                        object = null;
                        for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                            try {
                                BibtexEntry bibtexEntry2 = (BibtexEntry)bibtexEntry.clone();
                                if (object == null) {
                                    object = bibtexEntry2;
                                }
                                Util.setAutomaticFields(bibtexEntry2, Globals.prefs.getBoolean("overwriteOwner"), Globals.prefs.getBoolean("overwriteTimeStamp"));
                                bibtexEntry2.setId(IdGenerator.next());
                                BasePanel.this.database.insertEntry(bibtexEntry2);
                                ((NamedCompound)object2).addEdit(new UndoableInsertEntry(BasePanel.this.database, bibtexEntry2, BasePanel.this));
                            }
                            catch (KeyCollisionException keyCollisionException) {
                                LOGGER.info("KeyCollisionException... this shouldn't happen.", keyCollisionException);
                            }
                        }
                        ((CompoundEdit)object2).end();
                        BasePanel.this.undoManager.addEdit((UndoableEdit)object2);
                        BasePanel.this.output(Globals.lang("Pasted") + ' ' + (bibtexEntryArray.length > 1 ? bibtexEntryArray.length + " " + Globals.lang("entries") : "1 " + Globals.lang("entry")) + '.');
                        BasePanel.this.markBaseChanged();
                        if (Globals.prefs.getBoolean("autoOpenForm")) {
                            BasePanel.this.selectionListener.editSignalled((BibtexEntry)object);
                        }
                        BasePanel.this.highlightEntry((BibtexEntry)object);
                    }
                }
            }
        });
        this.actions.put("selectAll", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.mainTable.selectAll();
            }
        });
        this.actions.put("editPreamble", new BaseAction(){

            @Override
            public void action() {
                if (BasePanel.this.preambleEditor == null) {
                    PreambleEditor preambleEditor = new PreambleEditor(BasePanel.this.frame, BasePanel.this, BasePanel.this.database, Globals.prefs);
                    Util.placeDialog(preambleEditor, BasePanel.this.frame);
                    preambleEditor.setVisible(true);
                    BasePanel.this.preambleEditor = preambleEditor;
                } else {
                    BasePanel.this.preambleEditor.setVisible(true);
                }
            }
        });
        this.actions.put("editStrings", new BaseAction(){

            @Override
            public void action() {
                if (BasePanel.this.stringDialog == null) {
                    StringDialog stringDialog = new StringDialog(BasePanel.this.frame, BasePanel.this, BasePanel.this.database, Globals.prefs);
                    Util.placeDialog(stringDialog, BasePanel.this.frame);
                    stringDialog.setVisible(true);
                    BasePanel.this.stringDialog = stringDialog;
                } else {
                    BasePanel.this.stringDialog.setVisible(true);
                }
            }
        });
        this.actions.put("toggleGroups", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.sidePaneManager.toggle("groups");
                BasePanel.this.frame.groupToggle.setSelected(BasePanel.this.sidePaneManager.isComponentVisible("groups"));
            }
        });
        this.actions.put("toggleToolbar", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.frame.tlb.setVisible(!BasePanel.this.frame.tlb.isVisible());
            }
        });
        this.actions.put("dbConnect", new DbConnectAction(this));
        this.actions.put("dbExport", new AbstractWorker(){
            String errorMessage = null;
            boolean connectToDB = false;

            @Override
            public void init() {
                DBStrings dBStrings = BasePanel.this.metaData.getDBStrings();
                if (!dBStrings.isConfigValid()) {
                    if (!dBStrings.isInitialized()) {
                        dBStrings.initialize();
                    }
                    DBConnectDialog dBConnectDialog = new DBConnectDialog(BasePanel.this.frame(), dBStrings);
                    Util.placeDialog(dBConnectDialog, BasePanel.this);
                    dBConnectDialog.setVisible(true);
                    this.connectToDB = dBConnectDialog.getConnectToDB();
                    if (this.connectToDB) {
                        dBStrings = dBConnectDialog.getDBStrings();
                        BasePanel.this.metaData.setDBStrings(dBStrings);
                        dBConnectDialog.dispose();
                    }
                } else {
                    this.connectToDB = true;
                }
            }

            @Override
            public void run() {
                if (this.connectToDB) {
                    DBStrings dBStrings = BasePanel.this.metaData.getDBStrings();
                    try {
                        BasePanel.this.frame.output(Globals.lang("Attempting SQL export..."));
                        DBExporterAndImporterFactory dBExporterAndImporterFactory = new DBExporterAndImporterFactory();
                        DBExporter dBExporter = dBExporterAndImporterFactory.getExporter(dBStrings.getServerType());
                        dBExporter.exportDatabaseToDBMS(BasePanel.this.database, BasePanel.this.metaData, null, dBStrings, BasePanel.this.frame);
                        dBStrings.isConfigValid(true);
                    }
                    catch (Exception exception) {
                        String string = "Could not export to SQL database for the following reason:";
                        this.errorMessage = SQLUtil.getExceptionMessage(exception);
                        exception.printStackTrace();
                        dBStrings.isConfigValid(false);
                        JOptionPane.showMessageDialog(BasePanel.this.frame, Globals.lang(string) + '\n' + this.errorMessage, Globals.lang("Export to SQL database"), 0);
                    }
                    BasePanel.this.metaData.setDBStrings(dBStrings);
                }
            }

            @Override
            public void update() {
                if (this.errorMessage == null) {
                    if (this.connectToDB) {
                        BasePanel.this.frame.output(Globals.lang("%0 export successful"));
                    }
                } else {
                    String string = "Could not export to SQL database for the following reason:";
                    BasePanel.this.frame.output(Globals.lang(string) + "  " + this.errorMessage);
                    JOptionPane.showMessageDialog(BasePanel.this.frame, Globals.lang(string) + '\n' + this.errorMessage, Globals.lang("Export to SQL database"), 0);
                    this.errorMessage = null;
                }
            }
        });
        this.actions.put("findUnlinkedFiles", new BaseAction(){

            @Override
            public void action() throws Throwable {
                FindUnlinkedFilesDialog findUnlinkedFilesDialog = new FindUnlinkedFilesDialog((Frame)BasePanel.this.frame, BasePanel.this.frame, BasePanel.this);
                Util.placeDialog(findUnlinkedFilesDialog, BasePanel.this.frame);
                findUnlinkedFilesDialog.setVisible(true);
            }
        });
        this.actions.put("makeKey", new AbstractWorker(){
            List<BibtexEntry> entries;
            int numSelected;
            boolean cancelled = false;

            @Override
            public void init() {
                this.entries = new ArrayList<BibtexEntry>(Arrays.asList(BasePanel.this.getSelectedEntries()));
                this.numSelected = this.entries.size();
                if (this.entries.isEmpty()) {
                    JOptionPane.showMessageDialog(BasePanel.this.frame, Globals.lang("First select the entries you want keys to be generated for."), Globals.lang("Autogenerate BibTeX key"), 1);
                    return;
                }
                BasePanel.this.frame.block();
                BasePanel.this.output(Globals.lang("Generating BibTeX key for") + ' ' + this.numSelected + ' ' + (this.numSelected > 1 ? Globals.lang("entries") : Globals.lang("entry")) + "...");
            }

            @Override
            public void run() {
                Object object;
                BibtexEntry bibtexEntry;
                NamedCompound namedCompound = new NamedCompound(Globals.lang("autogenerate keys"));
                Object object2 = this.entries.iterator();
                while (object2.hasNext()) {
                    bibtexEntry = object2.next();
                    if (bibtexEntry.getField("bibtexkey") == null) continue;
                    if (Globals.prefs.getBoolean("avoidOverwritingKey")) {
                        object2.remove();
                        continue;
                    }
                    if (!Globals.prefs.getBoolean("warnBeforeOverwritingKey")) continue;
                    object = new CheckBoxMessage(Globals.lang("One or more keys will be overwritten. Continue?"), Globals.lang("Disable this confirmation dialog"), false);
                    int n = JOptionPane.showConfirmDialog(BasePanel.this.frame, object, Globals.lang("Overwrite keys"), 0);
                    if (((CheckBoxMessage)object).isSelected()) {
                        Globals.prefs.putBoolean("warnBeforeOverwritingKey", false);
                    }
                    if (n != 1) break;
                    this.cancelled = true;
                    return;
                }
                object2 = new HashMap();
                if (!Globals.prefs.getBoolean("avoidOverwritingKey")) {
                    object = this.entries.iterator();
                    while (object.hasNext()) {
                        BibtexEntry bibtexEntry2;
                        bibtexEntry = bibtexEntry2 = object.next();
                        ((HashMap)object2).put(bibtexEntry, bibtexEntry.getField("bibtexkey"));
                        BasePanel.this.database.setCiteKeyForEntry(bibtexEntry.getId(), null);
                    }
                }
                object = this.entries.iterator();
                while (object.hasNext()) {
                    BibtexEntry bibtexEntry3;
                    bibtexEntry = bibtexEntry3 = object.next();
                    bibtexEntry = LabelPatternUtil.makeLabel(BasePanel.this.metaData, BasePanel.this.database, bibtexEntry);
                    namedCompound.addEdit(new UndoableKeyChange(BasePanel.this.database, bibtexEntry.getId(), (String)((HashMap)object2).get(bibtexEntry), bibtexEntry.getField("bibtexkey")));
                }
                namedCompound.end();
                BasePanel.this.undoManager.addEdit(namedCompound);
            }

            @Override
            public void update() {
                BasePanel.this.database.setFollowCrossrefs(true);
                if (this.cancelled) {
                    BasePanel.this.frame.unblock();
                    return;
                }
                BasePanel.this.markBaseChanged();
                this.numSelected = this.entries.size();
                for (final BibtexEntry bibtexEntry : this.entries) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int n = BasePanel.this.mainTable.findEntry(bibtexEntry);
                            if (n >= 0 && BasePanel.this.mainTable.getSelectedRowCount() < entries.size()) {
                                BasePanel.this.mainTable.addRowSelectionInterval(n, n);
                            }
                        }
                    });
                }
                BasePanel.this.output(Globals.lang("Generated BibTeX key for") + ' ' + this.numSelected + ' ' + (this.numSelected != 1 ? Globals.lang("entries") : Globals.lang("entry")));
                BasePanel.this.frame.unblock();
            }
        });
        this.actions.put("Cleanup", cleanUpAction);
        this.actions.put("mergeEntries", new BaseAction(){

            @Override
            public void action() {
                new MergeEntriesDialog(BasePanel.this);
            }
        });
        this.actions.put("search", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.sidePaneManager.show("search");
                BasePanel.this.frame.searchToggle.setSelected(true);
                BasePanel.this.frame.getSearchManager().startSearch();
            }
        });
        this.actions.put("toggleSearch", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.sidePaneManager.toggle("search");
                boolean bl = BasePanel.this.sidePaneManager.isComponentVisible("search");
                BasePanel.this.frame.searchToggle.setSelected(bl);
                if (bl) {
                    BasePanel.this.frame.getSearchManager().startSearch();
                }
            }
        });
        this.actions.put("incSearch", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.sidePaneManager.show("search");
                BasePanel.this.frame.searchToggle.setSelected(true);
                BasePanel.this.frame.getSearchManager().startIncrementalSearch();
            }
        });
        this.actions.put("copyKey", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                    BasePanel.this.storeCurrentEdit();
                    Vector<String> vector = new Vector<String>();
                    for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                        if (bibtexEntry.getField("bibtexkey") == null) continue;
                        vector.add(bibtexEntry.getField("bibtexkey"));
                    }
                    if (vector.isEmpty()) {
                        BasePanel.this.output("None of the selected entries have BibTeX keys.");
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder((String)vector.elementAt(0));
                    for (int i = 1; i < vector.size(); ++i) {
                        stringBuilder.append(',');
                        stringBuilder.append((String)vector.elementAt(i));
                    }
                    StringSelection stringSelection = new StringSelection(stringBuilder.toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, BasePanel.this);
                    if (vector.size() == bibtexEntryArray.length) {
                        BasePanel.this.output(Globals.lang(bibtexEntryArray.length > 1 ? "Copied keys" : "Copied key") + '.');
                    } else {
                        BasePanel.this.output(Globals.lang("Warning") + ": " + (bibtexEntryArray.length - vector.size()) + ' ' + Globals.lang("out of") + ' ' + bibtexEntryArray.length + ' ' + Globals.lang("entries have undefined BibTeX key") + '.');
                    }
                }
            }
        });
        this.actions.put("copyCiteKey", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                    BasePanel.this.storeCurrentEdit();
                    Vector<String> vector = new Vector<String>();
                    for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                        if (bibtexEntry.getField("bibtexkey") == null) continue;
                        vector.add(bibtexEntry.getField("bibtexkey"));
                    }
                    if (vector.isEmpty()) {
                        BasePanel.this.output("None of the selected entries have BibTeX keys.");
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder((String)vector.elementAt(0));
                    for (int i = 1; i < vector.size(); ++i) {
                        stringBuilder.append(',');
                        stringBuilder.append((String)vector.elementAt(i));
                    }
                    StringSelection stringSelection = new StringSelection("\\cite{" + stringBuilder.toString() + '}');
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, BasePanel.this);
                    if (vector.size() == bibtexEntryArray.length) {
                        BasePanel.this.output(bibtexEntryArray.length > 1 ? Globals.lang("Copied keys") : Globals.lang("Copied key") + '.');
                    } else {
                        BasePanel.this.output(Globals.lang("Warning") + ": " + (bibtexEntryArray.length - vector.size()) + ' ' + Globals.lang("out of") + ' ' + bibtexEntryArray.length + ' ' + Globals.lang("entries have undefined BibTeX key") + '.');
                    }
                }
            }
        });
        this.actions.put("copyKeyAndTitle", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                    Layout layout;
                    BasePanel.this.storeCurrentEdit();
                    StringReader stringReader = new StringReader("\\bibtexkey - \\begin{title}\\format[RemoveBrackets]{\\title}\\end{title}\n");
                    try {
                        layout = new LayoutHelper(stringReader).getLayoutFromText("net.sf.jabref.export.layout.format.");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = 0;
                    for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                        if (bibtexEntry.getField("bibtexkey") == null) continue;
                        ++n;
                        stringBuilder.append(layout.doLayout(bibtexEntry, BasePanel.this.database));
                    }
                    if (n == 0) {
                        BasePanel.this.output("None of the selected entries have BibTeX keys.");
                        return;
                    }
                    StringSelection stringSelection = new StringSelection(stringBuilder.toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, BasePanel.this);
                    if (n == bibtexEntryArray.length) {
                        BasePanel.this.output(Globals.lang(bibtexEntryArray.length > 1 ? "Copied keys" : "Copied key") + '.');
                    } else {
                        BasePanel.this.output(Globals.lang("Warning") + ": " + n + ' ' + Globals.lang("out of") + ' ' + bibtexEntryArray.length + ' ' + Globals.lang("entries have undefined BibTeX key") + '.');
                    }
                }
            }
        });
        this.actions.put("mergeDatabase", new AppendDatabaseAction(this.frame, this));
        this.actions.put("openFile", new BaseAction(){

            @Override
            public void action() {
                JabRefExecutorService.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                        String string = "ps";
                        if (bibtexEntryArray != null && bibtexEntryArray.length == 1) {
                            Object object;
                            FileListEntry fileListEntry = null;
                            FileListTableModel fileListTableModel = new FileListTableModel();
                            fileListTableModel.setContent(bibtexEntryArray[0].getField("file"));
                            for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
                                object = fileListTableModel.getEntry(i);
                                if (!((FileListEntry)object).getType().getName().toLowerCase().equals("pdf") && !((FileListEntry)object).getType().getName().toLowerCase().equals("ps")) continue;
                                fileListEntry = object;
                                break;
                            }
                            if (fileListEntry != null) {
                                try {
                                    Util.openExternalFileAnyFormat(BasePanel.this.metaData, fileListEntry.getLink(), fileListEntry.getType());
                                    BasePanel.this.output(Globals.lang("External viewer called") + '.');
                                }
                                catch (IOException iOException) {
                                    BasePanel.this.output(Globals.lang("Could not open link"));
                                    iOException.printStackTrace();
                                }
                                return;
                            }
                            String string2 = bibtexEntryArray[0].getField("ps");
                            if (bibtexEntryArray[0].getField("pdf") != null) {
                                string2 = bibtexEntryArray[0].getField("pdf");
                                string = "pdf";
                            }
                            object = null;
                            if (string2 != null) {
                                object = string2.toString();
                            } else if (Globals.prefs.getBoolean("runAutomaticFileSearch")) {
                                String string3;
                                ExternalFileType externalFileType;
                                int n;
                                List list;
                                Object object2;
                                String[] stringArray;
                                ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
                                arrayList.add(bibtexEntryArray[0]);
                                ExternalFileType[] externalFileTypeArray = Globals.prefs.getExternalFileTypeSelection();
                                ArrayList<File> arrayList2 = new ArrayList<File>();
                                if (BasePanel.this.metaData.getFileDirectory("file").length > 0) {
                                    stringArray = BasePanel.this.metaData.getFileDirectory("file");
                                    for (String object32 : stringArray) {
                                        arrayList2.add(new File(object32));
                                    }
                                }
                                stringArray = new ArrayList();
                                for (ExternalFileType externalFileType2 : externalFileTypeArray) {
                                    stringArray.add(externalFileType2.getExtension());
                                }
                                if (Globals.prefs.getBoolean("useRegExpSearch")) {
                                    String string32 = Globals.prefs.get("regExpSearchExpression");
                                    object2 = RegExpFileSearch.findFilesForSet(arrayList, (Collection<String>)stringArray, arrayList2, string32);
                                } else {
                                    object2 = Util.findAssociatedFiles(arrayList, (Collection<String>)stringArray, arrayList2);
                                }
                                if (object2.get(bibtexEntryArray[0]) != null && !(list = (List)object2.get(bibtexEntryArray[0])).isEmpty() && (n = ((String)(object = ((File)list.get(0)).getPath())).lastIndexOf(46)) >= 0 && n < ((String)object).length() - 1 && (externalFileType = Globals.prefs.getExternalFileTypeByExt(string3 = ((String)object).substring(n + 1))) != null) {
                                    try {
                                        Util.openExternalFileAnyFormat(BasePanel.this.metaData, (String)object, externalFileType);
                                        BasePanel.this.output(Globals.lang("External viewer called") + '.');
                                        return;
                                    }
                                    catch (IOException iOException) {
                                        BasePanel.this.output(Globals.lang("Error") + ": " + iOException.getMessage());
                                    }
                                }
                            }
                            if (object != null) {
                                try {
                                    Util.openExternalViewer(BasePanel.this.metaData(), (String)object, string);
                                    BasePanel.this.output(Globals.lang("External viewer called") + '.');
                                }
                                catch (IOException iOException) {
                                    BasePanel.this.output(Globals.lang("Error") + ": " + iOException.getMessage());
                                }
                            } else {
                                BasePanel.this.output(Globals.lang("No pdf or ps defined, and no file matching Bibtex key found") + '.');
                            }
                        } else {
                            BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                        }
                    }
                });
            }
        });
        this.actions.put("addFileLink", new AttachFileAction(this));
        this.actions.put("openExternalFile", new BaseAction(){

            @Override
            public void action() {
                JabRefExecutorService.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                        String string = "file";
                        if (bibtexEntryArray != null && bibtexEntryArray.length == 1) {
                            String string2 = bibtexEntryArray[0].getField(string);
                            if (string2 == null) {
                                BasePanel.this.runCommand("openFile");
                                return;
                            }
                            FileListTableModel fileListTableModel = new FileListTableModel();
                            fileListTableModel.setContent(string2);
                            if (fileListTableModel.getRowCount() == 0) {
                                BasePanel.this.runCommand("openFile");
                                return;
                            }
                            FileListEntry fileListEntry = fileListTableModel.getEntry(0);
                            ExternalFileMenuItem externalFileMenuItem = new ExternalFileMenuItem(BasePanel.this.frame(), bibtexEntryArray[0], "", fileListEntry.getLink(), (Icon)fileListEntry.getType().getIcon(), BasePanel.this.metaData(), fileListEntry.getType());
                            externalFileMenuItem.openLink();
                        } else {
                            BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                        }
                    }
                });
            }
        });
        this.actions.put("openFolder", new BaseAction(){

            @Override
            public void action() {
                JabRefExecutorService.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                        List<File> list = Util.getListOfLinkedFiles(bibtexEntryArray, BasePanel.this.metaData().getFileDirectory("file"));
                        for (File file : list) {
                            try {
                                Util.openFolderAndSelectFile(file.getAbsolutePath());
                            }
                            catch (IOException iOException) {
                                LOGGER.info("Could not open folder", iOException);
                            }
                        }
                    }
                });
            }
        });
        this.actions.put("openUrl", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                String string = "doi";
                if (bibtexEntryArray != null && bibtexEntryArray.length == 1) {
                    String string2 = bibtexEntryArray[0].getField("doi");
                    if (bibtexEntryArray[0].getField("url") != null) {
                        string2 = bibtexEntryArray[0].getField("url");
                        string = "url";
                    }
                    if (string2 != null) {
                        try {
                            Util.openExternalViewer(BasePanel.this.metaData(), string2.toString(), string);
                            BasePanel.this.output(Globals.lang("External viewer called") + '.');
                        }
                        catch (IOException iOException) {
                            BasePanel.this.output(Globals.lang("Error") + ": " + iOException.getMessage());
                        }
                    } else {
                        FileListEntry fileListEntry = null;
                        FileListTableModel fileListTableModel = new FileListTableModel();
                        fileListTableModel.setContent(bibtexEntryArray[0].getField("file"));
                        for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
                            FileListEntry fileListEntry2 = fileListTableModel.getEntry(i);
                            if (!fileListEntry2.getType().getName().toLowerCase().equals("url") && !fileListEntry2.getType().getName().toLowerCase().equals("ps")) continue;
                            fileListEntry = fileListEntry2;
                            break;
                        }
                        if (fileListEntry != null) {
                            try {
                                Util.openExternalFileAnyFormat(BasePanel.this.metaData, fileListEntry.getLink(), fileListEntry.getType());
                                BasePanel.this.output(Globals.lang("External viewer called") + '.');
                            }
                            catch (IOException iOException) {
                                BasePanel.this.output(Globals.lang("Could not open link"));
                                iOException.printStackTrace();
                            }
                        } else {
                            BasePanel.this.output(Globals.lang("No url defined") + '.');
                        }
                    }
                } else {
                    BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                }
            }
        });
        this.actions.put("openSpires", new BaseAction(){

            @Override
            public void action() {
                BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                if (bibtexEntryArray != null && bibtexEntryArray.length == 1) {
                    String string = null;
                    if (bibtexEntryArray[0].getField("eprint") != null) {
                        string = SPIRESFetcher.constructUrlFromEprint(bibtexEntryArray[0].getField("eprint"));
                    } else if (bibtexEntryArray[0].getField("slaccitation") != null) {
                        string = SPIRESFetcher.constructUrlFromSlaccitation(bibtexEntryArray[0].getField("slaccitation"));
                    }
                    if (string != null) {
                        try {
                            Util.openExternalViewer(BasePanel.this.metaData(), string.toString(), "url");
                            BasePanel.this.output(Globals.lang("External viewer called") + '.');
                        }
                        catch (IOException iOException) {
                            BasePanel.this.output(Globals.lang("Error") + ": " + iOException.getMessage());
                        }
                    } else {
                        BasePanel.this.output(Globals.lang("No url defined") + '.');
                    }
                } else {
                    BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                }
            }
        });
        this.actions.put("replaceAll", new BaseAction(){

            @Override
            public void action() {
                ReplaceStringDialog replaceStringDialog = new ReplaceStringDialog(BasePanel.this.frame);
                replaceStringDialog.setVisible(true);
                if (!replaceStringDialog.okPressed()) {
                    return;
                }
                int n = 0;
                NamedCompound namedCompound = new NamedCompound(Globals.lang("Replace string"));
                if (!replaceStringDialog.selOnly()) {
                    for (BibtexEntry bibtexEntry : BasePanel.this.database.getEntries()) {
                        n += replaceStringDialog.replace(bibtexEntry, namedCompound);
                    }
                } else {
                    BibtexEntry[] bibtexEntryArray;
                    for (BibtexEntry bibtexEntry : bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries()) {
                        n += replaceStringDialog.replace(bibtexEntry, namedCompound);
                    }
                }
                BasePanel.this.output(Globals.lang("Replaced") + ' ' + n + ' ' + Globals.lang(n == 1 ? "occurence" : "occurences") + '.');
                if (n > 0) {
                    namedCompound.end();
                    BasePanel.this.undoManager.addEdit(namedCompound);
                    BasePanel.this.markBaseChanged();
                }
            }
        });
        this.actions.put("dupliCheck", new BaseAction(){

            @Override
            public void action() {
                JabRefExecutorService.INSTANCE.execute(new DuplicateSearch(BasePanel.this));
            }
        });
        this.actions.put("plainTextImport", new BaseAction(){

            @Override
            public void action() {
                EntryTypeDialog entryTypeDialog = new EntryTypeDialog(BasePanel.this.frame);
                Util.placeDialog(entryTypeDialog, BasePanel.this);
                entryTypeDialog.setVisible(true);
                BibtexEntryType bibtexEntryType = entryTypeDialog.getChoice();
                if (bibtexEntryType == null) {
                    return;
                }
                String string = IdGenerator.next();
                BibtexEntry bibtexEntry = new BibtexEntry(string, bibtexEntryType);
                TextInputDialog textInputDialog = new TextInputDialog(BasePanel.this.frame, BasePanel.this, "import", true, bibtexEntry);
                Util.placeDialog(textInputDialog, BasePanel.this);
                textInputDialog.setVisible(true);
                if (textInputDialog.okPressed()) {
                    Util.setAutomaticFields(Collections.singletonList(bibtexEntry), false, false, false);
                    BasePanel.this.insertEntry(bibtexEntry);
                }
            }
        });
        this.actions.put("markEntries", new MarkEntriesAction(this.frame, 0));
        this.actions.put("unmarkEntries", new BaseAction(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void action() {
                try {
                    void var3_7;
                    BibtexEntry[] bibtexEntryArray = BasePanel.this.mainTable.getSelectedEntries();
                    if (bibtexEntryArray.length == 0) {
                        BasePanel.this.output(Globals.lang("No entries selected."));
                        return;
                    }
                    NamedCompound namedCompound = new NamedCompound(Globals.lang("Unmark entries"));
                    for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                        EntryMarker.unmarkEntry(bibtexEntry, false, BasePanel.this.database, namedCompound);
                    }
                    namedCompound.end();
                    BasePanel.this.undoManager.addEdit(namedCompound);
                    BasePanel.this.markBaseChanged();
                    if (bibtexEntryArray.length == 1) {
                        String string = Globals.lang("Unmarked selected entry");
                    } else {
                        String string = Globals.lang("Unmarked all %0 selected entries", Integer.toString(bibtexEntryArray.length));
                    }
                    BasePanel.this.output((String)var3_7);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        this.actions.put("unmarkAll", new BaseAction(){

            @Override
            public void action() {
                NamedCompound namedCompound = new NamedCompound(Globals.lang("Unmark all"));
                for (BibtexEntry bibtexEntry : BasePanel.this.database.getEntries()) {
                    EntryMarker.unmarkEntry(bibtexEntry, false, BasePanel.this.database, namedCompound);
                }
                namedCompound.end();
                BasePanel.this.undoManager.addEdit(namedCompound);
                BasePanel.this.markBaseChanged();
                BasePanel.this.output(Globals.lang("Unmarked all entries"));
            }
        });
        this.actions.put(Relevance.getInstance().getValues().get(0).getActionName(), new SpecialFieldAction(this.frame, Relevance.getInstance(), Relevance.getInstance().getValues().get(0).getFieldValue(), true, Globals.lang("Toggle relevance"), Globals.lang("Toggled relevance for %0 entries")));
        this.actions.put(Quality.getInstance().getValues().get(0).getActionName(), new SpecialFieldAction(this.frame, Quality.getInstance(), Quality.getInstance().getValues().get(0).getFieldValue(), true, Globals.lang("Toggle quality"), Globals.lang("Toggled quality for %0 entries")));
        this.actions.put(Printed.getInstance().getValues().get(0).getActionName(), new SpecialFieldAction(this.frame, Printed.getInstance(), Printed.getInstance().getValues().get(0).getFieldValue(), true, Globals.lang("Toggle print status"), Globals.lang("Toggled print status for %0 entries")));
        for (SpecialFieldValue specialFieldValue : Priority.getInstance().getValues()) {
            this.actions.put(specialFieldValue.getActionName(), specialFieldValue.getAction(this.frame));
        }
        for (SpecialFieldValue specialFieldValue : Rank.getInstance().getValues()) {
            this.actions.put(specialFieldValue.getActionName(), specialFieldValue.getAction(this.frame));
        }
        for (SpecialFieldValue specialFieldValue : ReadStatus.getInstance().getValues()) {
            this.actions.put(specialFieldValue.getActionName(), specialFieldValue.getAction(this.frame));
        }
        this.actions.put("togglePreview", new BaseAction(){

            @Override
            public void action() {
                boolean bl = !Globals.prefs.getBoolean("previewEnabled");
                Globals.prefs.putBoolean("previewEnabled", bl);
                BasePanel.this.frame.setPreviewActive(bl);
                BasePanel.this.frame.previewToggle.setSelected(bl);
            }
        });
        this.actions.put("toggleHighlightGroupsMatchingAny", new BaseAction(){

            @Override
            public void action() {
                boolean bl = !Globals.prefs.getBoolean("highlightGroupsMatchingAny");
                Globals.prefs.putBoolean("highlightGroupsMatchingAny", bl);
                BasePanel.this.frame.highlightAny.setSelected(bl);
                if (bl) {
                    BasePanel.this.frame.highlightAll.setSelected(false);
                    Globals.prefs.putBoolean("highlightGroupsMatchingAll", false);
                }
                BasePanel.this.groupsHighlightListener.listChanged(null);
            }
        });
        this.actions.put("toggleHighlightGroupsMatchingAll", new BaseAction(){

            @Override
            public void action() {
                boolean bl = !Globals.prefs.getBoolean("highlightGroupsMatchingAll");
                Globals.prefs.putBoolean("highlightGroupsMatchingAll", bl);
                BasePanel.this.frame.highlightAll.setSelected(bl);
                if (bl) {
                    BasePanel.this.frame.highlightAny.setSelected(false);
                    Globals.prefs.putBoolean("highlightGroupsMatchingAny", false);
                }
                BasePanel.this.groupsHighlightListener.listChanged(null);
            }
        });
        this.actions.put("switchPreview", new BaseAction(){

            @Override
            public void action() {
                BasePanel.this.selectionListener.switchPreview();
            }
        });
        this.actions.put("manageSelectors", new BaseAction(){

            @Override
            public void action() {
                ContentSelectorDialog2 contentSelectorDialog2 = new ContentSelectorDialog2(BasePanel.this.frame, BasePanel.this.frame, BasePanel.this, false, BasePanel.this.metaData, null);
                Util.placeDialog(contentSelectorDialog2, BasePanel.this.frame);
                contentSelectorDialog2.setVisible(true);
            }
        });
        this.actions.put("exportToClipboard", new ExportToClipboardAction(this.frame, this.database()));
        this.actions.put("sendAsEmail", new SendAsEMailAction(this.frame));
        this.actions.put("writeXMP", new WriteXMPAction(this));
        this.actions.put("abbreviateIso", new AbbreviateAction(this, true));
        this.actions.put("abbreviateMedline", new AbbreviateAction(this, false));
        this.actions.put("unabbreviate", new UnabbreviateAction(this));
        this.actions.put("autoSetPdf", new AutoSetExternalFileForEntries(this, "pdf"));
        this.actions.put("autoSetPs", new AutoSetExternalFileForEntries(this, "ps"));
        this.actions.put("autoSetFile", new SynchronizeFileField(this));
        this.actions.put("back", new BaseAction(){

            @Override
            public void action() throws Throwable {
                BasePanel.this.back();
            }
        });
        this.actions.put("forward", new BaseAction(){

            @Override
            public void action() throws Throwable {
                BasePanel.this.forward();
            }
        });
        this.actions.put("resolveDuplicateKeys", new SearchFixDuplicateLabels(this));
        this.actions.put("addToGroup", new GroupAddRemoveDialog(this, true, false));
        this.actions.put("removeFromGroup", new GroupAddRemoveDialog(this, false, false));
        this.actions.put("moveToGroup", new GroupAddRemoveDialog(this, true, true));
    }

    public void runCommand(String string) {
        if (this.actions.get(string) == null) {
            LOGGER.info("No action defined for '" + string + '\'');
        } else {
            Object object = this.actions.get(string);
            try {
                if (object instanceof BaseAction) {
                    ((BaseAction)object).action();
                } else {
                    Worker worker = ((AbstractWorker)object).getWorker();
                    CallBack callBack = ((AbstractWorker)object).getCallBack();
                    ((AbstractWorker)object).init();
                    worker.run();
                    callBack.update();
                }
            }
            catch (Throwable throwable) {
                this.frame.unblock();
                throwable.printStackTrace();
            }
        }
    }

    private boolean saveDatabase(File file, boolean bl, String string, FileActions.DatabaseSaveType databaseSaveType) throws SaveException {
        SaveSession saveSession;
        this.frame.block();
        try {
            saveSession = !bl ? FileActions.saveDatabase(this.database, this.metaData, file, Globals.prefs, false, false, string, false) : FileActions.savePartOfDatabase(this.database, this.metaData, file, Globals.prefs, this.mainTable.getSelectedEntries(), string, databaseSaveType);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file. Character encoding '%0' is not supported.", string), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
        catch (SaveException saveException) {
            if (saveException.specificEntry()) {
                int n = this.mainTable.findEntry(saveException.getEntry());
                int n2 = Math.max(0, n - 3);
                this.mainTable.setRowSelectionInterval(n, n);
                this.mainTable.scrollTo(n2);
                this.showEntry(saveException.getEntry());
            } else {
                saveException.printStackTrace();
            }
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file") + ".\n" + saveException.getMessage(), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
        finally {
            this.frame.unblock();
        }
        boolean bl2 = true;
        if (!saveSession.getWriter().couldEncodeAll()) {
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
            JTextArea jTextArea = new JTextArea(saveSession.getWriter().getProblemCharacters());
            jTextArea.setEditable(false);
            defaultFormBuilder.append(Globals.lang("The chosen encoding '%0' could not encode the following characters: ", saveSession.getEncoding()));
            defaultFormBuilder.append(jTextArea);
            defaultFormBuilder.append(Globals.lang("What do you want to do?"));
            String string2 = Globals.lang("Try different encoding");
            int n = JOptionPane.showOptionDialog(this.frame, defaultFormBuilder.getPanel(), Globals.lang("Save database"), 1, 2, null, new String[]{Globals.lang("Save"), string2, Globals.lang("Cancel")}, string2);
            if (n == 1) {
                Object object = JOptionPane.showInputDialog(this.frame, Globals.lang("Select encoding"), Globals.lang("Save database"), 3, null, Globals.ENCODINGS, string);
                if (object != null) {
                    String string3 = (String)object;
                    return this.saveDatabase(file, bl, string3, databaseSaveType);
                }
                bl2 = false;
            } else if (n == 2) {
                bl2 = false;
            }
        }
        if (bl2) {
            saveSession.commit();
            this.encoding = string;
        } else {
            saveSession.cancel();
        }
        return bl2;
    }

    public BibtexEntry newEntry(BibtexEntryType bibtexEntryType) {
        Object object;
        if (bibtexEntryType == null) {
            object = new EntryTypeDialog(this.frame);
            Util.placeDialog((Dialog)object, this.frame);
            ((Dialog)object).setVisible(true);
            bibtexEntryType = ((EntryTypeDialog)object).getChoice();
        }
        if (bibtexEntryType != null) {
            object = IdGenerator.next();
            BibtexEntry bibtexEntry = new BibtexEntry((String)object, bibtexEntryType);
            try {
                int n;
                this.database.insertEntry(bibtexEntry);
                ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
                arrayList.add(bibtexEntry);
                Util.setAutomaticFields(arrayList, true, true, false);
                this.undoManager.addEdit(new UndoableInsertEntry(this.database, bibtexEntry, this));
                this.output(Globals.lang("Added new") + " '" + bibtexEntryType.getName().toLowerCase() + "' " + Globals.lang("entry") + '.');
                if (this.mode != 2) {
                    this.mode = 3;
                }
                if ((n = this.mainTable.findEntry(bibtexEntry)) >= 0) {
                    this.highlightEntry(bibtexEntry);
                } else {
                    this.showEntry(bibtexEntry);
                }
                this.markBaseChanged();
                new FocusRequester(this.getEntryEditor(bibtexEntry));
                return bibtexEntry;
            }
            catch (KeyCollisionException keyCollisionException) {
                LOGGER.info(keyCollisionException.getMessage(), keyCollisionException);
            }
        }
        return null;
    }

    public void insertEntry(BibtexEntry bibtexEntry) {
        if (bibtexEntry != null) {
            try {
                this.database.insertEntry(bibtexEntry);
                if (Globals.prefs.getBoolean("useOwner")) {
                    Util.setAutomaticFields(bibtexEntry, true, true);
                }
                this.undoManager.addEdit(new UndoableInsertEntry(this.database, bibtexEntry, this));
                this.output(Globals.lang("Added new") + " '" + bibtexEntry.getType().getName().toLowerCase() + "' " + Globals.lang("entry") + '.');
                this.markBaseChanged();
                if (Globals.prefs.getBoolean("autoOpenForm")) {
                    this.selectionListener.editSignalled(bibtexEntry);
                }
                this.highlightEntry(bibtexEntry);
            }
            catch (KeyCollisionException keyCollisionException) {
                LOGGER.info("Collision for bibtex key" + bibtexEntry.getId(), keyCollisionException);
            }
        }
    }

    public void updateTableFont() {
        this.mainTable.updateFont();
    }

    private void createMainTable() {
        GlazedEntrySorter glazedEntrySorter = new GlazedEntrySorter(this.database.getEntryMap());
        this.database.addDatabaseChangeListener(glazedEntrySorter);
        this.database.addDatabaseChangeListener(SpecialFieldDatabaseChangeListener.getInstance());
        this.groupFilterList = new FilterList<BibtexEntry>(glazedEntrySorter.getTheList(), NoSearchMatcher.INSTANCE);
        this.searchFilterList = new FilterList<BibtexEntry>(this.groupFilterList, NoSearchMatcher.INSTANCE);
        this.tableFormat = new MainTableFormat(this);
        this.tableFormat.updateTableFormat();
        this.mainTable = new MainTable(this.tableFormat, this.searchFilterList, this.frame, this);
        this.selectionListener = new MainTableSelectionListener(this, this.mainTable);
        this.mainTable.updateFont();
        this.mainTable.addSelectionListener(this.selectionListener);
        this.mainTable.addMouseListener(this.selectionListener);
        this.mainTable.addKeyListener(this.selectionListener);
        this.mainTable.addFocusListener(this.selectionListener);
        this.groupsHighlightListener = new ListEventListener<BibtexEntry>(){

            @Override
            public void listChanged(ListEvent<BibtexEntry> listEvent) {
                if (Globals.prefs.getBoolean("highlightGroupsMatchingAny")) {
                    BasePanel.this.getGroupSelector().showMatchingGroups(BasePanel.this.mainTable.getSelectedEntries(), false);
                } else if (Globals.prefs.getBoolean("highlightGroupsMatchingAll")) {
                    BasePanel.this.getGroupSelector().showMatchingGroups(BasePanel.this.mainTable.getSelectedEntries(), true);
                } else {
                    BasePanel.this.getGroupSelector().showMatchingGroups(null, true);
                }
            }
        };
        this.mainTable.addSelectionListener(this.groupsHighlightListener);
        this.mainTable.getActionMap().put("cut", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasePanel.this.runCommand("cut");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        this.mainTable.getActionMap().put("copy", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasePanel.this.runCommand("copy");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        this.mainTable.getActionMap().put("paste", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasePanel.this.runCommand("paste");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        this.mainTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                GroupTreeNode groupTreeNode;
                int n = keyEvent.getKeyCode();
                TreePath treePath = BasePanel.this.frame.groupSelector.getSelectionPath();
                GroupTreeNode groupTreeNode2 = groupTreeNode = treePath == null ? null : (GroupTreeNode)treePath.getLastPathComponent();
                if (keyEvent.isControlDown()) {
                    switch (n) {
                        case 38: {
                            keyEvent.consume();
                            if (groupTreeNode == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeUp(groupTreeNode, true);
                            break;
                        }
                        case 40: {
                            keyEvent.consume();
                            if (groupTreeNode == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeDown(groupTreeNode, true);
                            break;
                        }
                        case 37: {
                            keyEvent.consume();
                            if (groupTreeNode == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeLeft(groupTreeNode, true);
                            break;
                        }
                        case 39: {
                            keyEvent.consume();
                            if (groupTreeNode == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeRight(groupTreeNode, true);
                            break;
                        }
                        case 34: {
                            BasePanel.this.frame.nextTab.actionPerformed(null);
                            keyEvent.consume();
                            break;
                        }
                        case 33: {
                            BasePanel.this.frame.prevTab.actionPerformed(null);
                            keyEvent.consume();
                        }
                    }
                } else if (n == 10) {
                    keyEvent.consume();
                    try {
                        BasePanel.this.runCommand("edit");
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        });
    }

    public void setupMainPanel() {
        this.splitPane = new JSplitPane(0);
        this.splitPane.setDividerSize(4);
        this.createMainTable();
        for (EntryEditor entryEditor : this.entryEditors.values()) {
            entryEditor.validateAllFields();
        }
        this.splitPane.setTopComponent(this.mainTable.getPane());
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.setBorder(BorderFactory.createEmptyBorder());
        if (this.mode == 1) {
            this.mode = 0;
            int n = this.mainTable.findEntry(this.currentPreview.entry);
            if (n >= 0) {
                this.mainTable.setRowSelectionInterval(n, n);
            }
        } else if (this.mode == 2) {
            this.mode = 0;
        } else {
            this.splitPane.setBottomComponent(null);
        }
        this.setLayout(new BorderLayout());
        this.removeAll();
        this.add((Component)this.splitPane, "Center");
        this.instantiateSearchAutoCompleter();
        this.getDatabase().addDatabaseChangeListener(new SearchAutoCompleterUpdater());
        if (Globals.prefs.getBoolean("autoComplete")) {
            this.autoCompleters = new ContentAutoCompleters(this.getDatabase(), this.metaData);
            this.getDatabase().addDatabaseChangeListener(new AutoCompletersUpdater());
        } else {
            this.autoCompleters = new ContentAutoCompleters();
        }
        this.splitPane.revalidate();
        this.revalidate();
        this.repaint();
    }

    public void updateSearchManager() {
        this.frame.getSearchManager().setAutoCompleteListener(this.searchCompleteListener);
    }

    private void instantiateSearchAutoCompleter() {
        this.searchAutoCompleter = AutoCompleterFactory.getFor("author", "editor");
        for (BibtexEntry bibtexEntry : this.database.getEntries()) {
            this.searchAutoCompleter.addBibtexEntry(bibtexEntry);
        }
        this.searchCompleteListener = new AutoCompleteListener(this.searchAutoCompleter);
        this.searchCompleteListener.setConsumeEnterKey(false);
    }

    public void updatePreamble() {
        if (this.preambleEditor != null) {
            this.preambleEditor.updatePreamble();
        }
    }

    public void assureStringDialogNotEditing() {
        if (this.stringDialog != null) {
            this.stringDialog.assureNotEditing();
        }
    }

    public void updateStringDialog() {
        if (this.stringDialog != null) {
            this.stringDialog.refreshTable();
        }
    }

    public void updateEntryPreviewToRow(BibtexEntry bibtexEntry) {
    }

    public void adjustSplitter() {
        int n = this.getMode();
        if (n == 1) {
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - Globals.prefs.getInt("previewPanelHeight"));
        } else {
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - Globals.prefs.getInt("entryEditorHeight"));
        }
    }

    public boolean entryEditorAllowsChange() {
        Component component = this.splitPane.getBottomComponent();
        if (component instanceof EntryEditor) {
            return ((EntryEditor)component).lastSourceAccepted();
        }
        return true;
    }

    public void moveFocusToEntryEditor() {
        Component component = this.splitPane.getBottomComponent();
        if (component instanceof EntryEditor) {
            new FocusRequester(component);
        }
    }

    private boolean isShowingEditor() {
        return this.splitPane.getBottomComponent() != null && this.splitPane.getBottomComponent() instanceof EntryEditor;
    }

    public void showEntry(BibtexEntry bibtexEntry) {
        if (this.getShowing() == bibtexEntry) {
            if (this.splitPane.getBottomComponent() == null) {
                this.newEntryShowing(null);
                this.showEntry(bibtexEntry);
            } else {
                ((EntryEditor)this.splitPane.getBottomComponent()).updateAllFields();
            }
            return;
        }
        int n = -1;
        String string = null;
        if (this.getShowing() != null && this.isShowingEditor()) {
            string = ((EntryEditor)this.splitPane.getBottomComponent()).getVisiblePanelName();
        }
        if (this.getShowing() != null) {
            n = this.splitPane.getDividerLocation();
        }
        if (this.entryEditors.containsKey(bibtexEntry.getType().getName())) {
            EntryEditor entryEditor = this.entryEditors.get(bibtexEntry.getType().getName());
            entryEditor.switchTo(bibtexEntry);
            if (string != null) {
                entryEditor.setVisiblePanel(string);
            }
            this.splitPane.setBottomComponent(entryEditor);
        } else {
            EntryEditor entryEditor = new EntryEditor(this.frame, this, bibtexEntry);
            if (string != null) {
                entryEditor.setVisiblePanel(string);
            }
            this.splitPane.setBottomComponent(entryEditor);
            this.entryEditors.put(bibtexEntry.getType().getName(), entryEditor);
        }
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
        } else {
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - Globals.prefs.getInt("entryEditorHeight"));
        }
        this.newEntryShowing(bibtexEntry);
        this.setEntryEditorEnabled(true);
    }

    public EntryEditor getEntryEditor(BibtexEntry bibtexEntry) {
        EntryEditor entryEditor;
        if (this.entryEditors.containsKey(bibtexEntry.getType().getName())) {
            EntryEditor entryEditor2 = this.currentEditor;
            entryEditor = this.entryEditors.get(bibtexEntry.getType().getName());
            if (entryEditor2 != null && entryEditor != entryEditor2) {
                entryEditor2.storeCurrentEdit();
            }
            entryEditor.switchTo(bibtexEntry);
        } else {
            this.storeCurrentEdit();
            entryEditor = new EntryEditor(this.frame, this, bibtexEntry);
            this.entryEditors.put(bibtexEntry.getType().getName(), entryEditor);
        }
        return entryEditor;
    }

    public EntryEditor getCurrentEditor() {
        return this.currentEditor;
    }

    public void showEntryEditor(EntryEditor entryEditor) {
        if (this.mode == 2) {
            Globals.prefs.putInt("entryEditorHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        } else if (this.mode == 1) {
            Globals.prefs.putInt("previewPanelHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        }
        this.mode = 2;
        this.currentEditor = entryEditor;
        this.splitPane.setBottomComponent(entryEditor);
        if (entryEditor.getEntry() != this.getShowing()) {
            this.newEntryShowing(entryEditor.getEntry());
        }
        this.adjustSplitter();
    }

    public void showPreview(PreviewPanel previewPanel) {
        this.mode = 1;
        this.currentPreview = previewPanel;
        this.splitPane.setBottomComponent(previewPanel);
    }

    public void hideBottomComponent() {
        this.mode = 0;
        this.splitPane.setBottomComponent(null);
    }

    public void highlightEntry(BibtexEntry bibtexEntry) {
        int n = this.mainTable.findEntry(bibtexEntry);
        if (n >= 0) {
            this.mainTable.setRowSelectionInterval(n, n);
            this.mainTable.ensureVisible(n);
        }
    }

    public void entryEditorClosing(EntryEditor entryEditor) {
        Globals.prefs.putInt("entryEditorHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        this.selectionListener.entryEditorClosing(entryEditor);
    }

    public void ensureNotShowing(BibtexEntry bibtexEntry) {
        if (this.mode == 2 && this.currentEditor.getEntry() == bibtexEntry) {
            this.selectionListener.entryEditorClosing(this.currentEditor);
        }
    }

    public void updateEntryEditorIfShowing() {
        if (this.mode == 2) {
            if (this.currentEditor.getType() != this.currentEditor.getEntry().getType()) {
                this.newEntryShowing(null);
                EntryEditor entryEditor = this.getEntryEditor(this.currentEditor.getEntry());
                this.showEntryEditor(entryEditor);
            } else {
                this.currentEditor.updateAllFields();
                this.currentEditor.updateSource();
            }
        }
    }

    public void storeCurrentEdit() {
        if (this.isShowingEditor()) {
            EntryEditor entryEditor = (EntryEditor)this.splitPane.getBottomComponent();
            entryEditor.storeCurrentEdit();
        }
    }

    public void updateAllContentSelectors() {
        for (Map.Entry<String, EntryEditor> entry : this.entryEditors.entrySet()) {
            EntryEditor entryEditor = entry.getValue();
            entryEditor.updateAllContentSelectors();
        }
    }

    public void rebuildAllEntryEditors() {
        for (Map.Entry<String, EntryEditor> entry : this.entryEditors.entrySet()) {
            EntryEditor entryEditor = entry.getValue();
            entryEditor.rebuildPanels();
        }
    }

    public void markBaseChanged() {
        this.baseChanged = true;
        String string = this.frame.getTabTitle(this);
        if (!string.endsWith("*")) {
            this.frame.setTabTitle(this, string + '*', this.frame.getTabTooltip(this));
            this.frame.setWindowTitle();
        }
        if (this.frame.statusLine.getText().startsWith(Globals.lang("Saved database"))) {
            this.frame.output(" ");
        }
    }

    public void markNonUndoableBaseChanged() {
        this.nonUndoableChange = true;
        this.markBaseChanged();
    }

    private synchronized void markChangedOrUnChanged() {
        if (this.undoManager.hasChanged()) {
            if (!this.baseChanged) {
                this.markBaseChanged();
            }
        } else if (this.baseChanged && !this.nonUndoableChange) {
            this.baseChanged = false;
            if (this.getFile() != null) {
                this.frame.setTabTitle(this, this.getFile().getName(), this.getFile().getAbsolutePath());
            } else {
                this.frame.setTabTitle(this, Globals.lang("untitled"), null);
            }
        }
        this.frame.setWindowTitle();
    }

    public void selectSingleEntry(int n) {
        this.mainTable.clearSelection();
        this.mainTable.addRowSelectionInterval(n, n);
        this.mainTable.scrollToCenter(n, 0);
    }

    public void setSearchMatcher(SearchMatcher searchMatcher) {
        this.searchFilterList.setMatcher(searchMatcher);
        this.showingSearch = true;
    }

    public void setGroupMatcher(Matcher<BibtexEntry> matcher) {
        this.groupFilterList.setMatcher(matcher);
    }

    public void stopShowingSearchResults() {
        this.searchFilterList.setMatcher(NoSearchMatcher.INSTANCE);
        this.showingSearch = false;
    }

    public void stopShowingGroup() {
        this.groupFilterList.setMatcher(NoSearchMatcher.INSTANCE);
    }

    public boolean isShowingFloatSearch() {
        return this.mainTable.isShowingFloatSearch();
    }

    public boolean isShowingFilterSearch() {
        return this.showingSearch;
    }

    public BibtexDatabase getDatabase() {
        return this.database;
    }

    public void preambleEditorClosing() {
        this.preambleEditor = null;
    }

    public void stringsClosing() {
        this.stringDialog = null;
    }

    public void changeType(BibtexEntry bibtexEntry, BibtexEntryType bibtexEntryType) {
        this.changeType(new BibtexEntry[]{bibtexEntry}, bibtexEntryType);
    }

    public void changeType(BibtexEntryType bibtexEntryType) {
        BibtexEntry[] bibtexEntryArray = this.mainTable.getSelectedEntries();
        this.changeType(bibtexEntryArray, bibtexEntryType);
    }

    private void changeType(BibtexEntry[] bibtexEntryArray, BibtexEntryType bibtexEntryType) {
        int n;
        if (bibtexEntryArray == null || bibtexEntryArray.length == 0) {
            this.output("First select the entries you wish to change type for.");
            return;
        }
        if (bibtexEntryArray.length > 1 && (n = JOptionPane.showConfirmDialog(this, "Multiple entries selected. Do you want to change\nthe type of all these to '" + bibtexEntryType.getName() + "'?", "Change type", 0, 2)) == 1) {
            return;
        }
        NamedCompound namedCompound = new NamedCompound(Globals.lang("change type"));
        for (BibtexEntry bibtexEntry : bibtexEntryArray) {
            namedCompound.addEdit(new UndoableChangeType(bibtexEntry, bibtexEntry.getType(), bibtexEntryType));
            bibtexEntry.setType(bibtexEntryType);
        }
        this.output(Globals.lang("Changed type to") + " '" + bibtexEntryType.getName() + "' " + Globals.lang("for") + ' ' + bibtexEntryArray.length + ' ' + Globals.lang("entries") + '.');
        namedCompound.end();
        this.undoManager.addEdit(namedCompound);
        this.markBaseChanged();
        this.updateEntryEditorIfShowing();
    }

    public boolean showDeleteConfirmationDialog(int n) {
        if (Globals.prefs.getBoolean("confirmDelete")) {
            String string = Globals.lang("Really delete the selected") + ' ' + Globals.lang("entry") + '?';
            String string2 = Globals.lang("Delete entry");
            if (n > 1) {
                string = Globals.lang("Really delete the selected") + ' ' + n + ' ' + Globals.lang("entries") + '?';
                string2 = Globals.lang("Delete multiple entries");
            }
            CheckBoxMessage checkBoxMessage = new CheckBoxMessage(string, Globals.lang("Disable this confirmation dialog"), false);
            int n2 = JOptionPane.showConfirmDialog(this.frame, checkBoxMessage, string2, 0, 3);
            if (checkBoxMessage.isSelected()) {
                Globals.prefs.putBoolean("confirmDelete", false);
            }
            return n2 == 0;
        }
        return true;
    }

    public void autoGenerateKeysBeforeSaving() {
        if (Globals.prefs.getBoolean("generateKeysBeforeSaving")) {
            NamedCompound namedCompound = new NamedCompound(Globals.lang("autogenerate keys"));
            boolean bl = false;
            for (BibtexEntry bibtexEntry : this.database.getEntries()) {
                String string = bibtexEntry.getCiteKey();
                if (string != null && !string.isEmpty()) continue;
                LabelPatternUtil.makeLabel(this.metaData, this.database, bibtexEntry);
                namedCompound.addEdit(new UndoableKeyChange(this.database, bibtexEntry.getId(), null, bibtexEntry.getField("bibtexkey")));
                bl = true;
            }
            if (bl) {
                namedCompound.end();
                this.undoManager.addEdit(namedCompound);
            }
        }
    }

    public void setPreviewActive(boolean bl) {
        this.selectionListener.setPreviewActive(bl);
    }

    public void setSelectionListenerEnabled(boolean bl) {
        this.selectionListener.setEnabled(bl);
    }

    public void saveDividerLocation() {
        if (this.mode == 1) {
            Globals.prefs.putInt("previewPanelHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        } else if (this.mode == 2) {
            Globals.prefs.putInt("entryEditorHeight", this.splitPane.getHeight() - this.splitPane.getDividerLocation());
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private void setEntryEditorEnabled(boolean bl) {
        EntryEditor entryEditor;
        if (this.getShowing() != null && this.splitPane.getBottomComponent() instanceof EntryEditor && (entryEditor = (EntryEditor)this.splitPane.getBottomComponent()).isEnabled() != bl) {
            entryEditor.setEnabled(bl);
        }
    }

    public String fileMonitorHandle() {
        return this.fileMonitorHandle;
    }

    @Override
    public void fileUpdated() {
        if (this.saving) {
            return;
        }
        this.updatedExternally = true;
        final ChangeScanner changeScanner = new ChangeScanner(this.frame, this, this.getFile());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean bl = BasePanel.this.sidePaneManager.hasComponent("fileUpdate");
                if (bl) {
                    BasePanel.this.sidePaneManager.hideComponent("fileUpdate");
                    BasePanel.this.sidePaneManager.unregisterComponent("fileUpdate");
                }
                FileUpdatePanel fileUpdatePanel = new FileUpdatePanel(BasePanel.this.frame, BasePanel.this, BasePanel.this.sidePaneManager, BasePanel.this.getFile(), changeScanner);
                BasePanel.this.sidePaneManager.register("fileUpdate", fileUpdatePanel);
                BasePanel.this.sidePaneManager.show("fileUpdate");
            }
        };
        if (this.getFile() != null && !FileBasedLock.waitForFileLock(this.getFile(), 10)) {
            System.err.println("File updated externally, but change scan failed because the file is locked.");
            Globals.fileUpdateMonitor.perturbTimestamp(this.getFileMonitorHandle());
            return;
        }
        JabRefExecutorService.INSTANCE.executeWithLowPriorityInOwnThreadAndWait(changeScanner);
        if (changeScanner.changesFound()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            this.setUpdatedExternally(false);
        }
    }

    @Override
    public void fileRemoved() {
        LOGGER.info("File '" + this.getFile().getPath() + "' has been deleted.");
    }

    public void cleanUp() {
        FileUpdatePanel fileUpdatePanel;
        if (this.fileMonitorHandle != null) {
            Globals.fileUpdateMonitor.removeUpdateListener(this.fileMonitorHandle);
        }
        if (this.sidePaneManager.hasComponent("fileUpdate") && (fileUpdatePanel = (FileUpdatePanel)this.sidePaneManager.getComponent("fileUpdate")).getPanel() == this) {
            this.sidePaneManager.hideComponent("fileUpdate");
        }
    }

    public void setUpdatedExternally(boolean bl) {
        this.updatedExternally = bl;
    }

    public BibtexEntry[] getSelectedEntries() {
        return this.mainTable.getSelectedEntries();
    }

    public File getFile() {
        return this.metaData.getFile();
    }

    public String getKeysForSelection() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (BibtexEntry bibtexEntry : this.mainTable.getSelected()) {
            String string = bibtexEntry.getField("bibtexkey");
            if (string == null || string.isEmpty()) continue;
            if (bl) {
                stringBuilder.append(string);
                bl = false;
                continue;
            }
            stringBuilder.append(',').append(string);
        }
        return stringBuilder.toString();
    }

    public GroupSelector getGroupSelector() {
        return this.frame.groupSelector;
    }

    public boolean isUpdatedExternally() {
        return this.updatedExternally;
    }

    public String getFileMonitorHandle() {
        return this.fileMonitorHandle;
    }

    public void setFileMonitorHandle(String string) {
        this.fileMonitorHandle = string;
    }

    public SidePaneManager getSidePaneManager() {
        return this.sidePaneManager;
    }

    public void setNonUndoableChange(boolean bl) {
        this.nonUndoableChange = bl;
    }

    public void setBaseChanged(boolean bl) {
        this.baseChanged = bl;
    }

    public void setSaving(boolean bl) {
        this.saving = bl;
    }

    public boolean isSaving() {
        return this.saving;
    }

    private BibtexEntry getShowing() {
        return this.showing;
    }

    public void newEntryShowing(BibtexEntry bibtexEntry) {
        if (this.backOrForwardInProgress) {
            this.showing = bibtexEntry;
            this.backOrForwardInProgress = false;
            this.setBackAndForwardEnabledState();
            return;
        }
        this.nextEntries.clear();
        if (bibtexEntry != this.showing) {
            if (this.showing != null) {
                this.previousEntries.add(this.showing);
                if (this.previousEntries.size() > 10) {
                    this.previousEntries.remove(0);
                }
            }
            this.showing = bibtexEntry;
            this.setBackAndForwardEnabledState();
        }
    }

    private void back() {
        if (!this.previousEntries.isEmpty()) {
            BibtexEntry bibtexEntry = this.previousEntries.get(this.previousEntries.size() - 1);
            this.previousEntries.remove(this.previousEntries.size() - 1);
            if (this.showing != null) {
                this.nextEntries.add(this.showing);
            }
            this.backOrForwardInProgress = true;
            this.highlightEntry(bibtexEntry);
        }
    }

    private void forward() {
        if (!this.nextEntries.isEmpty()) {
            BibtexEntry bibtexEntry = this.nextEntries.get(this.nextEntries.size() - 1);
            this.nextEntries.remove(this.nextEntries.size() - 1);
            if (this.showing != null) {
                this.previousEntries.add(this.showing);
            }
            this.backOrForwardInProgress = true;
            this.highlightEntry(bibtexEntry);
        }
    }

    public void setBackAndForwardEnabledState() {
        this.frame.back.setEnabled(!this.previousEntries.isEmpty());
        this.frame.forward.setEnabled(!this.nextEntries.isEmpty());
    }

    private class SaveSelectedAction
    implements BaseAction {
        private final FileActions.DatabaseSaveType saveType;

        public SaveSelectedAction(FileActions.DatabaseSaveType databaseSaveType) {
            this.saveType = databaseSaveType;
        }

        @Override
        public void action() throws Throwable {
            File file;
            String string = FileDialogs.getNewFile(BasePanel.this.frame, new File(Globals.prefs.get("workingDirectory")), ".bib", 1, false);
            if (!(string == null || (file = new File(string)).exists() && JOptionPane.showConfirmDialog(BasePanel.this.frame, '\'' + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Save database"), 2) != 0)) {
                BasePanel.this.saveDatabase(file, true, Globals.prefs.get("defaultEncoding"), this.saveType);
                BasePanel.this.frame.getFileHistory().newFile(file.getPath());
                BasePanel.this.frame.output(Globals.lang("Saved selected to") + " '" + file.getPath() + "'.");
            }
        }
    }

    class RedoAction
    implements BaseAction {
        RedoAction() {
        }

        @Override
        public void action() {
            try {
                JComponent jComponent = Globals.focusListener.getFocused();
                if (jComponent != null && jComponent instanceof FieldEditor && jComponent.hasFocus()) {
                    BasePanel.this.storeCurrentEdit();
                }
                String string = BasePanel.this.undoManager.getRedoPresentationName();
                BasePanel.this.undoManager.redo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.frame.output(string);
            }
            catch (CannotRedoException cannotRedoException) {
                BasePanel.this.frame.output(Globals.lang("Nothing to redo") + '.');
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }

    class UndoAction
    implements BaseAction {
        UndoAction() {
        }

        @Override
        public void action() {
            try {
                JComponent jComponent = Globals.focusListener.getFocused();
                if (jComponent != null && jComponent instanceof FieldEditor && jComponent.hasFocus()) {
                    if (BasePanel.this.preambleEditor != null && jComponent == BasePanel.this.preambleEditor.getFieldEditor()) {
                        BasePanel.this.preambleEditor.storeCurrentEdit();
                    } else {
                        BasePanel.this.storeCurrentEdit();
                    }
                }
                String string = BasePanel.this.undoManager.getUndoPresentationName();
                BasePanel.this.undoManager.undo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.frame.output(string);
            }
            catch (CannotUndoException cannotUndoException) {
                cannotUndoException.printStackTrace();
                BasePanel.this.frame.output(Globals.lang("Nothing to undo") + '.');
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }

    private class AutoCompletersUpdater
    implements DatabaseChangeListener {
        private AutoCompletersUpdater() {
        }

        @Override
        public void databaseChanged(DatabaseChangeEvent databaseChangeEvent) {
            if (databaseChangeEvent.getType() == DatabaseChangeEvent.ChangeType.CHANGED_ENTRY || databaseChangeEvent.getType() == DatabaseChangeEvent.ChangeType.ADDED_ENTRY) {
                BasePanel.this.autoCompleters.addEntry(databaseChangeEvent.getEntry());
            }
        }
    }

    private class SearchAutoCompleterUpdater
    implements DatabaseChangeListener {
        private SearchAutoCompleterUpdater() {
        }

        @Override
        public void databaseChanged(DatabaseChangeEvent databaseChangeEvent) {
            if (databaseChangeEvent.getType() == DatabaseChangeEvent.ChangeType.CHANGED_ENTRY || databaseChangeEvent.getType() == DatabaseChangeEvent.ChangeType.ADDED_ENTRY) {
                BasePanel.this.searchAutoCompleter.addBibtexEntry(databaseChangeEvent.getEntry());
            }
        }
    }

    private class GroupTreeUpdater
    implements DatabaseChangeListener {
        private GroupTreeUpdater() {
        }

        @Override
        public void databaseChanged(DatabaseChangeEvent databaseChangeEvent) {
            if (databaseChangeEvent.getType() == DatabaseChangeEvent.ChangeType.ADDED_ENTRY && Globals.prefs.getBoolean("autoAssignGroup") && BasePanel.this.frame.groupToggle.isSelected()) {
                BibtexEntry[] bibtexEntryArray = new BibtexEntry[]{databaseChangeEvent.getEntry()};
                TreePath[] treePathArray = BasePanel.this.frame.groupSelector.getGroupsTree().getSelectionPaths();
                if (treePathArray != null) {
                    for (TreePath treePath : treePathArray) {
                        ((GroupTreeNode)treePath.getLastPathComponent()).addToGroup(bibtexEntryArray);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BasePanel.this.getGroupSelector().valueChanged(null);
                    }
                });
            }
        }
    }
}

