/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.update;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.CommandUtils;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.PipedFilesBuilder;
import org.netbeans.lib.cvsclient.command.TemporaryFileCreator;
import org.netbeans.lib.cvsclient.command.update.UpdateBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.UnchangedRequest;

public class UpdateCommand
extends BasicCommand
implements TemporaryFileCreator {
    private static final String RENAME_FORMAT = "{0}/.#{1}.{2}";
    private static final Object[] FORMAT_PARAMETER = new Object[3];
    private final Set emptyDirectories = new HashSet();
    private boolean buildDirectories;
    private boolean cleanCopy;
    private boolean pruneDirectories;
    private boolean pipeToOutput;
    private boolean resetStickyOnes;
    private boolean useHeadIfNotFound;
    private String updateByDate;
    private String updateByRevision;
    private KeywordSubstitutionOptions keywordSubst;
    private String mergeRevision1;
    private String mergeRevision2;

    public UpdateCommand() {
        this.resetCVSCommand();
    }

    public Builder createBuilder(EventManager eventManager) {
        if (this.isPipeToOutput()) {
            return new PipedFilesBuilder(eventManager, this, this);
        }
        return new UpdateBuilder(eventManager, this.getLocalDirectory());
    }

    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        if (this.isCleanCopy() && file != null && entry != null && !this.isPipeToOutput()) {
            UpdateCommand.FORMAT_PARAMETER[0] = file.getParent();
            UpdateCommand.FORMAT_PARAMETER[1] = file.getName();
            UpdateCommand.FORMAT_PARAMETER[2] = entry.getRevision();
            String filename = MessageFormat.format(RENAME_FORMAT, FORMAT_PARAMETER);
            try {
                FileUtils.copyFile(file, new File(filename));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.sendEntryAndModifiedRequests(entry, file);
    }

    public void setBuildDirectories(boolean buildDirectories) {
        this.buildDirectories = buildDirectories;
    }

    public boolean isBuildDirectories() {
        return this.buildDirectories;
    }

    public void setCleanCopy(boolean cleanCopy) {
        this.cleanCopy = cleanCopy;
        this.setSendModifiedContents(!cleanCopy);
    }

    public boolean isCleanCopy() {
        return this.cleanCopy;
    }

    public void setPruneDirectories(boolean pruneDirectories) {
        this.pruneDirectories = pruneDirectories;
    }

    public boolean isPruneDirectories() {
        return this.pruneDirectories;
    }

    public void execute(ClientServices client, EventManager eventManager) throws CommandException, AuthenticationException {
        client.ensureConnection();
        super.execute(client, eventManager);
        this.emptyDirectories.clear();
        try {
            try {
                if (!this.isRecursive()) {
                    this.requests.add(1, new ArgumentRequest("-l"));
                }
                if (this.isBuildDirectories()) {
                    this.requests.add(1, new ArgumentRequest("-d"));
                }
                if (this.isCleanCopy() && !this.isPipeToOutput()) {
                    this.requests.add(1, new ArgumentRequest("-C"));
                }
                if (this.isPipeToOutput()) {
                    this.requests.add(1, new ArgumentRequest("-p"));
                }
                if (this.isResetStickyOnes()) {
                    this.requests.add(1, new ArgumentRequest("-A"));
                }
                if (this.isUseHeadIfNotFound()) {
                    this.requests.add(1, new ArgumentRequest("-f"));
                }
                if (this.getUpdateByDate() != null) {
                    this.requests.add(1, new ArgumentRequest("-D"));
                    this.requests.add(2, new ArgumentRequest(this.getUpdateByDate()));
                } else if (this.getUpdateByRevision() != null) {
                    this.requests.add(1, new ArgumentRequest("-r"));
                    this.requests.add(2, new ArgumentRequest(this.getUpdateByRevision()));
                }
                if (this.getMergeRevision1() != null) {
                    this.requests.add(1, new ArgumentRequest("-j"));
                    this.requests.add(2, new ArgumentRequest(this.getMergeRevision1()));
                    if (this.getMergeRevision2() != null) {
                        this.requests.add(3, new ArgumentRequest("-j"));
                        this.requests.add(4, new ArgumentRequest(this.getMergeRevision2()));
                    }
                }
                if (this.getKeywordSubst() != null) {
                    this.requests.add(1, new ArgumentRequest("-k"));
                    this.requests.add(2, new ArgumentRequest(this.getKeywordSubst().toString()));
                }
                this.requests.add(1, new ArgumentRequest("-u"));
                this.addRequestForWorkingDirectory(client);
                this.addArgumentRequests();
                this.addRequest(CommandRequest.UPDATE);
                if (this.isPipeToOutput() && (this.getUpdateByRevision() != null || this.getUpdateByDate() != null)) {
                    ListIterator<Request> it = this.requests.listIterator();
                    while (it.hasNext()) {
                        Object req = it.next();
                        if (!(req instanceof EntryRequest)) continue;
                        EntryRequest eReq = (EntryRequest)req;
                        Entry entry = eReq.getEntry();
                        if (entry.getRevision().startsWith("-")) {
                            entry.setRevision(entry.getRevision().substring(1));
                        }
                        it.set(new EntryRequest(entry));
                        it.add(new UnchangedRequest(entry.getName()));
                    }
                }
                client.processRequests(this.requests);
                if (this.pruneDirectories && (this.getGlobalOptions() == null || !this.getGlobalOptions().isDoNoChanges())) {
                    this.pruneEmptyDirectories(client);
                }
            }
            catch (CommandException ex) {
                throw ex;
            }
            catch (EOFException ex) {
                throw new CommandException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
            }
            catch (Exception ex) {
                throw new CommandException(ex, ex.getLocalizedMessage());
            }
        }
        finally {
            this.requests.clear();
        }
    }

    public boolean isPipeToOutput() {
        return this.pipeToOutput;
    }

    public void setPipeToOutput(boolean pipeToOutput) {
        this.pipeToOutput = pipeToOutput;
    }

    public boolean isResetStickyOnes() {
        return this.resetStickyOnes;
    }

    public void setResetStickyOnes(boolean resetStickyOnes) {
        this.resetStickyOnes = resetStickyOnes;
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean useHeadIfNotFound) {
        this.useHeadIfNotFound = useHeadIfNotFound;
    }

    public String getUpdateByDate() {
        return this.updateByDate;
    }

    public void setUpdateByDate(String updateByDate) {
        this.updateByDate = UpdateCommand.getTrimmedString(updateByDate);
    }

    public String getUpdateByRevision() {
        return this.updateByRevision;
    }

    public void setUpdateByRevision(String updateByRevision) {
        this.updateByRevision = UpdateCommand.getTrimmedString(updateByRevision);
    }

    public KeywordSubstitutionOptions getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitutionOptions keywordSubst) {
        this.keywordSubst = keywordSubst;
    }

    public File createTempFile(String filename) throws IOException {
        File temp = File.createTempFile("cvs", ".dff", this.getGlobalOptions().getTempDir());
        return temp;
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("update ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            int index = 0;
            while (index < files.length) {
                toReturn.append(files[index].getName());
                toReturn.append(' ');
                ++index;
            }
        }
        return toReturn.toString();
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (this.isPipeToOutput()) {
            toReturn.append("-p ");
        }
        if (this.isCleanCopy()) {
            toReturn.append("-C ");
        }
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.isBuildDirectories()) {
            toReturn.append("-d ");
        }
        if (this.isPruneDirectories()) {
            toReturn.append("-P ");
        }
        if (this.isResetStickyOnes()) {
            toReturn.append("-A ");
        }
        if (this.isUseHeadIfNotFound()) {
            toReturn.append("-f ");
        }
        if (this.getKeywordSubst() != null) {
            toReturn.append("-k");
            toReturn.append(this.getKeywordSubst().toString());
            toReturn.append(' ');
        }
        if (this.getUpdateByRevision() != null) {
            toReturn.append("-r ");
            toReturn.append(this.getUpdateByRevision());
            toReturn.append(' ');
        }
        if (this.getUpdateByDate() != null) {
            toReturn.append("-D ");
            toReturn.append(this.getUpdateByDate());
            toReturn.append(' ');
        }
        if (this.getMergeRevision1() != null) {
            toReturn.append("-j ");
            toReturn.append(this.getMergeRevision1());
            toReturn.append(' ');
            if (this.getMergeRevision2() != null) {
                toReturn.append("-j ");
                toReturn.append(this.getMergeRevision2());
                toReturn.append(' ');
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'C') {
            this.setCleanCopy(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'd') {
            this.setBuildDirectories(true);
        } else if (opt == 'P') {
            this.setPruneDirectories(true);
        } else if (opt == 'A') {
            this.setResetStickyOnes(true);
        } else if (opt == 'f') {
            this.setUseHeadIfNotFound(true);
        } else if (opt == 'D') {
            this.setUpdateByDate(optArg.trim());
        } else if (opt == 'r') {
            this.setUpdateByRevision(optArg.trim());
        } else if (opt == 'k') {
            KeywordSubstitutionOptions keywordSubst = KeywordSubstitutionOptions.findKeywordSubstOption(optArg);
            this.setKeywordSubst(keywordSubst);
        } else if (opt == 'p') {
            this.setPipeToOutput(true);
        } else if (opt == 'j') {
            if (this.getMergeRevision1() == null) {
                this.setMergeRevision1(optArg);
            } else {
                this.setMergeRevision2(optArg);
            }
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setCleanCopy(false);
        this.setBuildDirectories(false);
        this.setPruneDirectories(false);
        this.setResetStickyOnes(false);
        this.setUseHeadIfNotFound(false);
        this.setUpdateByDate(null);
        this.setUpdateByRevision(null);
        this.setKeywordSubst(null);
        this.setPipeToOutput(false);
        this.setMergeRevision1(null);
        this.setMergeRevision2(null);
    }

    public void messageSent(MessageEvent e) {
        super.messageSent(e);
        if (!this.pruneDirectories) {
            return;
        }
        String relativePath = CommandUtils.getExaminedDirectory(e.getMessage(), ": Updating");
        if (relativePath == null) {
            return;
        }
        if (relativePath.equals(".")) {
            return;
        }
        this.emptyDirectories.add(new File(this.getLocalDirectory(), relativePath));
    }

    private boolean pruneEmptyDirectory(File directory, ClientServices client) throws IOException {
        File[] contents = directory.listFiles();
        if (contents == null) {
            return true;
        }
        int i = 0;
        while (i < contents.length) {
            if (contents[i].isFile()) {
                return false;
            }
            if (!contents[i].getName().equals("CVS") && !this.pruneEmptyDirectory(contents[i], client)) {
                return false;
            }
            ++i;
        }
        if (new File(directory, "CVS/Entries").isFile() && new File(directory, "CVS/Repository").isFile()) {
            File adminDir = new File(directory, "CVS");
            Iterator i2 = this.clientServices.getEntries(directory);
            while (i2.hasNext()) {
                Entry entry = (Entry)i2.next();
                if (entry.getName() == null || !entry.isUserFileToBeRemoved()) continue;
                return false;
            }
            this.deleteRecursively(adminDir);
            directory.delete();
            if (!client.exists(directory)) {
                client.removeEntry(directory);
            }
            return true;
        }
        return false;
    }

    private void deleteRecursively(File dir) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                this.deleteRecursively(file);
            } else {
                file.delete();
            }
            ++i;
        }
        dir.delete();
    }

    private void pruneEmptyDirectories(ClientServices client) throws IOException {
        Iterator it = this.emptyDirectories.iterator();
        while (it.hasNext()) {
            File dir = (File)it.next();
            if (!dir.exists()) continue;
            this.pruneEmptyDirectory(dir, client);
        }
        this.emptyDirectories.clear();
    }

    public String getOptString() {
        return "RCnldPAfD:r:pj:k:";
    }

    public String getMergeRevision1() {
        return this.mergeRevision1;
    }

    public void setMergeRevision1(String mergeRevision1) {
        this.mergeRevision1 = UpdateCommand.getTrimmedString(mergeRevision1);
    }

    public String getMergeRevision2() {
        return this.mergeRevision2;
    }

    public void setMergeRevision2(String mergeRevision2) {
        this.mergeRevision2 = UpdateCommand.getTrimmedString(mergeRevision2);
    }
}

